/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core.edit;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import oracle.ide.print.api.PrintPage;
import oracle.ide.print.api.PrintProvider;
import oracle.ide.print.misc.Util;

public final class Provider
implements PrintProvider {
    private String myName;
    private Component myComponent;
    private Component myGutter;
    private int mySelectionStart;
    private int mySelectionEnd;
    private char[] myText;
    private int[] myStyles;
    private Color[] myColors;

    public Provider(String name, Component component, Component gutter, char[] text, int[] styles, Color[] colors, int selectionStart, int selectionEnd) {
        this.myName = name;
        this.myComponent = component;
        this.myGutter = gutter;
        this.mySelectionStart = selectionStart;
        this.mySelectionEnd = selectionEnd;
        this.myText = text;
        this.myStyles = styles;
        this.myColors = colors;
    }

    @Override
    public PrintPage[][] getPages(int width, int height, double zoom) {
        return this.getProvider().getPages(width, height, zoom);
    }

    private PrintProvider getProvider() {
        if (this.myText == null || this.myText != null && this.myComponent != null && Util.getConfig().isPrintAsShownInEditor()) {
            ArrayList<Component> components = new ArrayList<Component>();
            components.add(this.myComponent);
            if (this.myGutter != null && Util.getConfig().hasLineNumbers()) {
                components.add(0, this.myGutter);
            }
            return new oracle.ide.print.core.comp.Provider(components, this.myName);
        }
        return new oracle.ide.print.core.text.Provider(this.myText, this.myStyles, this.myColors, this.mySelectionStart, this.mySelectionEnd, this.myName);
    }

    @Override
    public String getName() {
        return this.myName;
    }
}

