/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.createRepository;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.createRepository.RunRepositoryScripts;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class CallRunScripts
extends AbstractMigrationProgressRunnable {
    public static final int REPOSITORY_BYTE_SIZE = 50000;
    private RunRepositoryScripts m_worker;
    private int m_mode = 5;
    private JPanel m_downJpanel = null;
    private JLabel m_downJlabel = null;
    private String m_text = "";

    public CallRunScripts(RunRepositoryScripts runRepositoryScripts, int n) {
        this.m_worker = runRepositoryScripts;
        this.m_mode = n;
        runRepositoryScripts.setMode(n);
        runRepositoryScripts.setProgressBar(this);
        String string = "";
        String string2 = "";
        if (this.m_mode == 1) {
            string = MigrationAddinArb.getString("REPOSITORY_BUILD_TITLE");
            string2 = MigrationAddinArb.getString("REPOSITORY_LOADING");
            this.setUseBuzyBar(false);
        } else if (this.m_mode == 2) {
            string = MigrationAddinArb.getString("REPOSITORY_DROP_TITLE");
            string2 = MigrationAddinArb.getString("REPOSITORY_DROPPING");
        } else {
            string = MigrationAddinArb.getString("REPOSITORY_RUN_TITLE");
            string2 = MigrationAddinArb.getString("REPOSITORY_RUNNING");
        }
        this.setTitle(string);
        this.setMessage(string2);
        this.m_downJpanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        this.m_downJpanel.setLayout(borderLayout);
        this.m_downJlabel = new JLabel();
        this.m_downJpanel.add((Component)this.m_downJlabel, "West");
        if (this.m_mode == 2) {
            this.m_downJlabel.setText(MigrationAddinArb.getString("REPOSITORY_REMOVING"));
        }
    }

    public void setScript(String string) {
        this.m_worker.setScript(string);
    }

    @Override
    public void doCancel() {
        super.doCancel();
        this.m_worker.signalCancel();
    }

    @Override
    protected Object doWork() throws Exception {
        this.m_worker.run();
        return this.m_worker.getSuccess();
    }

    @Override
    protected void finish(Object object) {
        Boolean bl = (Boolean)object;
        if (bl == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("REPOSITORY_ERROR"), null, null);
        } else if (bl.equals(Boolean.FALSE) && this.m_worker.wasCancelled()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("REPOSITORY_CANCEL_MESSAGE"), null, null);
        } else if (bl.equals(Boolean.FALSE)) {
            if (this.m_mode == 5) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("REPOSITORY_SQL_ERROR"), null, null);
            } else {
                Object object2 = MigrationAddinArb.getString("REPOSITORY_SQL_ERROR_GENERIC");
                if (this.m_mode == 1) {
                    object2 = (String)object2 + "\n" + MigrationAddinArb.getString("REPOSITORY_SQL_ERROR_ADDL_INFO");
                }
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)object2, null, null);
            }
        }
    }

    @Override
    public JPanel getDownPanel() {
        return this.m_downJpanel;
    }

    @Override
    public JPanel getTopPanel() {
        return null;
    }

    @Override
    public void updateAbovePanel(Object object) {
    }

    @Override
    public void updateBelowPanel(Object object) {
        if (object instanceof String) {
            this.setText((String)object);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        CallRunScripts.this.m_downJlabel.setText(CallRunScripts.this.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int n) {
        this.m_mode = n;
    }

    public synchronized String getText() {
        return this.m_text;
    }

    public synchronized void setText(String string) {
        this.m_text = string;
    }
}

