/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdAdditionalPropertie
extends PersistableObject {
    public static final String TABLE_NAME = "MD_ADDITIONAL_PROPERTIES";
    public static final String COLNAME_CONNECTION_ID_FK = "CONNECTION_ID_FK";
    public static final String COLNAME_REF_ID_FK = "REF_ID_FK";
    public static final String COLNAME_REF_TYPE = "REF_TYPE";
    public static final String COLNAME_PROPERTY_ORDER = "PROPERTY_ORDER";
    public static final String COLNAME_PROP_KEY = "PROP_KEY";
    public static final String COLNAME_VALUE = "VALUE";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdAdditionalPropertie(DBObjectId dBObjectId, DBObjectId dBObjectId2, String string, String string2) {
        this.setConnectionId(dBObjectId);
        this.setRefId(dBObjectId2);
        this.setRefType(string);
        this.setPropKey(string2);
    }

    public static MdAdditionalPropertie getExistingInstance(DBObjectId dBObjectId) {
        MdAdditionalPropertie mdAdditionalPropertie = new MdAdditionalPropertie();
        mdAdditionalPropertie.setKey(dBObjectId);
        return mdAdditionalPropertie;
    }

    private MdAdditionalPropertie() {
    }

    public static MdAdditionalPropertie retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdAdditionalPropertie mdAdditionalPropertie = MdAdditionalPropertie.getExistingInstance(dBObjectId);
        mdAdditionalPropertie.retrieve(persistenceManager);
        return mdAdditionalPropertie;
    }

    protected void setConnectionId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_CONNECTION_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setRefId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_REF_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setRefType(String string) {
        Field field = new Field(COLNAME_REF_TYPE, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    public void setPropertyOrder(Integer n) {
        Field field = new Field(COLNAME_PROPERTY_ORDER, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    protected void setPropKey(String string) {
        Field field = new Field(COLNAME_PROP_KEY, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    public void setValue(String string) {
        Field field = new Field(COLNAME_VALUE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getConnectionId() {
        Field field = this.getField(COLNAME_CONNECTION_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public DBObjectId getRefId() {
        Field field = this.getField(COLNAME_REF_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getRefType() {
        Field field = this.getField(COLNAME_REF_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getPropertyOrder() {
        Field field = this.getField(COLNAME_PROPERTY_ORDER);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public String getPropKey() {
        Field field = this.getField(COLNAME_PROP_KEY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getValue() {
        Field field = this.getField(COLNAME_VALUE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setConnectionId(new DBObjectId(resultSet.getLong(COLNAME_CONNECTION_ID_FK)));
            this.setRefId(new DBObjectId(resultSet.getLong(COLNAME_REF_ID_FK)));
            this.setRefType(resultSet.getString(COLNAME_REF_TYPE));
            Object object = resultSet.getInt(COLNAME_PROPERTY_ORDER);
            if (resultSet.wasNull()) {
                this.setPropertyOrder(null);
            } else {
                this.setPropertyOrder((Integer)object);
            }
            this.setPropKey(resultSet.getString(COLNAME_PROP_KEY));
            object = resultSet.getString(COLNAME_VALUE);
            if (resultSet.wasNull()) {
                this.setValue(null);
            } else {
                this.setValue((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_CONNECTION_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getConnectionId();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

