/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.migration.convert.TextMappingResult;
import oracle.dbtools.migration.convert.TextMappingRule;
import oracle.dbtools.migration.convert.TextMappingRuleSet;

public class TextMappingRuleSetImpl
implements TextMappingRuleSet {
    private ArrayList<TextMappingRule> m_rules = new ArrayList();

    public TextMappingRuleSetImpl() {
    }

    public TextMappingRuleSetImpl(TextMappingRule[] textMappingRuleArray) {
        this();
        for (TextMappingRule textMappingRule : textMappingRuleArray) {
            this.addRule(textMappingRule);
        }
    }

    public void addRule(TextMappingRule textMappingRule) {
        this.m_rules.add(textMappingRule);
    }

    @Override
    public TextMappingResult applyRules(String string) {
        for (TextMappingRule textMappingRule : this.m_rules) {
            Pattern pattern = Pattern.compile(textMappingRule.getPattern());
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return new TextMappingResult(string, matcher.replaceFirst(textMappingRule.getReplacement()), textMappingRule.shouldWarn());
        }
        return null;
    }
}

