/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.io.IOException;
import java.sql.Connection;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.DerivativesIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdDerivative;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.Messages;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;

public class CapturedConnectionNode
extends MigrationConnectionNode {
    public CapturedConnectionNode(String string, String string2, MdConnection mdConnection) {
        super(string, string2, mdConnection);
        this.m_dict.put("IDCONNECTION", mdConnection.getKey().toString());
        this.m_dict.put("IDCAPCONNECTION", mdConnection.getKey().toString());
        this.m_dict.put("IDCONCONNECTION", this.getConvertedID(mdConnection.getKey().toString()));
    }

    private String getConvertedID(String string) {
        DerivativesIterator derivativesIterator = new DerivativesIterator(MigrationAddin.getPersistenceManager(), null, "  derivative_reason IS NULL AND src_id = " + string);
        if (derivativesIterator.hasNext()) {
            MdDerivative mdDerivative = (MdDerivative)derivativesIterator.next();
            DBObjectId dBObjectId = mdDerivative.getDerivedId();
            return dBObjectId.toString();
        }
        return null;
    }

    @Override
    protected Connection openConnectionImpl() throws IOException {
        return CapturedDatabases.getInstance().getPersistenceManager().getConn();
    }

    @Override
    protected boolean closeConnectionImpl() {
        return true;
    }

    @Override
    public String getConnType() {
        return "MIGREPO";
    }

    @Override
    public String getSchemaName() {
        return Messages.getString("CapturedConnectionNode.2");
    }

    public Icon getIcon() {
        return CapturedConnectionNode.getCaptureIcon();
    }

    public static Icon getCaptureIcon() {
        return MigrationAddinArb.getIcon("MIGRATION_CAPTURE_ICON");
    }
}

