/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.TargetStatsPanel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class TargetStatsAction
extends AbstractMenuAction {
    public void launch() {
        ActionListener actionListener;
        TargetStatsPanel targetStatsPanel = new TargetStatsPanel(false);
        String string = MigrationProjectNavigatorArb.getString("REFRESH_TARGET_STATISTICS");
        boolean bl = UIUtils.showPanelAsDialog((JPanel)targetStatsPanel, (String)string, (ActionListener)(actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "apply") {
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
                } else {
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            }
        }));
        if (bl) {
            String string2 = targetStatsPanel.getTargetConnection();
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection(string2);
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
            try {
                Connection connection2 = this.getDBObject().getConnection();
                this.refreshTargetStats(connection, connection2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public void refreshTargetStats(Connection connection, Connection connection2) throws SQLException {
        this.truncateTargetStats(connection2);
        List<String> list = this.getListOfTargetSchemas(connection2);
        this.updateTargetStats(list, connection, connection2);
    }

    private void updateTargetStats(final List<String> list, final Connection connection, final Connection connection2) throws SQLException {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(MigrationProjectNavigatorArb.getString("REFRESH_TARGET_DATA_STATISTICS"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected Void doWork() throws TaskException {
                try {
                    TargetStatsAction.this.updateTargetStatsTask(list, connection, connection2);
                }
                catch (SQLException sQLException) {
                    throw new TaskException((Throwable)sQLException);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void updateTargetStatsTask(List<String> list, Connection connection, Connection connection2) throws SQLException {
        Object var4_4 = null;
        String string = "select status,owner,object_name from all_objects where UPPER(owner) in (" + this.getList(list) + ")";
        String string2 = "select OWNER,NAME,TYPE,SEQUENCE,LINE,POSITION,TEXT,ATTRIBUTE,MESSAGE_NUMBER  from sys.all_errors where UPPER(owner) in  (" + this.getList(list) + ")";
        String string3 = "INSERT INTO MD_TARGET_ALL_OBJECTS(STATUS,OWNER,OBJECT_NAME) VALUES(?,?,?)";
        String string4 = "INSERT INTO MD_TARGET_ALL_ERRORS(OWNER,NAME,TYPE,SEQUENCE,LINE,POSITION,TEXT,ATTRIBUTE,MESSAGE_NUMBER) VALUES(?,?,?,?,?,?,?,?,?)";
        this.saveTargetInfoToRepo(string, "MD_TARGET_ALL_OBJECTS", connection, connection2, string3, 3);
        this.saveTargetInfoToRepo(string2, "MD_TARGET_ALL_ERRORS", connection, connection2, string4, 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTargetInfoToRepo(String string, String string2, Connection connection, Connection connection2, String string3, int n) throws SQLException {
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            statement2 = connection2.prepareStatement(string3);
            int n2 = 1;
            int n3 = 100;
            while (resultSet.next()) {
                for (int i = 1; i <= n; ++i) {
                    statement2.setObject(i, resultSet.getObject(i));
                }
                statement2.addBatch();
                if (n2 % n3 != 0) continue;
                statement2.executeBatch();
            }
            statement2.executeBatch();
        }
        finally {
            if (statement2 != null && !statement2.isClosed()) {
                statement2.close();
            }
            if (resultSet != null && !resultSet.isClosed()) {
                resultSet.close();
            }
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
        }
    }

    public void copy(String string, Connection connection, Connection connection2) throws SQLException {
    }

    private String getList(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (String string : list) {
            stringBuffer.append("'" + string + "'");
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getListOfTargetSchemas(Connection connection) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string = "select distinct UPPER(schemaname) name from mgv_all_schema_details where capturedorconverted='CONVERTED'";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                arrayList.add(string2);
            }
        }
        finally {
            if (resultSet != null && !resultSet.isClosed()) {
                resultSet.close();
            }
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncateTargetStats(Connection connection) throws SQLException {
        Statement statement = null;
        try {
            String string = "TRUNCATE TABLE MD_TARGET_ALL_OBJECTS";
            String string2 = "TRUNCATE TABLE MD_TARGET_ALL_ERRORS";
            statement = connection.createStatement();
            int n = statement.executeUpdate(string);
            int n2 = statement.executeUpdate(string2);
        }
        finally {
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
        }
    }
}

