/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MaskUtil;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class UserDefinedMasks
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane m_scrollPane;
    private JTable m_table;
    private DefaultTableModel m_model = new DefaultTableModel();

    public UserDefinedMasks() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void jbInit() {
        this.setHelpID("f1_codetemplatepreference_html");
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, MigrationAddinArb.getString("SOURCE_TYPE_MASK_TITLE"), 0, 0, null, null));
        this.m_scrollPane = new JScrollPane();
        this.add(this.m_scrollPane, new GridBagConstraints(0, 1, 4, 3, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 0), 0, 3));
        this.m_model.addColumn(MigrationAddinArb.getString("SOURCE_TYPE_MASK_SOURCE_TYPE"));
        this.m_model.addColumn(MigrationAddinArb.getString("SOURCE_TYPE_MASK_FUNCTION"));
        this.m_model.addColumn(MigrationAddinArb.getString("SOURCE_TYPE_MASK_MASK"));
        this.m_table = new JTable(this.m_model);
        this.m_table.setShowGrid(true);
        this.m_scrollPane.setViewportView(this.m_table);
        JButton jButton = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton, (String)MigrationAddinArb.getString("SOURCE_TYPE_MASK_ADD_ROW"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserDefinedMasks.this.addRow("", DateOrTimestamp.values()[0].toString(), "");
                UserDefinedMasks.this.m_table.setRowSelectionInterval(UserDefinedMasks.this.m_table.getRowCount() - 1, UserDefinedMasks.this.m_table.getRowCount() - 1);
                UserDefinedMasks.this.m_table.setColumnSelectionInterval(0, 0);
            }
        });
        this.m_table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object object) {
                super.setValue(object);
                if (object != null) {
                    this.setToolTipText(object.toString());
                }
            }
        });
        this.add(jButton, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        JButton jButton2 = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton2, (String)MigrationAddinArb.getString("SOURCE_TYPE_MASK_REMOVE_ROW"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = UserDefinedMasks.this.m_table.getSelectedRow();
                int n2 = UserDefinedMasks.this.m_table.getSelectedColumn();
                while (n > -1 && n2 > -1) {
                    if (UserDefinedMasks.this.m_table.isEditing()) {
                        UserDefinedMasks.this.m_table.getCellEditor(n, n2).stopCellEditing();
                    }
                    UserDefinedMasks.this.m_model.removeRow(n);
                    n = UserDefinedMasks.this.m_table.getSelectedRow();
                }
            }
        });
        this.add(jButton2, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
    }

    public void addRow(String string, String string2, String string3) {
        this.m_model.addRow(new String[]{string, string2, string3});
        this.m_model.fireTableDataChanged();
        this.m_table.revalidate();
        if (this.m_model.getRowCount() < 3) {
            this.m_scrollPane.setViewportView(this.m_table);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        Map<String, String[]> map = MaskUtil.loadValues(traversableContext);
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{MigrationAddinArb.getString("SOURCE_TYPE_MASK_SOURCE_TYPE"), MigrationAddinArb.getString("SOURCE_TYPE_MASK_FUNCTION"), MigrationAddinArb.getString("SOURCE_TYPE_MASK_MASK")}, 0);
        for (String object : map.keySet()) {
            String[] n = map.get(object);
            defaultTableModel.addRow(new String[]{object, n[0], n[1]});
        }
        if (defaultTableModel.getColumnName(1).equals(MigrationAddinArb.getString("SOURCE_TYPE_MASK_FUNCTION"))) {
            DateOrTimestamp[] dateOrTimestampArray = DateOrTimestamp.values();
            JComboBox<String> jComboBox = new JComboBox<String>();
            for (DateOrTimestamp dateOrTimestamp : dateOrTimestampArray) {
                jComboBox.addItem(dateOrTimestamp.toString());
            }
            this.m_model = defaultTableModel;
            this.m_table.setModel(this.m_model);
            this.m_table.updateUI();
            int n = 1;
            TableColumn tableColumn = this.m_table.getColumnModel().getColumn(n);
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_table.getCellEditor() != null) {
            this.m_table.getCellEditor().stopCellEditing();
        }
        MaskUtil.save(this.m_model, traversableContext);
    }

    private static MigrationConfig getConfigFromContext(TraversableContext traversableContext) {
        return MigrationConfig.getInstance(traversableContext.getPropertyStorage());
    }

    static enum DateOrTimestamp {
        TO_DATE,
        TO_TIMESTAMP;

    }
}

