/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.net.URLEncoder;
import java.security.PrivateKey;
import java.util.Date;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibResponseMessage;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.samlp.Status;
import oracle.security.xmlsec.samlp.StatusCode;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogoutResponse
extends LibResponseMessage {
    public LogoutResponse(Element element) throws DOMException {
        super(element);
    }

    public LogoutResponse(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public LogoutResponse(Document owner) throws DOMException {
        super(owner, "urn:liberty:iff:2003-08", "LogoutResponse");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    public LogoutResponse(Document owner, String responseId, Date issueInstant, String providerId) {
        this(owner);
        this.setResponseID(responseId);
        this.setIssueInstant(issueInstant);
        this.setProviderID(providerId);
    }

    public String toURLString(PrivateKey key, String sigAlg) throws SigningException {
        int last;
        String relayState;
        StatusCode statusCode;
        Status status;
        String providerID;
        String recipient;
        String inResponseTo;
        StringBuffer queryBuffer = new StringBuffer();
        String responseID = this.getResponseID();
        if (responseID != null) {
            queryBuffer.append("ResponseID=");
            queryBuffer.append(URLEncoder.encode(responseID));
            queryBuffer.append('&');
        }
        if ((inResponseTo = this.getInResponseTo()) != null) {
            queryBuffer.append("InResponseTo=");
            queryBuffer.append(URLEncoder.encode(inResponseTo));
            queryBuffer.append('&');
        }
        queryBuffer.append("MajorVersion=1&MinorVersion=2&");
        Date issueInstant = this.getIssueInstant();
        if (issueInstant != null) {
            queryBuffer.append("IssueInstant=");
            queryBuffer.append(URLEncoder.encode(XMLUtils.formatDateTime((Date)issueInstant)));
            queryBuffer.append('&');
        }
        if ((recipient = this.getRecipient()) != null) {
            queryBuffer.append("Recipient=");
            queryBuffer.append(URLEncoder.encode(recipient));
            queryBuffer.append('&');
        }
        if ((providerID = this.getProviderID()) != null) {
            queryBuffer.append("ProviderID=");
            queryBuffer.append(URLEncoder.encode(providerID));
            queryBuffer.append('&');
        }
        if ((status = this.getStatus()) != null && (statusCode = status.getStatusCode()) != null) {
            queryBuffer.append("Value=");
            queryBuffer.append(URLEncoder.encode(statusCode.getStatusCodeValue().toString()));
            queryBuffer.append('&');
        }
        if ((relayState = this.getRelayState()) != null) {
            queryBuffer.append("RelayState=");
            queryBuffer.append(URLEncoder.encode(relayState));
            queryBuffer.append('&');
        }
        if (key != null && sigAlg != null) {
            queryBuffer.append("SigAlg=");
            queryBuffer.append(URLEncoder.encode(sigAlg));
            String toBeSigned = queryBuffer.toString();
            String sigValue = LibDSigUtils.signURL(toBeSigned, key, sigAlg);
            queryBuffer.append("&Signature=");
            queryBuffer.append(sigValue);
        }
        if ((last = queryBuffer.length() - 1) >= 0 && queryBuffer.charAt(last) == '&') {
            queryBuffer.deleteCharAt(last);
        }
        return queryBuffer.toString();
    }

    @Override
    protected String[] getChildElementsNSURIs() {
        return new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:liberty:iff:2003-08"};
    }

    @Override
    protected String[] getChildElementsLocalNames() {
        return new String[]{"Signature", "Extension", "ProviderID", "Status", "RelayState"};
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

