/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.util.Date;
import oracle.security.xmlsec.liberty.v12.LibRequestMessage;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.saml.NameIdentifier;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NameIdentifierMappingRequest
extends LibRequestMessage {
    public NameIdentifierMappingRequest(Element element) throws DOMException {
        super(element);
    }

    public NameIdentifierMappingRequest(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public NameIdentifierMappingRequest(Document owner) throws DOMException {
        super(owner, "urn:liberty:iff:2003-08", "NameIdentifierMappingRequest");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    public NameIdentifierMappingRequest(Document owner, String requestId, Date issueInstant, String providerId, String targetNamespace) {
        this(owner);
        this.setRequestID(requestId);
        this.setIssueInstant(issueInstant);
        this.setProviderID(providerId);
        this.setTargetNamespace(targetNamespace);
    }

    public void setNameIdentifier(NameIdentifier nameId) {
        LibertyUtils.setChildElement((XMLElement)this, (XMLElement)nameId, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public NameIdentifier getNameIdentifier() {
        return (NameIdentifier)LibertyUtils.getChildElement((XMLElement)this, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
    }

    public void setTargetNamespace(String targetNamespace) {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "TargetNamespace", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), targetNamespace, true);
    }

    public String getTargetNamespace() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "TargetNamespace");
    }

    public void setConsent(String consent) throws DOMException {
        this.setAttribute("consent", consent);
    }

    public String getConsent() {
        if (this.hasAttribute("consent")) {
            return this.getAttribute("consent");
        }
        return null;
    }

    @Override
    protected String[] getChildElementsNSURIs() {
        return new String[]{"urn:oasis:names:tc:SAML:1.0:protocol", "http://www.w3.org/2000/09/xmldsig#", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:liberty:iff:2003-08"};
    }

    @Override
    protected String[] getChildElementsLocalNames() {
        return new String[]{"RespondWith", "Signature", "Extension", "ProviderID", "NameIdentifier", "TargetNamespace"};
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

