/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12.metadata;

import java.util.List;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.liberty.v12.metadata.ProviderDescriptor;
import oracle.security.xmlsec.saml.SAMLInitializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IDPDescriptor
extends ProviderDescriptor {
    private static final String[] nsURIs = new String[]{"urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "http://www.w3.org/2000/09/xmldsig#", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08"};
    private static final String[] localNames = new String[]{"KeyDescriptor", "SoapEndpoint", "SingleLogoutServiceURL", "SingleLogoutServiceReturnURL", "FederationTerminationServiceURL", "FederationTerminationServiceReturnURL", "FederationTerminationNotificationProtocolProfile", "SingleLogoutProtocolProfile", "RegisterNameIdentifierProtocolProfile", "RegisterNameIdentifierServiceURL", "RegisterNameIdentifierServiceReturnURL", "NameIdentifierMappingProtocolProfile", "NameIdentifierMappingEncryptionProfile", "Organization", "ContactPerson", "AdditionalMetaLocation", "Extension", "Signature", "SingleSignOnServiceURL", "SingleSignOnProtocolProfile", "AuthnServiceURL"};

    public IDPDescriptor(Element element) throws DOMException {
        super(element);
    }

    public IDPDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public IDPDescriptor(Document owner) throws DOMException {
        super(owner, "urn:liberty:metadata:2003-08", "IDPDescriptor");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:liberty:metadata:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:metadata:2003-08");
    }

    public void setSingleSignOnServiceURL(String serviceURL) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "SingleSignOnServiceURL", nsURIs, localNames, serviceURL, true);
    }

    public String getSingleSignOnServiceURL() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "SingleSignOnServiceURL");
    }

    public void addSingleSignOnProtocolProfile(String profileURI) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "SingleSignOnProtocolProfile", nsURIs, localNames, profileURI, false);
    }

    public List getSingleSignOnProtocolProfiles() {
        return LibertyUtils.collectTextFromChildren(this, "urn:liberty:metadata:2003-08", "SingleSignOnProtocolProfile");
    }

    public void setAuthnServiceURL(String serviceURL) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "AuthnServiceURL", nsURIs, localNames, serviceURL, true);
    }

    public String getAuthnServiceURL() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "AuthnServiceURL");
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

