/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.rules.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.dbtools.raptor.migration.applications.recognisers.FileTypeRecognizerRegistry;
import oracle.dbtools.raptor.migration.applications.recognisers.Recognizer;
import oracle.dbtools.raptor.migration.applications.rules.Rules;
import oracle.dbtools.raptor.migration.applications.rules.parser.RuleSet;
import oracle.ide.net.JarUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RulesParser {
    private static String RULESET = "ruleset";
    private static String RECOGNIZER = "recognizer";
    private static String RULESFILE = "rulesfile";
    private DOMParser parser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        File file = new File("d:/code/raptor_trunk/migrations/application/src/oracle/dbtools/raptor/migration/applications/rules/xml/sybase.xml");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            RulesParser rulesParser = new RulesParser();
            rulesParser.processXML(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void processRuleSet(Node node) {
        RuleSet ruleSet = new RuleSet(node);
        if (ruleSet.getType() == null) {
            Rules.getInstance().addRule("ANY", ruleSet);
        } else {
            Rules.getInstance().addRule(ruleSet.getType().toLowerCase(), ruleSet);
        }
    }

    private void processRecognizer(Node node) {
        Recognizer recognizer = new Recognizer(node);
        if (!FileTypeRecognizerRegistry.contains(recognizer)) {
            FileTypeRecognizerRegistry.registerRecognizer(recognizer);
        }
    }

    public void processXML(InputStream inputStream, URL uRL) throws Exception {
        Object object = JarUtil.getJarEntry((URL)uRL);
        if (object != null && !((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        this.processXML(inputStream);
    }

    public void processXML(InputStream inputStream) throws Exception {
        if (this.parser == null) {
            this.parser = new DOMParser();
        } else {
            this.parser.reset();
        }
        this.parser.setPreserveWhitespace(false);
        this.parser.parse(inputStream);
        XMLDocument xMLDocument = this.parser.getDocument();
        NodeList nodeList = xMLDocument.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().toLowerCase().equals(RULESFILE)) continue;
            this.processRulesFile(nodeList.item(i));
        }
    }

    private void processRulesFile(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().toLowerCase().equals(RULESET)) {
                this.processRuleSet(nodeList.item(i));
                continue;
            }
            if (!nodeList.item(i).getNodeName().toLowerCase().equals(RECOGNIZER)) continue;
            this.processRecognizer(nodeList.item(i));
        }
    }

    public void closeParser() {
        this.parser = null;
    }
}

