/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.ProjectPageMigration;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.raptor.migration.applications.AppScanArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class AppProjectPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private final JRadioButton m_rbtnNewProject = new JRadioButton("", true);
    private final JRadioButton m_rbtnExistingProject = new JRadioButton();
    private final JPanel m_lowerPanel = new JPanel();
    private final CardLayout m_cl = new CardLayout();
    static final String NEWPROJECT = "New Project";
    static final String EXISTINGPROJECT = "Existing Project";
    private final JLabel m_lblProjectName = new JLabel();
    private final JTextField m_txtProjName = new JTextField();
    private final JLabel m_lblProjDesc = new JLabel();
    private final JTextPane m_txtProjDesc = new JTextPane();
    private final JLabel m_lblProjectOView = new JLabel(AppScanArb.getString("APPSCAN_PRJOVIEW"));
    private final JLabel m_lblSelProjectName = new JLabel();
    private JPanel m_newPanel = null;
    private JPanel m_existingPanel = null;
    private final JComboBox m_cbProjects = new JComboBox();
    private final ProjectPageMigration m_projectPage = new ProjectPageMigration();
    public static final String NEW_PROJ_NAME = "PROJ_NAME";
    public static final String NEW_PROJ_DESC = "PROJ_DESC";
    public static final String NEW_PROJ_OUTDIR = "PROJ_OUTDIR";
    public static final String NEW_PROJ_MODE = "NEW_PROJ_MODE";
    public static final String EXISTING_PROJ_NAME = "EXISTING_PROJ_NAME";
    public static final String EXISTING_PROJ_MODE = "EXISTING_PROJ_MODE";
    public static final String EXISTING_PROJ_ID = "EXISTING_PROJ_ID";

    public AppProjectPanel() {
        ResourceUtils.resButton((AbstractButton)this.m_rbtnNewProject, (String)AppScanArb.getString("APPSCAN_PRJNEW"));
        ResourceUtils.resButton((AbstractButton)this.m_rbtnExistingProject, (String)AppScanArb.getString("APPSCAN_PRJEXISTING"));
        ResourceUtils.resLabel((JLabel)this.m_lblProjectName, (Component)this.m_txtProjName, (String)QMWizardArb.getString((String)"ProjectNameLabel"));
        ResourceUtils.resLabel((JLabel)this.m_lblProjDesc, (Component)this.m_txtProjDesc, (String)QMWizardArb.getString((String)"ProjectDescriptionLabel"));
    }

    public void onEntry(TraversableContext traversableContext) {
        Object object = traversableContext.get("project");
        if (object != null) {
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
            return;
        }
        this.initGUI();
        if (this.hasProjects() && !((Boolean)traversableContext.get("TRUNCATE_REPOSITORY")).booleanValue()) {
            this.m_rbtnExistingProject.setEnabled(true);
        } else {
            this.m_rbtnNewProject.doClick();
            this.m_rbtnExistingProject.setEnabled(false);
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1 && this.m_newPanel != null && this.m_existingPanel != null) {
            if (this.m_rbtnNewProject.isSelected()) {
                this.validateNewProject(traversableContext);
            } else {
                traversableContext.put(EXISTING_PROJ_NAME, (Object)((String)this.m_cbProjects.getSelectedItem()));
                long l = this.getProjectId((String)this.m_cbProjects.getSelectedItem());
                traversableContext.put(EXISTING_PROJ_ID, (Object)String.valueOf(l));
                traversableContext.put(EXISTING_PROJ_MODE, (Object)true);
                traversableContext.put(NEW_PROJ_MODE, (Object)false);
            }
        }
    }

    private void initGUI() {
        if (this.m_newPanel == null && this.m_existingPanel == null) {
            this.m_newPanel = new JPanel();
            this.m_existingPanel = new JPanel();
            JPanel jPanel = new JPanel();
            ProjectActionListener projectActionListener = new ProjectActionListener();
            jPanel.setLayout(new FlowLayout(0));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_rbtnNewProject);
            buttonGroup.add(this.m_rbtnExistingProject);
            this.m_rbtnNewProject.addActionListener(projectActionListener);
            this.m_rbtnExistingProject.addActionListener(projectActionListener);
            jPanel.add(this.m_rbtnNewProject);
            jPanel.add(this.m_rbtnExistingProject);
            jPanel.setBorder(BorderFactory.createTitledBorder(AppScanArb.getString("APPSCAN_PROJECT")));
            this.setLayout(new BorderLayout());
            this.m_newPanel.setLayout(new BorderLayout());
            this.m_projectPage.getGoToSummary().setVisible(false);
            this.m_newPanel.add((Component)this.m_projectPage);
            this.m_existingPanel.setLayout(new GridBagLayout());
            this.m_existingPanel.add((Component)this.m_lblProjectOView, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 11, 1, new Insets(10, 0, 10, 0), 0, 0));
            this.m_lblSelProjectName.setText(StringUtils.stripMnemonic((String)AppScanArb.getString("APPSCAN_LBLPROJECT")));
            this.m_lblSelProjectName.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)AppScanArb.getString("APPSCAN_LBLPROJECT")));
            this.m_existingPanel.add((Component)this.m_lblSelProjectName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.m_existingPanel.add((Component)this.m_cbProjects, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 10, 10, 0), 0, 0));
            this.m_cbProjects.setRenderer(new IconComboRenderer());
            this.m_lowerPanel.setLayout(new BorderLayout());
            this.m_lowerPanel.add(this.m_newPanel);
            this.add(jPanel, "North");
            this.add(this.m_lowerPanel, "Center");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasProjects() {
        int n = 0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "";
        String string2 = "SELECT COUNT(ID) FROM MD_PROJECTS";
        try {
            string = MigrationAddin.getRepositoryConnectionName();
            connection = Connections.getInstance().getConnection(string);
            statement = connection.prepareStatement(string2);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long getProjectId(String string) {
        long l = -1L;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = "";
        String string3 = "SELECT ID FROM MD_PROJECTS WHERE PROJECT_NAME = ?";
        try {
            string2 = MigrationAddin.getRepositoryConnectionName();
            connection = Connections.getInstance().getConnection(string2);
            statement = connection.prepareStatement(string3);
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                l = resultSet.getLong(1);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return l;
    }

    private void validateNewProject(TraversableContext traversableContext) throws TraversalException {
        String string = this.m_projectPage.getProjectName();
        String string2 = this.m_projectPage.getOutputDir();
        String string3 = this.m_projectPage.getProjectDesc();
        this.validateProjectName(traversableContext);
        File file = new File(string2.trim());
        if (!(string2 != null && string2.trim().length() > 0 && file.exists() && file.isDirectory() && file.canWrite())) {
            throw new TraversalException(QMWizardArb.getString((String)"InvalidOutputDir"));
        }
        string2 = string2.trim();
        if (string2 != null && string2.trim().length() > 0 && (string2.charAt(string2.length() - 1) == '/' || string2.charAt(string2.length() - 1) == '\\')) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        traversableContext.put(NEW_PROJ_OUTDIR, (Object)string2);
        traversableContext.put(NEW_PROJ_DESC, (Object)string3);
        traversableContext.put(NEW_PROJ_MODE, (Object)true);
        traversableContext.put(EXISTING_PROJ_MODE, (Object)false);
    }

    private void validateProjectName(TraversableContext traversableContext) throws TraversalException {
        String string = this.m_projectPage.getProjectName();
        boolean bl = (Boolean)traversableContext.get("TRUNCATE_REPOSITORY");
        if (string != null && string.trim().length() > 0 && string.trim().length() < 30) {
            string = string.trim();
            string = string.replaceAll("\\s", "_");
            if (!bl) {
                this.m_projectPage.checkIfProjectExists(string, traversableContext);
            }
        } else {
            throw new TraversalException(QMWizardArb.getString((String)"InvalidProjectName"));
        }
        traversableContext.put(NEW_PROJ_NAME, (Object)string);
    }

    private class IconComboRenderer
    extends DefaultListCellRenderer {
        private IconComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Icon icon = MigrationAddinArb.getIcon((String)"MIGRATION_PROJECTS_ICON");
            jLabel.setIcon(icon);
            return jLabel;
        }
    }

    private class ProjectActionListener
    implements ActionListener {
        private ProjectActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AppProjectPanel.this.m_rbtnNewProject) {
                AppProjectPanel.this.m_lowerPanel.removeAll();
                AppProjectPanel.this.m_lowerPanel.add(AppProjectPanel.this.m_newPanel);
            } else {
                AppProjectPanel.this.m_lowerPanel.removeAll();
                AppProjectPanel.this.m_lowerPanel.add((Component)AppProjectPanel.this.m_existingPanel, "North");
                AppProjectPanel.this.m_cbProjects.removeAllItems();
                Connection connection = null;
                Statement statement = null;
                ResultSet resultSet = null;
                String string = "";
                String string2 = "SELECT PROJECT_NAME FROM MD_PROJECTS ORDER BY 1";
                try {
                    string = MigrationAddin.getRepositoryConnectionName();
                    connection = Connections.getInstance().getConnection(string);
                    if (connection != null) {
                        statement = connection.prepareStatement(string2);
                        resultSet = statement.executeQuery();
                        while (resultSet.next()) {
                            AppProjectPanel.this.m_cbProjects.addItem(resultSet.getString(1));
                        }
                    }
                }
                catch (Exception exception) {
                    String string3 = exception.getMessage();
                }
                finally {
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
            AppProjectPanel.this.m_lowerPanel.repaint();
        }
    }
}

