/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.builder;

import oracle.dbtools.common.builder.CanBuild;
import oracle.dbtools.common.builder.Version;
import oracle.dbtools.common.builder.Versioned;
import oracle.dbtools.common.builder.Versions;

public abstract class BuilderBase<T, S>
implements CanBuild<T> {
    private final Class<?> type;
    private final T existing;
    private T previous;
    private T current;
    private final S state;
    private static final Versions VERSIONS = new Versions();

    protected BuilderBase(T existing) {
        this(null == existing ? null : existing.getClass(), existing);
    }

    protected BuilderBase(Class<?> type, T existing) {
        this.type = type;
        this.existing = existing;
        this.previous = existing;
        this.current = existing;
        this.state = existing == null ? this.newState(null) : this.newState(this.existingState(existing));
    }

    @Override
    public T build() {
        if (this.current == null) {
            Version version = null;
            if (this.type != null) {
                if (this.previous == null) {
                    version = VERSIONS.firstVersion(this.type);
                } else if (this.previous instanceof Versioned) {
                    version = VERSIONS.newVersion((Versioned)this.previous);
                }
            }
            this.current = this.newInstance(this.state, version);
        }
        return this.current;
    }

    protected S state() {
        return this.state;
    }

    protected abstract S existingState(T var1);

    protected void modified() {
        if (this.current != null) {
            this.previous = this.current;
        }
        this.current = null;
    }

    static void reset() {
        VERSIONS.reset();
    }

    protected abstract T newInstance(S var1, Version var2);

    protected abstract S newState(S var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public T existing() {
        return this.existing;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuilderBase other = (BuilderBase)obj;
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[current=");
        T current = this.current();
        builder.append(current);
        builder.append("]");
        return builder.toString();
    }

    protected T current() {
        T current = this.current;
        if (current == null) {
            current = this.newInstance(this.state, this.type == null ? null : new Version(this.type, null, 0L));
        }
        return current;
    }
}

