/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.concurrent;

import java.math.BigInteger;
import java.util.Objects;
import java.util.logging.Level;
import oracle.dbtools.common.concurrent.RetryStrategy;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.plugin.api.logging.Log;

final class RetryContext {
    private int attempts;
    private final BigInteger backOffInterval;
    private final RetryStrategy.RandomNumberGenerator jitterSource;
    private Exception lastError = null;
    private final Log log;
    private final BigInteger maximumInterval;
    private final Selector<Throwable> retryableExceptions;
    private final int retryCount;
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    RetryContext(Log log, int retryCount, long backOffInterval, long maximumInterval, RetryStrategy.RandomNumberGenerator jitterSource, Selector<Throwable> retryableExceptions) {
        this.log = log;
        this.retryCount = retryCount;
        this.backOffInterval = BigInteger.valueOf(backOffInterval);
        this.maximumInterval = BigInteger.valueOf(maximumInterval);
        this.jitterSource = jitterSource;
        this.retryableExceptions = retryableExceptions;
    }

    void attempt() {
        ++this.attempts;
    }

    long delay() {
        if (BigInteger.ZERO.equals(this.backOffInterval)) {
            return 0L;
        }
        BigInteger factor = TWO.pow(this.attempts);
        BigInteger exponential = factor.multiply(this.backOffInterval);
        BigInteger bound = this.maximumInterval.min(exponential);
        long delay = this.jitterSource.next(bound.longValue());
        return delay;
    }

    boolean errorRaised(Exception error) {
        this.lastError = error;
        boolean abort = false;
        if (((Boolean)this.retryableExceptions.apply(error)).booleanValue()) {
            if (this.attempts > this.retryCount) {
                abort = true;
            }
        } else {
            abort = true;
        }
        return abort;
    }

    Exception lastError() {
        return Objects.requireNonNull(this.lastError);
    }

    boolean retry() {
        if (this.attempts <= this.retryCount) {
            long delay = this.delay();
            this.pause(delay);
            return true;
        }
        return false;
    }

    void succeeded() {
        if (this.log.isLoggable(Level.FINEST)) {
            StringBuilder msg = new StringBuilder(100);
            msg.append("retryable attempt: ");
            msg.append(this.attempts);
            msg.append(" of ");
            msg.append(this.retryCount);
            msg.append(" succeeded");
            this.log.finest(msg.toString());
        }
    }

    private void pause(long delay) {
        if (this.log.isLoggable(Level.FINEST)) {
            StringBuilder msg = new StringBuilder(100);
            msg.append("retry delay of: ");
            msg.append(delay);
            msg.append("ms after retryable attempt ");
            msg.append(this.attempts);
            msg.append(" of ");
            msg.append(this.retryCount);
            this.log.finest(msg.toString());
        }
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                this.log.finest((Throwable)e);
            }
        }
    }
}

