/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config.dir;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import oracle.dbtools.common.app.Version;
import oracle.dbtools.common.config.dir.NotSpecifiedException;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.util.NullOrEmpty;

public class ConfigDir {
    private final File location;
    public static final String CONFIG_DIR_PROP = "config.dir";

    public ConfigDir(String contextPath, String configDir) {
        this(contextPath, Maps.toMap(CONFIG_DIR_PROP, configDir));
    }

    public ConfigDir(String contextPath, Map<String, String> env) {
        String configDir = env.get(CONFIG_DIR_PROP);
        if (NullOrEmpty.nullOrEmpty(configDir)) {
            throw new NotSpecifiedException(Version.INSTANCE);
        }
        contextPath = this.normalizeContextPath(contextPath);
        File base = Files.file(configDir);
        try {
            base = base.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.location = this.legacyFolder(Files.file(base, contextPath));
    }

    public ConfigDir(String contextPath, ServletContext ctx, Properties systemProperties) {
        this(contextPath, Maps.merge(Maps.asMap(ctx), Maps.asMap(systemProperties)));
    }

    public File location() {
        return this.location;
    }

    private File legacyFolder(File folder) {
        File legacyFolder;
        if (!folder.exists() && Version.INSTANCE.getProductAbbreviation().equals(folder.getName()) && (legacyFolder = Files.file(folder.getParentFile(), "apex")).exists()) {
            return legacyFolder;
        }
        return folder;
    }

    private String normalizeContextPath(String contextPath) {
        while (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        while (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }
}

