/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.activation.Activatables;
import oracle.dbtools.common.di.Dependency;
import oracle.dbtools.common.di.DependencyArc;
import oracle.dbtools.common.di.DependencyGraph;
import oracle.dbtools.common.di.DependencyInjectionException;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.di.MissingDependencyException;
import oracle.dbtools.common.di.ProviderLocator;
import oracle.dbtools.common.di.ServiceLocator;
import oracle.dbtools.common.di.Singletons;
import oracle.dbtools.common.di.TypeDependencies;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.plugin.api.di.annotations.Optional;
import oracle.dbtools.plugin.api.logging.Log;

class ServiceFactory
implements Factory {
    private final ServiceLocator externals;
    private final DependencyGraph graph;
    private final Log log;
    private final ProviderLocator providers;
    private final SelfFactory self;
    private final Singletons singletons;

    ServiceFactory(String scopeName, Log log, DependencyGraph graph, ProviderLocator providers, Singletons parentScope, ServiceLocator externals, Activatables activatables) {
        this.log = log;
        this.graph = graph;
        this.providers = providers;
        this.self = new SelfFactory();
        this.singletons = new Singletons(scopeName, parentScope, activatables, this.self);
        this.externals = externals;
    }

    @Override
    public <T> T newInstance(Class<T> type) {
        if (this.singletons.isSingleton(type)) {
            return type.cast(this.singletons.get(type));
        }
        return this.self.newInstance(type);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Injectables [graph=");
        builder.append(this.graph);
        builder.append(", providers=");
        builder.append(this.externals);
        builder.append("]");
        return builder.toString();
    }

    Singletons singletons() {
        return this.singletons;
    }

    private Object defaultConstructor(Class<?> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw DependencyInjectionException.instantationError(type, e);
        }
        catch (IllegalAccessException e) {
            throw DependencyInjectionException.instantationError(type, e);
        }
    }

    private boolean hasAnnotatedConstructor(Class<?> type) {
        Constructor<?> annotated = DependencyGraph.annotatedConstructor(type);
        return annotated != null;
    }

    private Object instantiate(Class<?> type) {
        Map<Dependency, Object> resolved = this.resolveDependencies(type, this.externals);
        Object instance = this.instantiate(type, DependencyGraph.annotatedConstructor(type), resolved);
        return instance;
    }

    private Object instantiate(Class<?> type, Constructor<?> constructor, Map<Dependency, Object> dependencies) {
        Dependency[] constructorDependencies = this.graph.constructorDependencies(type);
        Object[] args = new Object[constructorDependencies.length];
        for (int i = 0; i < constructorDependencies.length; ++i) {
            Dependency dependency = constructorDependencies[i];
            args[i] = dependencies.get(dependency);
            if (args[i] != null || !this.required(constructor, i)) continue;
            throw MissingDependencyException.noProvider(type.getName(), dependency.type(), dependency.constraints());
        }
        Object instance = this.invoke(constructor, args);
        return instance;
    }

    private Object invoke(Constructor<?> constructor, Object ... args) {
        constructor.setAccessible(true);
        try {
            Object instance = constructor.newInstance(args);
            return instance;
        }
        catch (IllegalArgumentException e) {
            throw DependencyInjectionException.illegalArgument(constructor, e);
        }
        catch (InstantiationException e) {
            throw DependencyInjectionException.instantationError(constructor.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw DependencyInjectionException.illegalAccess(constructor, e);
        }
        catch (InvocationTargetException e) {
            throw DependencyInjectionException.invocationError(constructor, e);
        }
    }

    private boolean required(Constructor<?> constructor, int argIndex) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = constructor.getParameterAnnotations()[argIndex]) {
            if (!Optional.class.equals(annotation.annotationType())) continue;
            return false;
        }
        return true;
    }

    private final Map<Dependency, Object> resolveDependencies(Class<?> type, ServiceLocator externals) {
        HashMap<Dependency, Object> resolved = new HashMap<Dependency, Object>();
        Iterable<TypeDependencies> allDependencies = this.graph.allDependencies(type);
        for (TypeDependencies dependenciesForType : allDependencies) {
            Class<?> dependencyType = dependenciesForType.type();
            if (!this.hasAnnotatedConstructor(dependencyType)) continue;
            for (DependencyArc arc : dependenciesForType.arcs()) {
                Object target = resolved.get(arc.dependency());
                if (target == null) {
                    if (arc.viaProvider()) {
                        target = this.providers.provider(arc.dependency().type(), arc.constraints());
                    } else {
                        boolean finished;
                        ArrayList<Object> instances = new ArrayList<Object>();
                        Iterable<?> externs = this.resolveExternals(externals, arc);
                        Iterables.add(instances, externs);
                        Iterator<Class<?>> implementations = arc.implementations().iterator();
                        boolean bl = finished = !implementations.hasNext() || instances.size() > 0 && !arc.hasMultiple();
                        while (!finished) {
                            Class<?> provider = implementations.next();
                            Object instance = null;
                            try {
                                if (provider == arc.dependency().type() && !this.graph.contains(provider)) {
                                    throw MissingDependencyException.noProvider(dependencyType.getName(), arc.dependency().type(), arc.constraints());
                                }
                                instance = this.singletons.isSingleton(provider) ? this.singletons.get(provider) : this.self.newInstance(provider);
                            }
                            catch (DependencyInjectionException e) {
                                if (arc.hasMultiple() || !arc.isRequired()) {
                                    this.log.warning(" Failed to instantiate (and ignoring): " + provider + " due to the following error: " + e.getMessage());
                                    this.log.finest((Throwable)e);
                                }
                                throw e;
                            }
                            if (instance != null) {
                                instances.add(instance);
                            }
                            finished = !implementations.hasNext() || instances.size() > 0 && !arc.hasMultiple();
                        }
                        target = arc.hasMultiple() ? instances : Iterables.first(instances);
                    }
                }
                if (target == null && arc.isRequired()) {
                    throw MissingDependencyException.noProvider(dependencyType.getName(), arc.dependency().type(), arc.dependency().constraints());
                }
                resolved.put(arc.dependency(), target);
            }
        }
        return resolved;
    }

    private Iterable<?> resolveExternals(ServiceLocator externals, DependencyArc arc) {
        Iterable<?> matches = externals.acquireAll(arc.dependency().type(), arc.constraints());
        return matches;
    }

    private class SelfFactory
    implements Factory {
        private SelfFactory() {
        }

        @Override
        public <T> T newInstance(Class<T> type) {
            if (ServiceFactory.this.hasAnnotatedConstructor(type)) {
                return type.cast(ServiceFactory.this.instantiate(type));
            }
            return type.cast(ServiceFactory.this.defaultConstructor(type));
        }
    }
}

