/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.Objects;
import oracle.dbtools.common.graph.EdgeChecker;
import oracle.dbtools.common.graph.EdgeFormatter;
import oracle.dbtools.common.graph.EdgeRenderer;
import oracle.dbtools.common.graph.VertexFormatter;

abstract class EdgeRendererBase<V, E>
implements EdgeRenderer<V, E> {
    protected final EdgeChecker<V, E> edgeChecker;
    protected final EdgeFormatter<V, E> edgeFormatter;
    protected final StringBuilder text;
    protected final VertexFormatter<V> vertexFormatter;

    protected EdgeRendererBase(StringBuilder text, EdgeChecker<V, E> edgeChecker, EdgeFormatter<V, E> edgeFormatter, VertexFormatter<V> vertexFormatter) {
        this.text = text;
        this.edgeChecker = edgeChecker;
        this.edgeFormatter = edgeFormatter;
        this.vertexFormatter = vertexFormatter;
    }

    protected final String edgeToString(E value, V destination) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(destination);
        if (this.edgeFormatter == null) {
            return value.toString();
        }
        return this.edgeFormatter.apply(value, destination);
    }

    protected final String vertexToString(V value) {
        Objects.requireNonNull(value);
        if (this.vertexFormatter == null) {
            return value.toString();
        }
        return (String)this.vertexFormatter.apply(value);
    }
}

