/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.List;
import javax.inject.Inject;
import oracle.dbtools.common.immutables.ImmutableList;
import oracle.dbtools.common.immutables.Lists;
import oracle.dbtools.common.immutables.impl.CollectionFactory;
import oracle.dbtools.common.immutables.impl.ListBuilder;
import oracle.dbtools.common.immutables.impl.ListImpl;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
class ListsProvider
implements Lists {
    private static final List<?> EMPTY = CollectionFactory.list(0);

    @Inject
    ListsProvider() {
    }

    @Override
    public <V> ImmutableList.Builder<V> builder() {
        List<?> empty = EMPTY;
        return this.builder(empty);
    }

    @Override
    public <V> ImmutableList.Builder<V> builder(Iterable<V> existing) {
        return ListBuilder.newInstance(existing);
    }

    @Override
    public <V> ImmutableList<V> empty() {
        return this.builder().build();
    }

    @Override
    public <V> ImmutableList<V> list(Iterable<V> elements) {
        return ListImpl.newInstance(elements);
    }

    @Override
    public <V> ImmutableList<V> list(V ... elements) {
        return this.list(Iterables.iterable(elements));
    }
}

