/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.install;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.NamespaceContext;
import oracle.dbtools.common.install.VersionFormat;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.NSContext;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.XPaths;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpgradeVersions {
    private static final String _NS = "http://xmlns.oracle.com/ords/scripts/upgrade/upgrade_versions";
    private static final String _NS_PREFIX = "j";
    private static final NamespaceContext NS_CONTEXT = NSContext.namespaceContext("j", "http://xmlns.oracle.com/ords/scripts/upgrade/upgrade_versions");
    private static final XPaths.Expression VERSION_EXPR = XPaths.expression("/j:upgrade-version/j:upgrade", NS_CONTEXT);
    private static final String VERSION = "version";
    private static final String UPGRADE = "upgrade";

    public static boolean isUpgradeRequired(File war, String schemaVer) throws Exception {
        List<String> versions = UpgradeVersions.getUpgradeVersions(war);
        for (String upgradeVer : versions) {
            if (!VersionFormat.isEarlierVersion(schemaVer, upgradeVer)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getUpgradeVersions(File war) throws IOException {
        List<String> list;
        ZipFile zip = null;
        InputStream content = null;
        try {
            zip = new ZipFile(war);
            ZipEntry entry = zip.getEntry("scripts/upgrade/upgrade_versions.xml");
            if (entry == null) {
                throw new IllegalStateException("Cannot find scripts/upgrade/upgrade_versions.xml");
            }
            content = zip.getInputStream(entry);
            list = UpgradeVersions.getVersions(content);
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                Closeables.close(content, zip);
                throw throwable;
            }
        }
        Closeables.close(content, zip);
        return list;
    }

    public static List<String> getVersions(InputStream content) throws IOException {
        ArrayList<String> versions = new ArrayList<String>();
        try {
            NodeList nodeList = XPaths.select(content, VERSION_EXPR, NodeList.class);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element e;
                    String upgradeVer;
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !node.getNodeName().equals(UPGRADE) || NullOrEmpty.nullOrEmpty(upgradeVer = (e = (Element)node).getAttribute(VERSION))) continue;
                    versions.add(upgradeVer);
                }
            }
            return versions;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

