/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.reflect;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import javax.tools.FileObject;
import oracle.dbtools.common.reflect.FileResource;
import oracle.dbtools.common.reflect.FileResourceFactory;

class ResourcesFixture {
    private final Map<String, FileObject> resources = new TreeMap<String, FileObject>();
    private final FileResourceFactory factory;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    ResourcesFixture(FileResourceFactory factory) {
        this.factory = factory;
    }

    FileObject create(String path) throws IOException {
        FileResource file = this.factory.get(path);
        Resource resource = new Resource(file);
        this.resources.put(path, resource);
        return resource;
    }

    FileObject get(String path) throws FileNotFoundException {
        FileObject resource = this.resources.get(path);
        if (resource == null) {
            throw new FileNotFoundException(path);
        }
        return resource;
    }

    private class Resource
    implements FileObject {
        private final FileResource resource;

        Resource(FileResource resource) {
            this.resource = resource;
        }

        @Override
        public boolean delete() {
            try {
                ResourcesFixture.this.resources.remove(this.resource.path());
                return this.resource.delete();
            }
            catch (IOException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            StringBuilder b = new StringBuilder();
            try (Reader r = null;){
                char[] buf = new char[4096];
                r = this.openReader(ignoreEncodingErrors);
                int len = r.read(buf);
                while (len != -1) {
                    b.append(buf, 0, len);
                }
            }
            return b.toString();
        }

        @Override
        public long getLastModified() {
            return this.resource.lastModified();
        }

        @Override
        public String getName() {
            return this.resource.path();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.resource.inputStream();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.resource.outputStream();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return new InputStreamReader(this.openInputStream(), UTF_8);
        }

        @Override
        public Writer openWriter() throws IOException {
            return new OutputStreamWriter(this.openOutputStream(), UTF_8);
        }

        @Override
        public URI toUri() {
            return URI.create(this.resource.path());
        }
    }
}

