/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.regex;

import java.util.Arrays;
import oracle.dbtools.common.regex.Substitution;
import oracle.dbtools.common.util.Transform;

public class Substitutions
implements Transform<CharSequence, String> {
    private final Substitution[] substitutions;

    public Substitutions(Substitution ... substitutions) {
        this.substitutions = substitutions;
    }

    @Override
    public String apply(CharSequence text) {
        if (text == null) {
            return null;
        }
        String result = text.toString();
        for (Substitution substitution : this.substitutions) {
            result = substitution.apply(result);
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(Arrays.toString(this.substitutions));
        builder.append("]");
        return builder.toString();
    }
}

