/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.tash;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.inject.Inject;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.di.Services;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.Maps;
import oracle.dbtools.common.immutables.Sets;
import oracle.dbtools.common.immutables.impl.ImmutablesProvider;
import oracle.dbtools.common.reflect.ClassLoaderResources;
import oracle.dbtools.common.reflect.ClassLoaderResourcesProvider;
import oracle.dbtools.common.resources.ResourcesContainer;
import oracle.dbtools.common.tash.TashTemplate;
import oracle.dbtools.common.tash.TashTemplates;
import oracle.dbtools.common.tash.TashTemplatesProvider;
import oracle.dbtools.common.util.IOStreamsProvider;
import oracle.dbtools.common.util.Ordering;
import oracle.dbtools.objects.Serialize;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.io.IOStreams;

@Provides
public class TashBeanGenerator {
    private TashTemplate template;
    private final Maps maps;
    private final Sets sets;

    @Inject
    public TashBeanGenerator(TashTemplates templates, IOStreams streams, Sets sets, Maps maps, ClassLoaderResources classLoaderResources) {
        ResourcesContainer resources = ResourcesContainer.builder(classLoaderResources).base("tash-templates/").build();
        try {
            String text = streams.asString(resources.get("bean.tash").inputStream());
            this.template = templates.template(text, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.sets = sets;
        this.maps = maps;
    }

    private ImmutableMap<String, String> property(Method m) {
        ImmutableMap.Builder<String, String> properties = this.maps.builder();
        String name = m.getName();
        String propType = m.getReturnType().getSimpleName();
        properties.add("name", name);
        properties.add("type", propType);
        return properties.build();
    }

    private ImmutableMap<String, String> imported(Class<?> type) {
        ImmutableMap.Builder<String, String> properties = this.maps.builder();
        properties.add("type", type.getName().replace('$', '.'));
        return properties.build();
    }

    public String generate(Class<?> type) {
        ImmutableMap.Builder<String, Object> metadata = this.maps.builder();
        ImmutableSet.Builder<ImmutableMap<String, String>> imports = this.sets.builder().ordering(Ordering.SORTED);
        ImmutableSet.Builder<ImmutableMap<String, String>> properties = this.sets.builder().ordering(Ordering.SORTED);
        for (Method m : type.getMethods()) {
            Class<?> declClass = m.getDeclaringClass();
            Class<?> returnType = m.getReturnType();
            if (m.getParameterTypes().length != 0 || Object.class.equals(declClass) || !this.serializable(m) || "modify".equals(m.getName())) continue;
            try {
                if (returnType.getName().indexOf(46) != -1) {
                    imports.add(this.imported(returnType));
                }
                properties.add(this.property(m));
            }
            catch (Throwable t) {
                throw UnrecoverableException.unrecoverable(t);
            }
        }
        imports.add(this.imported(type));
        metadata.add("package", type.getPackage().getName());
        metadata.add("imports", imports.build());
        metadata.add("properties", properties.build());
        metadata.add("name", type.getSimpleName());
        String result = this.template.render(metadata.build());
        return result;
    }

    private boolean serializable(Method m) {
        Class<?> type = m.getDeclaringClass();
        Serialize ignore = type.getAnnotation(Serialize.class);
        if (ignore == null) {
            return m.getAnnotation(Serialize.class) == null;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        Class<?> type = Class.forName(args[0]);
        Services services = ImmutablesProvider.add(Services.builder()).add(IOStreamsProvider.class).add(ClassLoaderResourcesProvider.class).add(TashTemplatesProvider.class).add(TashBeanGenerator.class).build("TashBeanGenerator Scope");
        TashBeanGenerator generator = services.acquire(TashBeanGenerator.class);
        System.out.append(generator.generate(type));
    }
}

