/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.FilterReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipFile;
import oracle.dbtools.common.CommonMessages;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.ucp.Connections;
import oracle.dbtools.common.util.Log;
import oracle.jdbc.OracleBfile;
import oracle.ucp.jdbc.LabelableConnection;

public abstract class Closeables {
    private static final Closer BFILES = new SQLCloser<OracleBfile>(OracleBfile.class){

        @Override
        protected void closeSQLType(OracleBfile closeable) throws SQLException {
            if (closeable.isOpen()) {
                closeable.close();
            }
        }
    };
    private static final Closer COLLECTIONS_ITERATOR = new CollectionIteratorCloser();
    private static final Closer CONNECTIONS = new SQLCloser<Connection>(Connection.class){

        @Override
        protected void closeSQLType(Connection target) throws SQLException {
            Connections.getInstance().close(target);
        }
    };
    private static final Closer EMPTY_COLLECTIONS = new EmptyCollectionCloser();
    private static boolean FAIL_ON_NOT_CLOSED = false;
    private static final Closer JDBC_BLOBS = new SQLCloser<Blob>(Blob.class){

        @Override
        protected void closeSQLType(Blob closeable) throws SQLException {
            closeable.free();
        }
    };
    private static final Closer JDBC_CLOBS = new SQLCloser<Clob>(Clob.class){

        @Override
        protected void closeSQLType(Clob closeable) throws SQLException {
            closeable.free();
        }
    };
    private static final Closer RESULTSETS = new SQLCloser<ResultSet>(ResultSet.class){

        @Override
        protected void closeSQLType(ResultSet closeable) throws SQLException {
            closeable.close();
        }
    };
    private static final Closer SQLXMLS = new SQLCloser<SQLXML>(SQLXML.class){

        @Override
        protected void closeSQLType(SQLXML closeable) throws SQLException {
            closeable.free();
        }
    };
    private static final Closer STATEMENTS = new SQLCloser<Statement>(Statement.class){

        @Override
        protected void closeSQLType(Statement closeable) throws SQLException {
            closeable.close();
        }
    };
    private static final Closer ZIP_FILE = new ZipCloser(ZipFile.class);
    private static final Set<Closer> THE_CLOSERS = new LinkedHashSet<Closer>(Arrays.asList(RESULTSETS, STATEMENTS, CONNECTIONS, JDBC_BLOBS, JDBC_CLOBS, BFILES, SQLXMLS, COLLECTIONS_ITERATOR, EMPTY_COLLECTIONS, ZIP_FILE));

    public static InputStream alsoClose(InputStream inputStream, Object ... dependents) {
        return new AlsoClose(inputStream, dependents);
    }

    public static Reader alsoClose(Reader reader, Object ... dependents) {
        return new AlsoCloseReader(reader, dependents);
    }

    public static void close(Object ... closeables) {
        for (Object closeable : closeables) {
            Closeables.close(closeable);
        }
    }

    public static <T> void close(T closeable) {
        if (closeable != null) {
            boolean closed = false;
            Closeables.flush(closeable);
            if (closeable instanceof Closeable) {
                try {
                    ((Closeable)closeable).close();
                    closed = true;
                }
                catch (IOException iOException) {}
            } else {
                for (Closer closer : THE_CLOSERS) {
                    try {
                        closed = closer.close(closeable);
                        if (!closed) continue;
                        break;
                    }
                    catch (IOException iOException) {
                    }
                }
            }
            if (!closed && FAIL_ON_NOT_CLOSED) {
                throw UnrecoverableException.unrecoverable(new TranslatableMessage(CommonMessages.class, "Closeables.0", "Don't know how to close instances of type: ", closeable.getClass().getName()));
            }
        }
    }

    public static InputStream ignoreClose(InputStream doNotClose) {
        return new IgnoreCloseStream(doNotClose);
    }

    static void resetPDBConnection(Connection target) {
        if (target instanceof LabelableConnection) {
            // empty if block
        }
    }

    private static <T> void flush(T closeable) {
        if (closeable instanceof Flushable) {
            try {
                ((Flushable)closeable).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class ZipCloser
    extends BaseCloser<ZipFile> {
        private ZipCloser(Class<ZipFile> expectedType) {
            super(expectedType);
        }

        @Override
        protected void closeType(ZipFile closeable) throws IOException {
            closeable.close();
        }
    }

    private static abstract class SQLCloser<T>
    extends BaseCloser<T> {
        protected static final Log LOG = Log.get(SQLCloser.class);

        protected SQLCloser(Class<T> expectedType) {
            super(expectedType);
        }

        protected abstract void closeSQLType(T var1) throws SQLException;

        @Override
        protected final void closeType(T closeable) throws IOException {
            try {
                this.closeSQLType(closeable);
            }
            catch (Throwable e) {
                LOG.finest(e);
            }
        }
    }

    private static final class IgnoreCloseStream
    extends FilterInputStream {
        private IgnoreCloseStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.in.toString();
        }
    }

    private static final class EmptyCollectionCloser
    implements Closer {
        private EmptyCollectionCloser() {
        }

        @Override
        public boolean close(Object instance) throws IOException {
            return instance == Collections.EMPTY_LIST || instance == Collections.EMPTY_SET || instance == Collections.EMPTY_MAP;
        }
    }

    private static final class CollectionIteratorCloser
    extends BaseCloser<Iterator> {
        private CollectionIteratorCloser() {
            super(Iterator.class);
        }

        @Override
        protected boolean canClose(Object instance) {
            boolean isIterator = super.canClose(instance);
            return isIterator && instance.getClass().getName().startsWith("java.util.");
        }

        @Override
        protected void closeType(Iterator closeable) throws IOException {
        }
    }

    public static class AlsoCloseReader
    extends FilterReader {
        private final Object[] dependents;

        protected AlsoCloseReader(Reader in, Object ... dependents) {
            super(in);
            this.dependents = dependents;
        }

        @Override
        public void close() {
            Closeables.close(this.dependents);
        }
    }

    public static class AlsoClose
    extends FilterInputStream {
        private final Object[] dependents;

        protected AlsoClose(InputStream in, Object ... dependents) {
            super(in);
            this.dependents = dependents;
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.dependents);
        }
    }

    public static interface Closer {
        public boolean close(Object var1) throws IOException;
    }

    public static abstract class BaseCloser<T>
    implements Closer {
        private final Class<T> type;

        protected BaseCloser(Class<T> expectedType) {
            this.type = expectedType;
        }

        @Override
        public boolean close(Object instance) throws IOException {
            if (instance != null && this.canClose(instance)) {
                this.closeType(this.type.cast(instance));
                return true;
            }
            return false;
        }

        public String toString() {
            return "BaseCloser [type=" + this.type + "]";
        }

        protected boolean canClose(Object instance) {
            return this.type.isAssignableFrom(instance.getClass());
        }

        protected abstract void closeType(T var1) throws IOException;
    }
}

