/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Text;

public abstract class ConfigFiles {
    private ConfigFiles() {
    }

    public static AssociativeArray<String, String> asArray(Properties props) {
        return new FromProperties(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void load(Properties properties, File file) throws IOException {
        if (file.exists()) {
            InputStream in = null;
            try {
                in = Files.inputStream(file);
                ConfigFiles.load(properties, in, ConfigFiles.isXml(file));
            }
            finally {
                Closeables.close(in);
            }
        }
    }

    public static void load(Properties properties, InputStream in, boolean isXml) throws IOException {
        if (isXml) {
            properties.loadFromXML(in);
        } else {
            properties.load(new InputStreamReader(in, Text.defaultCharset()));
        }
    }

    public static synchronized void save(Properties properties, File file) throws IOException {
        OutputStream out = null;
        try {
            Files.createParentFolder(file);
            out = Files.outputStream(file);
            ConfigFiles.store(out, properties);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            Closeables.close(out);
        }
    }

    public static InputStream toInputStream(Properties properties) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ConfigFiles.store(bytes, properties);
        return new ByteArrayInputStream(bytes.toByteArray());
    }

    private static boolean isXml(File file) {
        return file.getName().endsWith(".xml");
    }

    private static void store(OutputStream out, Properties properties) throws IOException {
        properties.storeToXML(out, "Saved on " + new Date(), Text.defaultEncoding());
    }

    public static final class FromProperties
    extends AssociativeArrays.Base<String, String> {
        private final Properties props;

        public FromProperties(Properties props) {
            this.props = props;
        }

        @Override
        public String get(Object key) {
            return this.props.getProperty(key.toString());
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.transform(this.props.keySet().iterator(), Iterators.AS_STRING);
        }

        @Override
        public int size() {
            return this.props.size();
        }
    }
}

