/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Set;
import oracle.dbtools.common.reflect.MethodInvocation;
import oracle.dbtools.common.reflect.MethodInvocationDecorator;
import oracle.dbtools.common.reflect.MethodInvocationTracer;
import oracle.dbtools.common.util.Arrays;
import oracle.dbtools.common.util.Reflections;

public class Invocations {
    private final Recorder recorder;

    public Invocations(Appendable out) {
        this.recorder = new Recorder(out);
    }

    public <T> T trace(Object target, Class<T> type, Class<?> ... tracedTypes) {
        if (tracedTypes.length > 0) {
            Set<Class<?>> allTypes = Arrays.asSet(Arrays.flatten(new Class[]{type}, tracedTypes));
            tracedTypes = allTypes.toArray(new Class[allTypes.size()]);
        }
        Object traced = new MethodInvocationTracer(this.recorder, tracedTypes).trace(target, type);
        this.recorder.declare(traced, type, true);
        return traced;
    }

    private static class Recorder
    extends MethodInvocationDecorator {
        private final Appendable out;
        private int var = 0;
        private final IdentityHashMap<Object, String> variables = new IdentityHashMap();

        public Recorder(Appendable out) {
            this.out = out;
        }

        @Override
        public Object after(Object result, MethodInvocation invocation) {
            Method method = invocation.method();
            Object proxy = invocation.proxy();
            Object[] args = invocation.parameters();
            Class<?> type = method.getReturnType();
            this.declare(result, type, true);
            this.record(result, proxy, method, args);
            return result;
        }

        @Override
        public Throwable onException(Throwable e, MethodInvocation invocation) {
            this.record(null, invocation.proxy(), invocation.method(), invocation.parameters());
            return e;
        }

        public String toString() {
            return this.out.toString();
        }

        private void declare(Object object, Class<?> type, boolean force) {
            if (!Void.TYPE.equals(type) && (force || object != null && !this.variables.containsKey(object) && !Reflections.isPrimitive(type))) {
                try {
                    this.out.append(this.typeName(type));
                    this.out.append(" ");
                    this.out.append(this.register(object));
                    this.out.append(";\n");
                    Recorder.flush(this.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private String name(Object object) {
            String name = "null";
            if (object != null && (name = this.variables.get(object)) == null) {
                if (Reflections.isPrimitive(object.getClass())) {
                    return this.render(object);
                }
                throw new RuntimeException("Could not find name for: " + System.identityHashCode(object));
            }
            return name;
        }

        private void record(Object result, Object proxy, Method method, Object[] args) {
            try {
                if (args != null) {
                    Class<?>[] types = method.getParameterTypes();
                    for (int i = 0; i < args.length; ++i) {
                        this.declare(args[i], types[i], false);
                    }
                }
                if (result != null) {
                    this.out.append(this.name(result));
                    this.out.append(" = ");
                }
                this.out.append(this.name(proxy));
                this.out.append('.');
                this.out.append(method.getName());
                this.out.append('(');
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        this.out.append(this.name(args[i]));
                        if (i >= args.length - 1) continue;
                        this.out.append(',');
                    }
                }
                this.out.append(");\n");
                Recorder.flush(this.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private String register(Object object) {
            String name = this.variables.get(object);
            if (name == null) {
                name = "v" + ++this.var;
                this.variables.put(object, name);
            }
            return name;
        }

        private String render(Object object) {
            Class<?> type = object.getClass();
            if (String.class.equals(type)) {
                return "\"" + object.toString() + "\"";
            }
            if (Short.TYPE.equals(type) || Short.class.equals(type)) {
                return "(short)" + object.toString();
            }
            if (Long.TYPE.equals(type) || Long.class.equals(type)) {
                return object.toString() + "L";
            }
            if (Character.TYPE.equals(type) || Character.class.equals(type)) {
                return "'" + object.toString() + "'";
            }
            return object.toString();
        }

        private String typeName(Class<?> type) {
            if (type.isArray()) {
                return this.typeName(type.getComponentType()) + "[]";
            }
            return type.getName();
        }

        private static void flush(Appendable out) {
            if (out instanceof Flushable) {
                try {
                    ((Flushable)((Object)out)).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

