/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;

public abstract class SerializerBase<K, V>
implements MultiAssociativeArrays.Serializer<K, V> {
    protected abstract void writeKey(ObjectOutputStream var1, K var2) throws IOException;

    protected abstract void writeValue(ObjectOutputStream var1, V var2) throws IOException;

    protected abstract K readKey(int var1, ObjectInputStream var2) throws IOException, ClassNotFoundException;

    protected abstract V readValue(int var1, ObjectInputStream var2) throws IOException, ClassNotFoundException;

    @Override
    public MultiAssociativeArray<K, V> read(InputStream in) throws IOException, ClassNotFoundException {
        MultiAssociativeArrays.Builder<K, V> values = MultiAssociativeArrays.builder();
        ObjectInputStream ois = new ObjectInputStream(in);
        int numKeys = ois.readInt();
        for (int i = 0; i < numKeys; ++i) {
            K k = this.readKey(i, ois);
            int size = ois.readInt();
            for (int j = 0; j < size; ++j) {
                V v = this.readValue(j, ois);
                values.add(k, v);
            }
        }
        return values.build();
    }

    @Override
    public void write(OutputStream out, MultiAssociativeArray<K, V> values) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        int numKeys = values.size();
        oos.writeInt(numKeys);
        for (Object key : values) {
            this.writeKey(oos, key);
            Iterable<V> items = values.values(key);
            int size = Iterables.size(items);
            oos.writeInt(size);
            for (V item : items) {
                this.writeValue(oos, item);
            }
        }
        oos.flush();
    }
}

