/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import oracle.dbtools.common.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XPaths {
    private static final Log LOG = Log.get(XPaths.class);

    private XPaths() {
    }

    public static Expression expression(String path, NamespaceContext nsContext) {
        return new Expression(path, nsContext);
    }

    public static Document parse(InputStream content) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            XPaths.setFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
            XPaths.setFeature(factory, "http://apache.org/xml/features/validation/schema", false);
            XPaths.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(content);
            return doc;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException(e);
        }
    }

    public static <T> T select(InputStream content, Expression xpathExpression, Class<T> nodeType) throws IOException {
        Document doc = XPaths.parse(content);
        return XPaths.select(doc, xpathExpression, nodeType);
    }

    public static <T> T select(Document doc, Expression xpathExpression, Class<T> nodeType) throws IOException {
        try {
            XPathFactory xFactory = XPathFactory.newInstance();
            XPaths.setFeature(xFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
            XPath xpath = xFactory.newXPath();
            xpath.setNamespaceContext(xpathExpression.namespaceContext);
            XPathExpression expr = xpath.compile(xpathExpression.text);
            Object result = expr.evaluate(doc, XPaths.nodeType(nodeType));
            return nodeType.cast(result);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException(e);
        }
    }

    private static QName nodeType(Class<?> nodeType) {
        if (Node.class.equals(nodeType)) {
            return XPathConstants.NODE;
        }
        if (NodeList.class.equals(nodeType)) {
            return XPathConstants.NODESET;
        }
        throw new IllegalArgumentException(nodeType.getCanonicalName());
    }

    private static void setFeature(DocumentBuilderFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (ParserConfigurationException e) {
            LOG.fine(e);
        }
    }

    private static void setFeature(XPathFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (XPathFactoryConfigurationException e) {
            LOG.fine(e);
        }
    }

    public static class Expression {
        private final NamespaceContext namespaceContext;
        private final String text;

        private Expression(String text, NamespaceContext namespaceContext) {
            this.text = text;
            this.namespaceContext = namespaceContext;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Expression other = (Expression)obj;
            if (this.namespaceContext == null ? other.namespaceContext != null : !this.namespaceContext.equals(other.namespaceContext)) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.namespaceContext == null ? 0 : this.namespaceContext.hashCode());
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Expression [text=");
            builder.append(this.text);
            builder.append(", namespaceContext=");
            builder.append(this.namespaceContext);
            builder.append("]");
            return builder.toString();
        }
    }
}

