/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.zip.ZipBuilder;

public class MutatedZip
extends FilterInputStream {
    public MutatedZip(InputStream zip, String entry, InputStream content) throws IOException {
        super(MutatedZip.mutate(zip, (Map)Maps.builder().add(entry, content).build()));
    }

    public MutatedZip(InputStream zip, Map<String, InputStream> modifiedEntries) throws IOException {
        super(MutatedZip.mutate(zip, modifiedEntries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream mutate(InputStream zip, Map<String, InputStream> modifiedEntries) throws IOException {
        ZipInputStream compressed = null;
        ZipBuilder builder = ZipBuilder.builder();
        try {
            LinkedHashSet<String> newEntries = new LinkedHashSet<String>(modifiedEntries.keySet());
            ZipEntry zipEntry = null;
            if (zip != null) {
                compressed = new ZipInputStream(zip);
                zipEntry = compressed.getNextEntry();
                while (zipEntry != null) {
                    String name = zipEntry.getName();
                    InputStream modified = modifiedEntries.get(name);
                    if (modified == null) {
                        builder.addEntry(name, compressed);
                    } else {
                        builder.addEntry(name, modified);
                        newEntries.remove(name);
                    }
                    zipEntry = compressed.getNextEntry();
                }
            }
            for (String entry : newEntries) {
                InputStream content = modifiedEntries.get(entry);
                builder.addEntry(entry, content);
            }
            InputStream inputStream = builder.build();
            return inputStream;
        }
        finally {
            Closeables.close(compressed);
        }
    }
}

