/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import oracle.ide.file.FileChangeListener;
import oracle.ide.file.FileChanges;
import oracle.ide.file.FileChangesExpiredException;
import oracle.ide.file.FileScope;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetTable;
import oracle.ide.file.FileTable;
import oracle.ide.file.Path;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.Storage;
import oracle.javatools.util.NullArgumentException;
import org.openide.util.RequestProcessor;

public abstract class AbstractFileScope
implements FileScope {
    private static final ExecutorService SCHEDULER = AbstractFileScope.createTaskScheduler();
    private static final Logger LOGGER = Logger.getLogger("oracle.ide.file");
    @GuardedBy(value="itself")
    private final List<FileChangeListener> listeners = new ArrayList<FileChangeListener>(3);
    @GuardedBy(value="listeners")
    private FileChangeListener fileTableListener;
    @GuardedBy(value="listeners")
    private Set<FileSetTable> fileTables;

    private static ExecutorService createTaskScheduler() {
        return new RequestProcessor("File Scope Event Delivery", 1, true);
    }

    protected abstract void activate();

    protected abstract void deactivate();

    protected abstract Storage getStorage();

    protected abstract Path getPath();

    protected Logger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyPathChanged() {
        FileChangeListener localListener;
        Storage storage = this.getStorage();
        Path oldPath = this.getPathFromTables();
        Path newPath = this.getPath();
        final HashSet<FileSetTable> added = new HashSet<FileSetTable>();
        final HashSet<FileSetTable> removed = new HashSet<FileSetTable>();
        List<FileChangeListener> list = this.listeners;
        synchronized (list) {
            FileSetTable table;
            localListener = this.fileTableListener;
            for (FileSet fileSet : newPath) {
                if (oldPath.contains(fileSet)) continue;
                table = FileSetTable.getInstance(storage, fileSet);
                table.addFileChangeListener(this.fileTableListener);
                this.fileTables.add(table);
                added.add(table);
            }
            for (FileSet fileSet : oldPath) {
                if (newPath.contains(fileSet)) continue;
                table = FileSetTable.getInstance(storage, fileSet);
                this.fileTables.remove(table);
                removed.add(table);
            }
        }
        if (!removed.isEmpty() && localListener != null) {
            for (FileTable fileTable : removed) {
                fileTable.removeFileChangeListener(localListener);
            }
        }
        if (!added.isEmpty() || !removed.isEmpty()) {
            AbstractFileScope.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractFileScope.this.deliverAddedAndRemovedEvents(added, removed);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFileChangeListener(FileChangeListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        List<FileChangeListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                this.activate();
                this.fileTableListener = new FileChangeListener(){

                    @Override
                    public void filesChanged(FileScope scope, FileChanges changes) {
                        AbstractFileScope.this.invokeListeners(changes);
                    }
                };
                this.fileTables = new HashSet<FileSetTable>();
                Storage storage = this.getStorage();
                for (FileSet fileSet : this.getPath()) {
                    FileSetTable table = FileSetTable.getInstance(storage, fileSet);
                    table.addFileChangeListener(this.fileTableListener);
                    this.fileTables.add(table);
                }
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFileChangeListener(FileChangeListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        List<FileChangeListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.remove(listener) && this.listeners.isEmpty()) {
                this.deactivate();
                for (FileTable fileTable : this.fileTables) {
                    fileTable.removeFileChangeListener(this.fileTableListener);
                }
                this.fileTableListener = null;
                this.fileTables = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<FileTable> getFileTables() {
        ArrayList<FileSetTable> localFileTables = null;
        List<FileChangeListener> list = this.listeners;
        synchronized (list) {
            if (this.fileTables != null) {
                localFileTables = new ArrayList<FileSetTable>(this.fileTables);
            }
        }
        ArrayList<FileTable> copy = new ArrayList<FileTable>();
        if (localFileTables == null) {
            Storage storage = this.getStorage();
            for (FileSet fileSet : this.getPath()) {
                copy.add(FileSetTable.getInstance(storage, fileSet));
            }
        } else {
            copy.addAll(localFileTables);
        }
        return copy;
    }

    @Override
    public FileTable getFileTable(URL url) {
        for (FileTable table : this.getFileTables()) {
            if (!table.contains(url)) continue;
            return table;
        }
        return null;
    }

    @Override
    public boolean contains(URL url) {
        for (FileTable table : this.getFileTables()) {
            if (!table.contains(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public URL locate(String relativePath) throws InterruptedException, IOException {
        for (FileTable table : this.getFileTables()) {
            AbstractFileScope.checkInterrupt();
            URL url = table.locate(relativePath);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Collection<URL> getFiles() throws IOException, InterruptedException {
        ArrayList<URL> urls = new ArrayList<URL>(100);
        for (FileTable table : this.getFileTables()) {
            urls.addAll(table.getFiles());
        }
        return Collections.unmodifiableCollection(urls);
    }

    @Override
    public Collection<URL> getDirectories() throws IOException, InterruptedException {
        ArrayList<URL> urls = new ArrayList<URL>(100);
        for (FileTable table : this.getFileTables()) {
            urls.addAll(table.getDirectories());
        }
        return Collections.unmodifiableCollection(urls);
    }

    @Override
    public void refresh() throws InterruptedException, IOException {
        this.refresh(null);
    }

    @Override
    public void refresh(FileChangeListener listener) throws InterruptedException, IOException {
        for (FileTable table : this.getFileTables()) {
            AbstractFileScope.checkInterrupt();
            table.refresh(listener);
        }
    }

    @Override
    public void update() throws InterruptedException, IOException {
        for (FileTable table : this.getFileTables()) {
            table.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeListeners(FileChanges changes) {
        ArrayList<FileChangeListener> copy;
        List<FileChangeListener> list = this.listeners;
        synchronized (list) {
            copy = new ArrayList<FileChangeListener>(this.listeners);
        }
        for (FileChangeListener listener : copy) {
            this.invokeListener(listener, changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeListener(FileChangeListener listener, FileChanges changes) {
        String listenerClass = listener.getClass().getName();
        long start = System.nanoTime();
        try {
            listener.filesChanged(this, changes);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Exception in listener " + listenerClass, t);
        }
        finally {
            PerformanceLogger.get().log("ProjectContentScope.invokeListener", listenerClass, System.nanoTime() - start);
        }
    }

    private void deliverAddedAndRemovedEvents(Collection<FileTable> added, Collection<FileTable> removed) throws InterruptedException {
        for (FileTable table : removed) {
            AbstractFileScope.checkInterrupt();
            try {
                table.getChangesSince(-1, -1L, this.fileTableListener);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (FileChangesExpiredException e) {
                this.getLogger().log(Level.SEVERE, "Should never receive FileChangesExpiredExcpetion for REMOVED_VERSION", e);
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Unable to deliver removed events for " + table, e);
            }
        }
        for (FileTable table : added) {
            AbstractFileScope.checkInterrupt();
            try {
                table.getChangesSince(0, -1L, this.fileTableListener);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (FileChangesExpiredException e) {
                this.getLogger().log(Level.SEVERE, "Should never receive FileChangesExpiredExcpetion for FIRST_VERSION", e);
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Unable to deliver added events for " + table, e);
            }
        }
    }

    private Path getPathFromTables() {
        Path path = Path.getInstance(this.fileTables.size());
        for (FileSetTable table : this.fileTables) {
            path.add(table.getFileSet());
        }
        return path;
    }

    private static void runLater(Runnable r) {
        SCHEDULER.execute(r);
    }

    private static void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }
}

