/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import org.graalvm.polyglot.io.FileSystem;

final class IOHelper {
    private IOHelper() {
        throw new IllegalStateException("No instance allowed.");
    }

    static void copy(Path source, Path target, FileSystem fileSystem, CopyOption ... options) throws IOException {
        IOHelper.copy(source, target, fileSystem, fileSystem, options);
    }

    static void copy(Path source, Path target, FileSystem sourceFileSystem, FileSystem targetFileSystem, CopyOption ... options) throws IOException {
        if (source.equals(target)) {
            return;
        }
        Path sourceReal = sourceFileSystem.toRealPath(source, LinkOption.NOFOLLOW_LINKS);
        Path targetReal = targetFileSystem.toRealPath(target, LinkOption.NOFOLLOW_LINKS);
        if (sourceReal.equals(targetReal)) {
            return;
        }
        HashSet<LinkOption> linkOptions = new HashSet<LinkOption>();
        EnumSet<StandardCopyOption> copyOptions = EnumSet.noneOf(StandardCopyOption.class);
        for (CopyOption option : options) {
            if (option instanceof StandardCopyOption) {
                copyOptions.add((StandardCopyOption)option);
                continue;
            }
            if (!(option instanceof LinkOption)) continue;
            linkOptions.add((LinkOption)option);
        }
        if (copyOptions.contains(StandardCopyOption.ATOMIC_MOVE)) {
            throw new AtomicMoveNotSupportedException(source.getFileName().toString(), target.getFileName().toString(), "Atomic move not supported");
        }
        Map<String, Object> sourceAttributes = sourceFileSystem.readAttributes(sourceReal, "basic:isSymbolicLink,isDirectory,lastModifiedTime,lastAccessTime,creationTime", linkOptions.toArray(new LinkOption[linkOptions.size()]));
        if (((Boolean)sourceAttributes.getOrDefault("isSymbolicLink", false)).booleanValue()) {
            throw new IOException("Copying of symbolic links is not supported.");
        }
        if (copyOptions.contains(StandardCopyOption.REPLACE_EXISTING)) {
            try {
                targetFileSystem.delete(targetReal);
            }
            catch (NoSuchFileException noSuchFileException) {}
        } else {
            boolean exists;
            try {
                targetFileSystem.checkAccess(targetReal, EnumSet.noneOf(AccessMode.class), new LinkOption[0]);
                exists = true;
            }
            catch (IOException ioe) {
                exists = false;
            }
            if (exists) {
                throw new FileAlreadyExistsException(target.toString());
            }
        }
        if (((Boolean)sourceAttributes.getOrDefault("isDirectory", false)).booleanValue()) {
            targetFileSystem.createDirectory(targetReal, new FileAttribute[0]);
        } else {
            EnumSet<StandardOpenOption> readOptions = EnumSet.of(StandardOpenOption.READ);
            EnumSet<StandardOpenOption> writeOptions = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            try (SeekableByteChannel sourceChannel = sourceFileSystem.newByteChannel(sourceReal, readOptions, new FileAttribute[0]);
                 SeekableByteChannel targetChannel = targetFileSystem.newByteChannel(targetReal, writeOptions, new FileAttribute[0]);){
                ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
                while (sourceChannel.read(buffer) != -1) {
                    buffer.flip();
                    while (buffer.hasRemaining()) {
                        targetChannel.write(buffer);
                    }
                    buffer.clear();
                }
            }
        }
        if (copyOptions.contains(StandardCopyOption.COPY_ATTRIBUTES)) {
            String[] basicMutableAttributes = new String[]{"lastModifiedTime", "lastAccessTime", "creationTime"};
            try {
                for (String key : basicMutableAttributes) {
                    Object value = sourceAttributes.get(key);
                    if (value == null) continue;
                    targetFileSystem.setAttribute(targetReal, key, value, new LinkOption[0]);
                }
            }
            catch (Throwable rootCause) {
                try {
                    targetFileSystem.delete(targetReal);
                }
                catch (Throwable suppressed) {
                    rootCause.addSuppressed(suppressed);
                }
                throw rootCause;
            }
        }
    }

    static void move(Path source, Path target, FileSystem fileSystem, CopyOption ... options) throws IOException {
        for (CopyOption option : options) {
            if (!StandardCopyOption.ATOMIC_MOVE.equals(option)) continue;
            throw new AtomicMoveNotSupportedException(source.getFileName().toString(), target.getFileName().toString(), "Atomic move not supported");
        }
        fileSystem.copy(source, target, options);
        fileSystem.delete(source);
    }

    static void move(Path source, Path target, FileSystem sourceFileSystem, FileSystem targetFileSystem, CopyOption ... options) throws IOException {
        for (CopyOption option : options) {
            if (!StandardCopyOption.ATOMIC_MOVE.equals(option)) continue;
            throw new AtomicMoveNotSupportedException(source.getFileName().toString(), target.getFileName().toString(), "Atomic move not supported");
        }
        IOHelper.copy(source, target, sourceFileSystem, targetFileSystem, options);
        sourceFileSystem.delete(source);
    }
}

