/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.OffsetDateTime;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlColumnDescriptor;
import oracle.pg.rdbms.pgql.PgqlExecution;
import oracle.pg.rdbms.pgql.PgqlResultElement;
import oracle.pg.rdbms.pgql.PgqlResultSetImpl;
import oracle.pg.rdbms.pgql.PgqlResultSetMetaDataImpl;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSetMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgSchemaResultSet
extends PgqlResultSetImpl {
    private static final Logger ms_log = LoggerFactory.getLogger(PgSchemaResultSet.class);
    private final PgqlColumnDescriptor[] colDesc;
    private static final String COLUMN_NOT_FOUND = "Column name not found";

    PgSchemaResultSet(ResultSet rs, Statement stmt, PgqlColumnDescriptor[] colDesc, int fetchSize, QueryContext ctx, PgqlExecution ope, long id) throws SQLException {
        super(rs, stmt, fetchSize, ctx, ope, id);
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Constructing a new PgqlResultSet id=[" + id + "]");
        }
        this.colDesc = colDesc;
    }

    private PgqlResultElement getPgqlResultElement(int elementIdx) throws PgqlException {
        try {
            return DbmsUtils.getPgqlResultElement(this.rs, this.colDesc[elementIdx - 1]);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    private int getIdxForElemName(String elementName) throws PgqlException {
        for (int i = 0; i < this.colDesc.length; ++i) {
            if (!this.colDesc[i].getColName().equals(elementName)) continue;
            return i + 1;
        }
        throw new PgqlException(COLUMN_NOT_FOUND);
    }

    @Override
    public int getValueType(int elementIdx) throws PgqlException {
        PgqlResultElement elem = this.getPgqlResultElement(elementIdx);
        return elem.getValueType();
    }

    @Override
    public int getValueType(String elementName) throws PgqlException {
        return this.getValueType(this.getIdxForElemName(elementName));
    }

    public ResultSetMetaData getMetaData() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Returning a new PgqlResultSetMetaDataImpl");
        }
        return new PgqlResultSetMetaDataImpl(this.colDesc);
    }

    public Object getObject(int elementIdx) throws PgqlException {
        Object o;
        try {
            PgqlResultElement opre = this.getPgqlResultElement(elementIdx);
            o = opre.getContents();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
        return o;
    }

    public Object getObject(String elementName) throws PgqlException {
        return this.getObject(this.getIdxForElemName(elementName));
    }

    public String getString(int elementIdx) throws PgqlException {
        try {
            return (String)this.getObject(elementIdx);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public String getString(String elementName) throws PgqlException {
        try {
            return (String)this.getObject(elementName);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Integer getInteger(int elementIdx) throws PgqlException {
        try {
            return (Integer)this.getObject(elementIdx);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Integer getInteger(String elementName) throws PgqlException {
        return this.getInteger(this.getIdxForElemName(elementName));
    }

    public Long getLong(int elementIdx) throws PgqlException {
        try {
            return (Long)this.getObject(elementIdx);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Long getLong(String elementName) throws PgqlException {
        return this.getLong(this.getIdxForElemName(elementName));
    }

    public Float getFloat(int elementIdx) throws PgqlException {
        try {
            return (Float)this.getObject(elementIdx);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Float getFloat(String elementName) throws PgqlException {
        return this.getFloat(this.getIdxForElemName(elementName));
    }

    public Double getDouble(int elementIdx) throws PgqlException {
        try {
            return (Double)this.getObject(elementIdx);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Double getDouble(String elementName) throws PgqlException {
        return this.getDouble(this.getIdxForElemName(elementName));
    }

    public Boolean getBoolean(int elementIdx) throws PgqlException {
        try {
            return (Boolean)this.getObject(elementIdx);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Boolean getBoolean(String elementName) throws PgqlException {
        return this.getBoolean(this.getIdxForElemName(elementName));
    }

    public OffsetDateTime getTimestampWithTimezone(String elementName) throws PgqlException {
        return this.getTimestampWithTimezone(this.getIdxForElemName(elementName));
    }
}

