/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlExecution;
import oracle.pg.rdbms.pgql.PgqlPreparedStatement;
import oracle.pg.rdbms.pgql.PgqlStatement;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgqlConnection {
    private static Logger ms_log = LoggerFactory.getLogger(PgqlConnection.class);
    private final Connection conn;
    private String schema;
    private String graph;

    private PgqlConnection(Connection conn) {
        this.conn = conn;
        this.schema = null;
        this.graph = null;
    }

    public static PgqlConnection getConnection(Connection conn) {
        return new PgqlConnection(conn);
    }

    public void setSchema(String schema) {
        try {
            this.schema = schema == null ? null : PgqlConnection.stripQuotes(DbmsUtils.sanitizeIdentifier(this.conn, schema));
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    public void setGraph(String graph) {
        try {
            this.graph = graph == null ? null : PgqlConnection.stripQuotes(DbmsUtils.sanitizeIdentifier(this.conn, graph));
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private static String stripQuotes(String s) {
        if (s.matches("^\".+\"$")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public PgqlStatement createStatement() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("returning new PgqlExecution object");
        }
        return new PgqlExecution(this);
    }

    public PgqlPreparedStatement prepareStatement(String pgql) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("returning new PgqlExecution object");
        }
        return new PgqlExecution(this, pgql);
    }

    public String getSchema() throws PgqlToSqlException {
        try {
            return this.schema == null ? this.conn.getSchema() : this.schema;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    public String getGraph() {
        return this.graph;
    }

    public Connection getJdbcConnection() {
        return this.conn;
    }
}

