/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import oracle.pg.rdbms.pgql.PgqlColumnDescriptor;
import oracle.pg.rdbms.pgql.PgqlResultElement;
import oracle.pgql.lang.PgqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgqlResultElementImpl
implements PgqlResultElement {
    private static Logger ms_log = LoggerFactory.getLogger(PgqlResultElementImpl.class);
    private PgqlColumnDescriptor.Type columnType;
    private int valueType;
    private String name;
    private Object contents;
    private static final String VERTEX_NOT_SUPPORTED_MSG = "OracleVertex objects cannot be returned through this interface";
    private static final String EDGE_NOT_SUPPORTED_MSG = "OracleEdge objects cannot be returned through this interface";

    PgqlResultElementImpl(PgqlColumnDescriptor.Type columnType, int valueType, String name, Object contents) {
        this.columnType = columnType;
        this.valueType = valueType;
        this.name = name;
        this.contents = contents;
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Creating Result Element:");
            ms_log.debug(this.toString());
        }
    }

    @Override
    public Object getContents() throws PgqlException {
        if (ms_log.isDebugEnabled()) {
            if (this.contents != null) {
                ms_log.debug("getContents: contents=[" + this.contents.toString() + "]");
            } else {
                ms_log.debug("getContents: contents=[NULL]");
            }
        }
        if (this.getColumnType() == PgqlColumnDescriptor.Type.VERTEX) {
            throw new PgqlException(VERTEX_NOT_SUPPORTED_MSG);
        }
        if (this.getColumnType() == PgqlColumnDescriptor.Type.EDGE) {
            throw new PgqlException(EDGE_NOT_SUPPORTED_MSG);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Returning value=[" + this.contents + "]");
        }
        return this.contents;
    }

    @Override
    public PgqlColumnDescriptor.Type getColumnType() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Returning columnType=[" + (Object)((Object)this.columnType) + "]");
        }
        return this.columnType;
    }

    @Override
    public int getValueType() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Returning valueType=[" + this.valueType + "]");
        }
        return this.valueType;
    }

    @Override
    public String getColumnName() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Returning columnName=[" + this.name + "]");
        }
        return this.name;
    }

    public String toString() {
        String s = "Var Name=[" + this.name + "]\nElement Type=[" + (Object)((Object)this.columnType) + "]\nValue Type=[" + this.valueType + "]\n";
        s = this.contents != null ? s + "Contents=[" + this.contents.toString() + "]\n" : s + "Contents=[NULL]\n";
        return s;
    }
}

