/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlExecution;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultAccess;
import oracle.pgql.lang.ResultSetFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PgqlResultSetImpl
implements PgqlResultSet {
    private static final Logger ms_log = LoggerFactory.getLogger(PgqlResultSetImpl.class);
    protected ResultSet rs;
    private final Statement stmt;
    private final QueryContext ctx;
    private final PgqlExecution ope;
    private final long id;
    private PgqlResultSetIterator iterator = null;
    private static final String FEATURE_NOT_IMPLEMENTED = "Feature not implemented";

    protected PgqlResultSetImpl(ResultSet rs, Statement stmt, int fetchSize, QueryContext ctx, PgqlExecution ope, long id) throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Constructing a new PgqlResultSet id=[" + id + "]");
        }
        this.rs = rs;
        this.stmt = stmt;
        this.ctx = ctx;
        this.ope = ope;
        this.id = id;
        if (this.rs != null) {
            this.rs.setFetchSize(fetchSize);
        }
    }

    @Override
    public void close() throws PgqlException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("close() called ... closing the underlying result set and stmt");
            ms_log.debug("Calling OraclePropertyGraphUtilsBase.quietlyCloseResultSetAndStmt");
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(this.rs, this.stmt);
        this.ope.deregisterResultSet(this.id);
    }

    @Override
    public PgqlResultSet print() {
        try {
            ResultSetFormatter.out((oracle.pgql.lang.ResultSet)this);
        }
        catch (PgqlException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return this;
    }

    @Override
    public PgqlResultSet print(PrintStream printStream, long numResults, int from) {
        try {
            ResultSetFormatter.out((oracle.pgql.lang.ResultSet)this, (PrintStream)printStream, (long)numResults, (int)from);
        }
        catch (PgqlException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return this;
    }

    public boolean next() throws PgqlException {
        try {
            return this.rs.next();
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public boolean previous() throws PgqlException {
        try {
            return this.rs.previous();
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public void beforeFirst() throws PgqlException {
        try {
            this.rs.beforeFirst();
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public void afterLast() throws PgqlException {
        try {
            this.rs.afterLast();
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public boolean first() throws PgqlException {
        try {
            return this.rs.first();
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public boolean last() throws PgqlException {
        try {
            return this.rs.last();
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public boolean absolute(long row) throws PgqlException {
        try {
            return this.rs.absolute((int)row);
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public boolean relative(long rows) throws PgqlException {
        try {
            return this.rs.relative((int)rows);
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Set<String> getVertexLabels(int elementIdx) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public Set<String> getVertexLabels(String elementName) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public LocalDate getDate(int elementIdx) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public LocalDate getDate(String elementName) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public LocalTime getTime(int elementIdx) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public LocalTime getTime(String elementName) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public LocalDateTime getTimestamp(int elementIdx) throws PgqlException {
        try {
            Timestamp ts = (Timestamp)this.getObject(elementIdx);
            if (ts == null) {
                return null;
            }
            return ts.toLocalDateTime();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public LocalDateTime getTimestamp(String elementName) throws PgqlException {
        try {
            Timestamp ts = (Timestamp)this.getObject(elementName);
            if (ts == null) {
                return null;
            }
            return ts.toLocalDateTime();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public OffsetTime getTimeWithTimezone(int elementIdx) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public OffsetTime getTimeWithTimezone(String elementName) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public OffsetDateTime getTimestampWithTimezone(int elementIdx) throws PgqlException {
        try {
            LocalDateTime ldt = this.getTimestamp(elementIdx);
            String tzOffsetStr = DbmsUtils.getTzOffsetStr(this.ctx.pgqlConn.getJdbcConnection());
            String tsTzStr = ldt.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + tzOffsetStr;
            return OffsetDateTime.parse(tsTzStr, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Date getLegacyDate(int elementIdx) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public Date getLegacyDate(String elementName) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public <T> List<T> getList(int elementIdx) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public <T> List<T> getList(String elementName) throws PgqlException {
        throw new PgqlException(FEATURE_NOT_IMPLEMENTED);
    }

    public Iterator<ResultAccess> iterator() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Returning PgqlResultSet Iterator");
        }
        if (this.iterator == null) {
            this.iterator = new PgqlResultSetIterator(this);
        } else {
            this.iterator.reset();
        }
        return this.iterator;
    }

    private class PgqlResultSetIterator
    implements Iterator<ResultAccess> {
        private final PgqlResultSetImpl rs;
        private boolean inNextPosition;
        private boolean hasNext;

        private PgqlResultSetIterator(PgqlResultSetImpl rs) {
            this.rs = rs;
            this.inNextPosition = false;
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            try {
                if (!this.inNextPosition) {
                    this.hasNext = this.rs.next();
                    this.inNextPosition = true;
                }
                return this.hasNext;
            }
            catch (PgqlException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public PgqlResultSet next() {
            try {
                if (!this.inNextPosition) {
                    this.rs.next();
                }
                this.inNextPosition = false;
                return this.rs;
            }
            catch (PgqlException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void reset() {
            try {
                this.rs.beforeFirst();
            }
            catch (PgqlException ex) {
                throw new PgqlToSqlException(ex.getMessage());
            }
            this.inNextPosition = false;
            this.hasNext = false;
        }
    }
}

