/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.util.List;
import oracle.pg.rdbms.pgql.PgqlColumnDescriptor;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTrans;
import oracle.pg.rdbms.pgql.PgqlSqlTrans;

public class PgqlSqlQueryTransImpl
implements PgqlSqlQueryTrans {
    private final PgqlColumnDescriptor[] returnTypes;
    private final String sqlTranslation;
    private final List<Object> sqlBvList;

    public PgqlSqlQueryTransImpl(PgqlColumnDescriptor[] returnTypes, StringBuffer sqlBuff, List<Object> sqlBvList) {
        this.returnTypes = returnTypes;
        this.sqlTranslation = sqlBuff.toString();
        this.sqlBvList = sqlBvList;
    }

    @Override
    public PgqlSqlTrans.TranslationType getTranslationType() {
        return PgqlSqlTrans.TranslationType.QUERY;
    }

    @Override
    public PgqlColumnDescriptor[] getReturnTypes() {
        return this.returnTypes;
    }

    @Override
    public String getSqlTranslation() {
        return this.sqlTranslation;
    }

    @Override
    public List<Object> getSqlBvList() {
        return this.sqlBvList;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("");
        buff.append("Return Columns: {");
        PgqlColumnDescriptor[] cols = this.getReturnTypes();
        if (cols != null) {
            for (int i = 0; i < cols.length; ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(i).append(":(").append(cols[i].toString()).append(")");
            }
        }
        buff.append("}\n");
        buff.append("SQL Translation:\n");
        buff.append(this.getSqlTranslation());
        buff.append("\nBind Values List:\n");
        buff.append(this.getSqlBvList());
        return buff.toString();
    }

    public boolean equals(Object o) {
        String sql;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PgqlSqlQueryTrans s = (PgqlSqlQueryTrans)o;
        PgqlColumnDescriptor[] c = s.getReturnTypes();
        if (c != null && this.returnTypes != null) {
            if (c.length != this.returnTypes.length) {
                return false;
            }
            for (int i = 0; i < c.length; ++i) {
                if (c[i].equals(this.returnTypes[i])) continue;
                return false;
            }
        } else {
            if (c != null && this.returnTypes == null) {
                return false;
            }
            if (c == null && this.returnTypes != null) {
                return false;
            }
        }
        if ((sql = s.getSqlTranslation()) != null && !sql.equals(this.sqlTranslation)) {
            return false;
        }
        if (this.sqlTranslation != null) {
            return false;
        }
        List<Object> bvList = s.getSqlBvList();
        if (bvList != null && !bvList.equals(this.sqlBvList)) {
            return false;
        }
        return this.sqlBvList == null;
    }

    public int hashCode() {
        int hc = 31;
        if (this.returnTypes != null) {
            hc = hc * 31 * this.returnTypes.hashCode();
        }
        if (this.sqlTranslation != null) {
            hc ^= 31 * this.sqlTranslation.hashCode();
        }
        if (this.sqlBvList != null) {
            hc ^= 31 * this.sqlBvList.hashCode();
        }
        return hc;
    }
}

