/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.BindValueInfo;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.ExprContext;
import oracle.pg.rdbms.pgql.ExprNavigator;
import oracle.pg.rdbms.pgql.ExprTransVisitor;
import oracle.pg.rdbms.pgql.ExprTranslation;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.ModifyVarInfo;
import oracle.pg.rdbms.pgql.PgqlColumnDescriptor;
import oracle.pg.rdbms.pgql.PgqlColumnDescriptorImpl;
import oracle.pg.rdbms.pgql.PgqlCreatePgTranslator;
import oracle.pg.rdbms.pgql.PgqlDropPgTranslator;
import oracle.pg.rdbms.pgql.PgqlSqlCreateTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlDropTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlModifyTrans;
import oracle.pg.rdbms.pgql.PgqlSqlModifyTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTrans;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlTrans;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.SqlQuery;
import oracle.pg.rdbms.pgql.TraversalStruct;
import oracle.pg.rdbms.pgql.ValuePair;
import oracle.pg.rdbms.pgql.pgnative.PgNativeQueryTranslator;
import oracle.pg.rdbms.pgql.pgview.PgViewModifyTrans;
import oracle.pg.rdbms.pgql.pgview.metadata.PgViewMetadataConnector;
import oracle.pg.rdbms.pgql.pgview.metadata.PgViewMetadataProvider;
import oracle.pg.rdbms.pgql.pgview.translation.ModifyTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.QueryTranslator;
import oracle.pgql.lang.Pgql;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.PgqlResult;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.DropPropertyGraph;
import oracle.pgql.lang.ir.Direction;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.PathFindingGoal;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.StatementType;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.modify.DeleteClause;
import oracle.pgql.lang.ir.modify.EdgeInsertion;
import oracle.pgql.lang.ir.modify.InsertClause;
import oracle.pgql.lang.ir.modify.Insertion;
import oracle.pgql.lang.ir.modify.Modification;
import oracle.pgql.lang.ir.modify.ModificationType;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.ir.modify.SetPropertyExpression;
import oracle.pgql.lang.ir.modify.Update;
import oracle.pgql.lang.ir.modify.UpdateClause;
import oracle.pgql.lang.ir.modify.VertexInsertion;
import oracle.pgql.lang.metadata.AbstractMetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgqlTranslator {
    private static Logger ms_log;
    private static Pgql pgql;
    protected static final int EDGE_POS = 0;
    protected static final int SRC_POS = 1;
    protected static final int DST_POS = 2;
    protected static final int NODE_POS = 3;
    protected static final int DEG_VID_POS = 4;
    protected static final String[] COLS;
    protected static final String V_COL = "V";
    protected static final String VT_COL = "VT";
    protected static final String VN_COL = "VN";
    protected static final String T_COL = "T";
    protected static final String K_COL = "K";
    protected static final String VERTEX_LBL_COL = "VL";
    protected static final String EDGE_LBL_COL = "EL";
    protected static final List<String> VERTEX_TABLE_NO_LABEL_COLS;
    protected static final List<String> VERTEX_TABLE_COLS;
    protected static final List<String> EDGE_TABLE_COLS;
    protected static final List<String> KEY_VALUE_COLS;
    protected static final String LABEL_PROP = "label";
    protected static final String IN_DEGREE = "INDG";
    protected static final String OUT_DEGREE = "OUTDG";
    private static final String GENERATED_KW = "<<generated>>";
    private static final String ANY_DIRECTED_ALIAS = "ANY_DIRECTED_TABLE";
    private static final String ANY_DIRECTED_KV_ALIAS = "ANY_DIRECTED_KV_TABLE";
    public static final String MATCH_TABLE_NAME = "ORA$PTT_MATCH_QUERY";
    private int queryBlockId;
    private TraversalStruct parentTStruct;
    private QueryContext ctx;
    private TraversalStruct tStruct;
    private Map<String, QueryExpression> exprAliasMap;
    private Map<String, QueryExpression> parentExprAliasMap;
    private Set<String> gbAliases;
    private List<List<ExpAsVar>> modSelectElemsList;
    private Map<String, ModifyVarInfo> modifyVarsMap;
    private List<OrderByElem> modOrderByElems;
    private QueryExpression modHaving;
    private GraphQuery qg;
    private GraphPattern pattern;
    private PgqlStatement stmt;
    private SqlQuery sqlQuery;
    private PgqlColumnDescriptor[] returnCols;
    private List<PgqlColumnDescriptor[]> modifyReturnColsList;
    private StringBuffer sqlBuff;
    private BindValueInfo bvInfo;
    private int firstColTypeFam;
    private static final String UNSUPPORTED_PATH_TYPE = "Unsupported expression type for path queries:";
    public static final String GRAPH_NOT_SET_ERROR = "Graph name is not set for this PgqlStatement. Use setGraph method in PgqlConnection or specify a graph name in the query";

    private PgqlTranslator(QueryContext ctx, TraversalStruct parentTStruct, Map<String, QueryExpression> parentExprAliasMap) {
        this.ctx = ctx;
        this.queryBlockId = this.ctx.getNextQbId();
        this.parentTStruct = parentTStruct;
        this.parentExprAliasMap = parentExprAliasMap;
        this.tStruct = new TraversalStruct();
        this.exprAliasMap = new HashMap<String, QueryExpression>();
        this.gbAliases = new HashSet<String>();
        this.modSelectElemsList = new ArrayList<List<ExpAsVar>>();
        this.modifyVarsMap = new HashMap<String, ModifyVarInfo>();
        this.modOrderByElems = new ArrayList<OrderByElem>();
        this.modHaving = null;
        this.qg = null;
        this.sqlQuery = new SqlQuery();
        this.returnCols = null;
        this.modifyReturnColsList = new ArrayList<PgqlColumnDescriptor[]>();
        this.sqlBuff = new StringBuffer("");
        this.firstColTypeFam = -1;
    }

    public static PgqlTranslator getPgqlTranslator(QueryContext ctx) {
        return new PgqlTranslator(ctx, null, new HashMap<String, QueryExpression>());
    }

    public static PgqlTranslator getPgqlTranslator(QueryContext ctx, TraversalStruct parentTStruct, Map<String, QueryExpression> parentExprAliasMap) {
        return new PgqlTranslator(ctx, parentTStruct, parentExprAliasMap);
    }

    public PgqlSqlQueryTrans translateQuery(String pgqlStr) throws PgqlException, PgqlToSqlException {
        return this.translateQuery(pgqlStr, null, BindValueInfo.getBindValueInfo());
    }

    public PgqlSqlQueryTrans translateQuery(String pgqlStr, BindValueInfo bvInfo) throws PgqlException, PgqlToSqlException {
        return this.translateQuery(pgqlStr, null, bvInfo);
    }

    PgqlSqlQueryTrans translateQuery(GraphQuery gq, BindValueInfo bvInfo, int[] returnTypeFam) throws PgqlException, PgqlToSqlException {
        PgqlSqlQueryTrans opst = this.translateQuery(null, gq, bvInfo);
        returnTypeFam[0] = this.firstColTypeFam;
        return opst;
    }

    private PgqlSqlQueryTrans translateQuery(String pgqlStr, GraphQuery gq, BindValueInfo bvInfo) throws PgqlException, PgqlToSqlException {
        return (PgqlSqlQueryTrans)this.translatePgql(pgqlStr, (PgqlStatement)gq, bvInfo, false);
    }

    public PgqlSqlTrans translatePgql(String pgqlStr, PgqlStatement stmt, BindValueInfo bvInfo) throws PgqlException, PgqlToSqlException {
        return this.translatePgql(pgqlStr, stmt, bvInfo, true);
    }

    private PgqlSqlQueryTrans buildPgqlSqlQueryTrans() {
        this.buildSQLString();
        if (this.queryBlockId == 0) {
            this.processBindVariables(0);
        }
        PgqlSqlQueryTransImpl sql = new PgqlSqlQueryTransImpl(this.returnCols, this.sqlBuff, this.bvInfo.getSqlBvList(0));
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\nPGQL-to-SQL Translation:\n" + ((Object)sql).toString());
        }
        return sql;
    }

    private PgqlSqlModifyTrans buildPgqlSqlModifyTrans() throws PgqlException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Generating Modify translations...");
        }
        List modifications = ((ModifyQuery)this.qg).getModifications();
        ArrayList<PgqlSqlModifyTrans.ModificationType> modifyTypes = new ArrayList<PgqlSqlModifyTrans.ModificationType>();
        ArrayList<Object[]> modifyTranslations = new ArrayList<Object[]>();
        String[] temporaryTableNames = new String[this.modSelectElemsList.size()];
        ArrayList<List<Object>> modifyBvLists = new ArrayList<List<Object>>();
        String[] matchTranslation = this.buildMatchTranslation();
        List<Object> matchBvList = this.bvInfo.getSqlBvList(0);
        int idx = 0;
        block9: for (Modification m : modifications) {
            switch (m.getModificationType()) {
                case UPDATE: {
                    modifyTypes.add(PgqlSqlModifyTrans.ModificationType.UPDATE);
                    modifyTranslations.add(this.buildSQLStringsForUpdate(idx));
                    modifyBvLists.add(this.bvInfo.getSqlBvList(idx + 1));
                    ++idx;
                    break;
                }
                case INSERT: {
                    InsertClause ic = (InsertClause)m;
                    for (Insertion insertion : ic.getInsertions()) {
                        boolean createTemporaryTable;
                        String variableName;
                        switch (insertion.getInsertionType()) {
                            case EDGE_INSERTION: {
                                variableName = ((EdgeInsertion)insertion).getEdge().getName();
                                createTemporaryTable = this.modifyVarsMap.get(variableName).isUsed();
                                modifyTypes.add(PgqlSqlModifyTrans.ModificationType.INSERT_EDGE);
                                modifyTranslations.add(new String[]{null, this.buildSQLStringForInsert(idx, true, matchTranslation != null && createTemporaryTable)});
                                modifyBvLists.add(this.bvInfo.getSqlBvList(idx + 1));
                                break;
                            }
                            case VERTEX_INSERTION: {
                                variableName = ((VertexInsertion)insertion).getVertex().getName();
                                createTemporaryTable = this.modifyVarsMap.get(variableName).isUsed();
                                modifyTypes.add(PgqlSqlModifyTrans.ModificationType.INSERT_VERTEX);
                                modifyTranslations.add(new String[]{this.buildSQLStringForInsert(idx, false, matchTranslation != null && createTemporaryTable), null});
                                modifyBvLists.add(this.bvInfo.getSqlBvList(idx + 1));
                                break;
                            }
                            default: {
                                throw new PgqlException("Unexpected insertion type" + insertion.getInsertionType());
                            }
                        }
                        if (createTemporaryTable) {
                            temporaryTableNames[idx] = PgqlUtils.getTemporaryTabName(this.ctx.graphName, variableName);
                        }
                        ++idx;
                    }
                    continue block9;
                }
                case DELETE: {
                    modifyTypes.add(PgqlSqlModifyTrans.ModificationType.DELETE);
                    modifyTranslations.add(this.buildSQLStringsForDelete(idx));
                    modifyBvLists.add(this.bvInfo.getSqlBvList(idx + 1));
                    ++idx;
                    break;
                }
                default: {
                    throw new PgqlToSqlException("Modify type not supported:" + m.getModificationType());
                }
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Finished generating Modify translations");
        }
        return new PgqlSqlModifyTransImpl(matchTranslation, matchBvList, modifyTypes, modifyTranslations, temporaryTableNames, modifyBvLists);
    }

    private PgqlSqlQueryTrans buildPgViewSqlQueryTrans() {
        if (this.ctx.useIso) {
            throw new PgqlToSqlException("Isomorphism is not supported for PG views");
        }
        SelectQuery select = (SelectQuery)this.stmt;
        PgViewMetadataConnector metadataConnector = new PgViewMetadataConnector(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.schemaName, this.ctx.graphName);
        String sqlQuery = QueryTranslator.translateQuery((GraphQuery)select, metadataConnector).prettyPrint();
        this.sqlBuff = new StringBuffer(sqlQuery);
        if (this.queryBlockId == 0) {
            this.processBindVariables(0);
        }
        return new PgqlSqlQueryTransImpl(null, this.sqlBuff, this.bvInfo.getSqlBvList(0));
    }

    private PgViewModifyTrans buildPgViewSqlModifyTrans() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Generating Modify translations...");
        }
        if (this.ctx.useIso) {
            throw new PgqlToSqlException("Isomorphism is not supported for PG views");
        }
        PgViewMetadataConnector metadataConnector = new PgViewMetadataConnector(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.schemaName, this.ctx.graphName);
        return ModifyTranslator.translateModify((ModifyQuery)this.qg, metadataConnector, this.bvInfo);
    }

    private PgqlSqlQueryTrans buildPgNativeSqlQueryTrans() {
        String sqlQuery = PgNativeQueryTranslator.translateQuery((GraphQuery)((SelectQuery)this.stmt));
        this.sqlBuff = new StringBuffer(sqlQuery);
        return new PgqlSqlQueryTransImpl(null, this.sqlBuff, this.bvInfo.getSqlBvList(0));
    }

    public PgqlSqlTrans translatePgql(String pgqlStr, PgqlStatement stmt, BindValueInfo bvInfo, boolean forExecute) throws PgqlException, PgqlToSqlException {
        this.generateTranslation(pgqlStr, stmt, bvInfo, forExecute);
        switch (this.stmt.getStatementType()) {
            case SELECT: {
                if (this.ctx.graphType == GraphType.PG_SCHEMA) {
                    return this.buildPgqlSqlQueryTrans();
                }
                if (this.ctx.graphType != GraphType.PG_VIEWS) break;
                return this.buildPgViewSqlQueryTrans();
            }
            case GRAPH_MODIFY: {
                if (this.ctx.graphType == GraphType.PG_VIEWS) {
                    return this.buildPgViewSqlModifyTrans();
                }
                if (this.ctx.graphType != GraphType.PG_SCHEMA) break;
                return this.buildPgqlSqlModifyTrans();
            }
            case CREATE_PROPERTY_GRAPH: {
                CreatePropertyGraph cpg = (CreatePropertyGraph)this.stmt;
                if (PgqlTranslator.getCreateType(cpg) == GraphType.PG_VIEWS) {
                    return new PgqlSqlCreateTransImpl(cpg.getGraphName().getSchemaName(), cpg.getGraphName().getName(), new Object[]{cpg});
                }
                return PgqlCreatePgTranslator.translateCreatePropertyGraph((CreatePropertyGraph)this.stmt, this.ctx);
            }
            case DROP_PROPERTY_GRAPH: {
                if (this.ctx.graphType == GraphType.PG_SCHEMA) {
                    return PgqlDropPgTranslator.translateDropPropertyGraph((DropPropertyGraph)this.stmt, this.ctx);
                }
                DropPropertyGraph dpg = (DropPropertyGraph)this.stmt;
                return new PgqlSqlDropTransImpl(dpg.getGraphName().getSchemaName(), dpg.getGraphName().getName(), null);
            }
        }
        throw new PgqlToSqlException("Unsupported statement type:" + this.stmt.getStatementType());
    }

    private void generateTranslation(String pgqlStr, PgqlStatement stmt, BindValueInfo bvInfo, boolean forExecute) throws PgqlException, PgqlToSqlException {
        if (pgqlStr != null && stmt != null) {
            throw new PgqlToSqlException("Invalid input to translateQuery(): both pgqlStr and stmt are non-null");
        }
        this.clearDataStructures();
        this.parseStatement(pgqlStr, stmt);
        if (!forExecute && this.stmt.getStatementType() != StatementType.SELECT) {
            throw new PgqlToSqlException("Statement not valid for executeQuery(), use execute() instead");
        }
        if (this.stmt.getStatementType() == StatementType.GRAPH_MODIFY && !PgqlUtils.DbFeature.INSERT_UPDATE_DELETE.isSupported(this.ctx.dbVersion, this.ctx.opgVersion)) {
            throw new PgqlToSqlException("INSERT/UPDATE/DELETE is only available for 18C and later versions");
        }
        switch (this.stmt.getStatementType()) {
            case SELECT: 
            case GRAPH_MODIFY: {
                this.qg = (GraphQuery)this.stmt;
                this.pattern = this.qg.getGraphPattern();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nGraph Query:\n" + this.qg.toString());
                }
                this.updateGraphInfo(this.qg);
                this.setBvInfo(bvInfo);
                if (this.ctx.graphType != GraphType.PG_SCHEMA) break;
                this.preprocessExpressions();
                this.populateDataStructures();
                this.generateSQL(this.qg.getQueryType() == QueryType.MODIFY, this.qg.getGraphPattern() != null && this.modSelectElemsList.size() > 1);
                break;
            }
            case CREATE_PROPERTY_GRAPH: {
                CreatePropertyGraph cpg = (CreatePropertyGraph)this.stmt;
                this.updateGraphInfo(cpg.getGraphName(), PgqlTranslator.getCreateType(cpg));
                break;
            }
            case DROP_PROPERTY_GRAPH: {
                this.updateGraphInfo(((DropPropertyGraph)this.stmt).getGraphName(), null);
            }
        }
    }

    private void updateGraphInfo(GraphQuery graphQuery) {
        SchemaQualifiedName graphName = graphQuery.getGraphName();
        if (graphQuery.getStatementType() == StatementType.GRAPH_MODIFY) {
            for (Modification m : ((ModifyQuery)graphQuery).getModifications()) {
                SchemaQualifiedName insertGraphName;
                if (m.getModificationType() != ModificationType.INSERT || (insertGraphName = ((InsertClause)m).getGraphName()) == null) continue;
                if (graphQuery.getGraphPattern() != null && !insertGraphName.equals((Object)graphName)) {
                    throw new PgqlToSqlException("Graph specified in INTO clause and MATCH ON clause should be the same");
                }
                graphName = insertGraphName;
            }
        }
        this.updateGraphInfo(graphName, null);
    }

    private void updateGraphInfo(SchemaQualifiedName sqGraphName, GraphType createType) {
        String graphName;
        String schemaName = sqGraphName == null || sqGraphName.getSchemaName() == null ? this.ctx.pgqlConn.getSchema() : sqGraphName.getSchemaName();
        if (sqGraphName == null || sqGraphName.getName() == null) {
            if (this.ctx.pgqlConn.getGraph() == null) {
                throw new PgqlToSqlException(GRAPH_NOT_SET_ERROR);
            }
            graphName = this.ctx.pgqlConn.getGraph();
        } else {
            graphName = sqGraphName.getName();
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Updating graph info:\n    schemaName=[" + schemaName + "]\n     graphName=[" + graphName + "]\n");
        }
        this.ctx.updateGraphInfo(schemaName, graphName, createType);
    }

    private void clearDataStructures() {
        this.tStruct.clearStruct();
        this.exprAliasMap.clear();
        this.gbAliases.clear();
        this.modSelectElemsList.clear();
        this.modifyVarsMap.clear();
        this.modOrderByElems.clear();
        this.modHaving = null;
        this.stmt = null;
        this.qg = null;
        this.pattern = null;
        this.sqlQuery.clear();
        this.returnCols = null;
        this.modifyReturnColsList = new ArrayList<PgqlColumnDescriptor[]>();
        this.sqlBuff = new StringBuffer("");
        this.bvInfo = null;
        this.firstColTypeFam = -1;
    }

    private void parseStatement(String pgqlStr, PgqlStatement stmt) throws PgqlException, PgqlToSqlException {
        if (pgqlStr != null && stmt != null) {
            throw new PgqlToSqlException("Invalid input to parseStatement(): both pgqlStr and stmt are non-null");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\nPGQL Query String:\n" + pgqlStr);
        }
        if (pgqlStr != null) {
            PgqlResult res;
            String errorMsgs;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\nObtaining PgqlStatement from PGQL string");
            }
            if ((errorMsgs = (res = pgql.parse(pgqlStr, (AbstractMetadataProvider)new PgViewMetadataProvider(this.ctx.pgqlConn))).getErrorMessages()) != null && errorMsgs.length() > 0 && !res.isQueryValid()) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nErrors:\n" + errorMsgs);
                }
                throw new PgqlToSqlException(errorMsgs);
            }
            this.stmt = res.getPgqlStatement();
        } else {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\nUsing passed-in Statement");
            }
            this.stmt = stmt;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\nPGQL PgqlStatement:\n" + this.stmt);
        }
    }

    private void setBvInfo(BindValueInfo bvInfo) {
        this.bvInfo = bvInfo;
    }

    private void updateModifyVarsInfo(String variableName, int modifyIdx) {
        if (this.modifyVarsMap.containsKey(variableName)) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Modify variable " + variableName + " is used in MODIFY " + modifyIdx);
            }
            this.modifyVarsMap.get(variableName).addPosition(modifyIdx);
        }
    }

    private void updateModifyVarsInfo(QueryExpression qe, int modifyIdx) {
        HashSet<String> varSet = new HashSet<String>();
        HashSet<ValuePair> varPropSet = new HashSet<ValuePair>();
        this.extractVarsAndProps(qe, varSet, varPropSet);
        for (String var : varSet) {
            this.updateModifyVarsInfo(var, modifyIdx);
        }
        for (ValuePair vp : varPropSet) {
            this.updateModifyVarsInfo(vp.v1, modifyIdx);
        }
    }

    private void updateModifyDataStructures(List<SetPropertyExpression> properties, List<ExpAsVar> selectElems, boolean addVariable, int modifyIdx) {
        for (SetPropertyExpression pu : properties) {
            QueryExpression.PropertyAccess pa = pu.getPropertyAccess();
            QueryExpression qe = pu.getValueExpression();
            this.updateModifyVarsInfo(qe, modifyIdx);
            String varAndPropName = pa.getVariable().getName() + "$" + pa.getPropertyName();
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Adding property: " + varAndPropName);
                ms_log.debug("Adding Expression: " + qe.toString());
            }
            if (addVariable) {
                selectElems.add(new ExpAsVar((QueryExpression)new QueryExpression.VarRef(pa.getVariable()), varAndPropName, true));
            }
            this.transformAndAddSelectElem(new ExpAsVar(qe, varAndPropName, true), selectElems);
        }
    }

    private void transformAndAddSelectElem(ExpAsVar eav, List<ExpAsVar> selectElems) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Current Expression: " + eav.getExp().toString());
        }
        boolean[] transformed = new boolean[]{false};
        QueryExpression tExp = null;
        if (this.gbAliases.size() > 0) {
            tExp = this.addRequiredAggregates(eav.getExp(), transformed);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Transformed Expression: " + tExp.toString());
            }
        }
        if (transformed[0]) {
            selectElems.add(new ExpAsVar(tExp, eav.getName(), eav.isAnonymous()));
        } else {
            selectElems.add(eav);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void preprocessExpressions() throws PgqlToSqlException {
        if (this.qg.getGroupBy() != null) {
            for (ExpAsVar eav : this.qg.getGroupBy().getElements()) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Adding gbAlias: " + eav.getName());
                }
                this.gbAliases.add(eav.getName());
            }
        }
        if (this.qg.getQueryType() == QueryType.SELECT) {
            for (ExpAsVar eav : ((SelectQuery)this.qg).getProjection().getElements()) {
                QueryExpression.VarRef vr;
                if (eav.getExp().getExpType() != QueryExpression.ExpressionType.VARREF || !this.gbAliases.contains((vr = (QueryExpression.VarRef)eav.getExp()).getVariable().getName())) continue;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Adding gbAlias: " + eav.getName());
                }
                this.gbAliases.add(eav.getName());
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Adding aggregates to SELECT expressions");
        }
        boolean[] transformed = new boolean[1];
        QueryExpression tExp = null;
        switch (this.qg.getQueryType()) {
            case SELECT: {
                ArrayList<Object> modSelectElems = new ArrayList<ExpAsVar>();
                this.modSelectElemsList.add(modSelectElems);
                for (ExpAsVar expAsVar : ((SelectQuery)this.qg).getProjection().getElements()) {
                    this.transformAndAddSelectElem(expAsVar, modSelectElems);
                }
                break;
            }
            case MODIFY: {
                ArrayList<Object> modSelectElems;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Adding MODIFY expressions");
                }
                List modifications = ((ModifyQuery)this.qg).getModifications();
                boolean bl = false;
                block16: for (Modification m : modifications) {
                    switch (m.getModificationType()) {
                        case UPDATE: {
                            void var5_7;
                            modSelectElems = new ArrayList();
                            this.modSelectElemsList.add(modSelectElems);
                            UpdateClause uc = (UpdateClause)m;
                            for (Update update : uc.getUpdates()) {
                                this.updateModifyDataStructures(update.getSetPropertyExpressions(), modSelectElems, true, (int)var5_7);
                                this.updateModifyVarsInfo(update.getElement().getVariable().getName(), (int)var5_7);
                            }
                            ++var5_7;
                            break;
                        }
                        case INSERT: {
                            void var5_7;
                            Update update;
                            InsertClause ic = (InsertClause)m;
                            update = ic.getInsertions().iterator();
                            while (update.hasNext()) {
                                Insertion insertion = (Insertion)update.next();
                                modSelectElems = new ArrayList();
                                this.modSelectElemsList.add(modSelectElems);
                                switch (insertion.getInsertionType()) {
                                    case EDGE_INSERTION: {
                                        EdgeInsertion ei = (EdgeInsertion)insertion;
                                        String edgeName = ei.getEdge().getName();
                                        QueryVertex src = ei.getEdge().getSrc();
                                        String srcName = src.getName();
                                        QueryVertex dst = ei.getEdge().getDst();
                                        String dstName = dst.getName();
                                        if (ms_log.isDebugEnabled()) {
                                            ms_log.debug("Adding edge " + edgeName + " from " + srcName + " to " + dstName);
                                        }
                                        this.modifyVarsMap.put(edgeName, new ModifyVarInfo(0));
                                        modSelectElems.add(new ExpAsVar((QueryExpression)new QueryExpression.VarRef((QueryVariable)src), srcName, true));
                                        this.updateModifyVarsInfo(srcName, (int)var5_7);
                                        if (!srcName.equals(dstName)) {
                                            modSelectElems.add(new ExpAsVar((QueryExpression)new QueryExpression.VarRef((QueryVariable)dst), dstName, true));
                                            this.updateModifyVarsInfo(dstName, (int)var5_7);
                                        }
                                        if (ei.getLabels().size() != 1) {
                                            throw new PgqlToSqlException("Edges must have exactly one label");
                                        }
                                        modSelectElems.add(new ExpAsVar((QueryExpression)ei.getLabels().iterator().next(), edgeName, true));
                                        this.updateModifyDataStructures(ei.getProperties(), modSelectElems, false, (int)var5_7);
                                        ++var5_7;
                                        break;
                                    }
                                    case VERTEX_INSERTION: {
                                        VertexInsertion vi = (VertexInsertion)insertion;
                                        String vertexName = vi.getVertex().getName();
                                        if (ms_log.isDebugEnabled()) {
                                            ms_log.debug("Adding vertex " + vertexName);
                                        }
                                        if (vi.getLabels().size() != 1) {
                                            throw new PgqlToSqlException("Vertices must have exactly one label");
                                        }
                                        this.modifyVarsMap.put(vertexName, new ModifyVarInfo(3));
                                        modSelectElems.add(new ExpAsVar((QueryExpression)vi.getLabels().iterator().next(), vertexName, true));
                                        this.updateModifyDataStructures(vi.getProperties(), modSelectElems, false, (int)var5_7);
                                        ++var5_7;
                                    }
                                }
                            }
                            continue block16;
                        }
                        case DELETE: {
                            void var5_7;
                            modSelectElems = new ArrayList();
                            this.modSelectElemsList.add(modSelectElems);
                            DeleteClause d = (DeleteClause)m;
                            for (QueryExpression.VarRef vr : d.getDeletions()) {
                                if (ms_log.isDebugEnabled()) {
                                    ms_log.debug("Adding element: " + vr.toString());
                                }
                                String varName = vr.getVariable().getName();
                                modSelectElems.add(new ExpAsVar((QueryExpression)vr, varName, true));
                                this.updateModifyVarsInfo(varName, (int)var5_7);
                            }
                            ++var5_7;
                            break;
                        }
                        default: {
                            throw new PgqlToSqlException("Modify type not supported:" + m.getModificationType());
                        }
                    }
                }
                break;
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Done adding aggregates to SELECT expressions");
            ms_log.debug("Adding aggregates to ORDER BY expressions");
        }
        for (OrderByElem orderByElem : this.qg.getOrderBy().getElements()) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Current Expression: " + orderByElem.getExp().toString());
            }
            transformed[0] = false;
            if (this.gbAliases.size() > 0) {
                tExp = this.addRequiredAggregates(orderByElem.getExp(), transformed);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Transformed Expression: " + tExp.toString());
                }
            }
            if (transformed[0]) {
                this.modOrderByElems.add(new OrderByElem(tExp, orderByElem.isAscending()));
                continue;
            }
            this.modOrderByElems.add(orderByElem);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Done adding aggregates to ORDER BY expressions");
            ms_log.debug("Adding aggregates to HAVING clause");
        }
        if (this.qg.getHaving() != null) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Current Expression: " + this.qg.getHaving().toString());
            }
            transformed[0] = false;
            tExp = this.addRequiredAggregates(this.qg.getHaving(), transformed);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Transformed Expression: " + tExp.toString());
            }
            this.modHaving = transformed[0] ? tExp : this.qg.getHaving();
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Done adding aggregates to HAVING clause");
        }
        if (this.qg.getGroupBy() != null) {
            for (ExpAsVar expAsVar : this.qg.getGroupBy().getElements()) {
                if (this.exprAliasMap.containsKey(expAsVar.getName())) continue;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Adding to exprAliasMap: [" + expAsVar.getName() + "]->[" + expAsVar.getExp() + "]");
                }
                this.exprAliasMap.put(expAsVar.getName(), expAsVar.getExp());
            }
        }
        for (List list : this.modSelectElemsList) {
            for (ExpAsVar eav : list) {
                if (this.exprAliasMap.containsKey(eav.getName())) continue;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Adding to exprAliasMap: [" + eav.getName() + "]->[" + eav.getExp() + "]");
                }
                this.exprAliasMap.put(eav.getName(), eav.getExp());
            }
        }
        if (this.parentExprAliasMap != null) {
            for (String string : this.parentExprAliasMap.keySet()) {
                if (this.exprAliasMap.containsKey(string)) continue;
                QueryExpression qe = this.parentExprAliasMap.get(string);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Adding parent alias to subquery exprAliasMap: [" + string + "]->[" + qe + "]");
                }
                this.exprAliasMap.put(string, qe);
            }
        }
    }

    private void populateDataStructures() throws PgqlToSqlException {
        QueryExpression offsetExp;
        QueryExpression exp;
        HashSet<QueryExpression> filterConstraints;
        HashSet<QueryVertex> nodes;
        HashSet<VertexPairConnection> connections;
        ArrayList<QueryExpression> constraints = new ArrayList<QueryExpression>();
        if (this.pattern != null) {
            connections = this.pattern.getConnections();
            nodes = this.pattern.getVertices();
            filterConstraints = this.pattern.getConstraints();
        } else {
            connections = new HashSet<VertexPairConnection>();
            nodes = new HashSet<QueryVertex>();
            filterConstraints = new HashSet<QueryExpression>();
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Extracting expressions ...");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... for projections");
        }
        for (List<ExpAsVar> modSelectElems : this.modSelectElemsList) {
            for (ExpAsVar eav : modSelectElems) {
                QueryExpression exp2 = eav.getExp();
                constraints.add(exp2);
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... for filters");
        }
        for (QueryExpression exp3 : filterConstraints) {
            this.extractVarIDConstant(exp3, this.tStruct);
            constraints.add(exp3);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... for group by");
        }
        if (this.qg.getGroupBy() != null) {
            for (ExpAsVar eav : this.qg.getGroupBy().getElements()) {
                exp = eav.getExp();
                constraints.add(exp);
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... for order by");
        }
        for (OrderByElem obe : this.modOrderByElems) {
            exp = obe.getExp();
            constraints.add(exp);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... for having");
        }
        if (this.modHaving != null) {
            constraints.add(this.modHaving);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... done extracting expressions");
        }
        String limit = "-1";
        String offset = "-1";
        QueryExpression limitExp = this.qg.getLimit();
        if (limitExp != null) {
            if (limitExp.getExpType() == QueryExpression.ExpressionType.INTEGER) {
                limit = Long.toString((Long)((QueryExpression.Constant.ConstInteger)limitExp).getValue());
            } else if (limitExp.getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE) {
                limit = BindValueInfo.getBvEncoding((QueryExpression.BindVariable)limitExp);
            } else {
                throw new PgqlToSqlException("Unexpected expression type for LIMIT");
            }
        }
        if ((offsetExp = this.qg.getOffset()) != null) {
            if (offsetExp.getExpType() == QueryExpression.ExpressionType.INTEGER) {
                offset = Long.toString((Long)((QueryExpression.Constant.ConstInteger)offsetExp).getValue());
            } else if (offsetExp.getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE) {
                offset = BindValueInfo.getBvEncoding((QueryExpression.BindVariable)offsetExp);
            } else {
                throw new PgqlToSqlException("Unexpected expression type for OFFSET");
            }
        }
        this.sqlQuery.setLimit(limit);
        this.sqlQuery.setOffset(offset);
        if (this.parentTStruct != null) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("accounting for parent references ...");
            }
            this.addNodesEdgesForParentRefs(connections, nodes, constraints);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("... done accounting for parent references");
            }
        }
        this.populateTraversalStructures(connections, nodes, this.modifyVarsMap, constraints, filterConstraints, this.tStruct);
    }

    private void extractVarIDConstant(QueryExpression qe, TraversalStruct ts) {
        String var = null;
        String constant = null;
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Extracting ID constants from " + qe.toString());
        }
        if (qe.getExpType() == QueryExpression.ExpressionType.EQUAL) {
            QueryExpression.BinaryExpression be = (QueryExpression.BinaryExpression)qe;
            QueryExpression child1 = be.getExp1();
            QueryExpression child2 = be.getExp2();
            if (PgqlTranslator.isIdFunction(child1) && child2.getExpType() == QueryExpression.ExpressionType.INTEGER) {
                var = ((QueryExpression.VarRef)((QueryExpression.FunctionCall)child1).getArgs().get(0)).getVariable().getName();
                constant = Long.toString((Long)((QueryExpression.Constant.ConstInteger)child2).getValue());
            } else if (PgqlTranslator.isIdFunction(child1) && child2.getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE) {
                var = ((QueryExpression.VarRef)((QueryExpression.FunctionCall)child1).getArgs().get(0)).getVariable().getName();
                constant = BindValueInfo.getBvEncoding((QueryExpression.BindVariable)child2);
            } else if (PgqlTranslator.isIdFunction(child2) && child1.getExpType() == QueryExpression.ExpressionType.INTEGER) {
                var = ((QueryExpression.VarRef)((QueryExpression.FunctionCall)child2).getArgs().get(0)).getVariable().getName();
                constant = Long.toString((Long)((QueryExpression.Constant.ConstInteger)child1).getValue());
            } else if (PgqlTranslator.isIdFunction(child2) && child1.getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE) {
                var = ((QueryExpression.VarRef)((QueryExpression.FunctionCall)child2).getArgs().get(0)).getVariable().getName();
                constant = BindValueInfo.getBvEncoding((QueryExpression.BindVariable)child1);
            }
        }
        if (var != null) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Adding to varIdMap:[" + var + "]->[" + constant + "]");
            }
            ts.putVarId(var, constant);
        }
    }

    private boolean filtersVar(String varName, QueryExpression qe) throws PgqlToSqlException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\tChecking filtersVar varName=[" + varName + "] qe=[" + qe.toString() + "] ...");
        }
        boolean filters = false;
        HashSet<String> vars = new HashSet<String>();
        HashSet<ValuePair> varProps = new HashSet<ValuePair>();
        this.extractVarsAndProps(qe, vars, varProps);
        for (String var : vars) {
            if (var.equals(varName)) {
                filters = true;
                continue;
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\t... returning false");
            }
            return false;
        }
        for (ValuePair vp : varProps) {
            if (vp.v1.equals(varName)) {
                filters = true;
                continue;
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\t... returning false");
            }
            return false;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\t... returning " + filters);
        }
        return filters;
    }

    private List<QueryExpression> getFiltersForVar(String varName, Set<QueryExpression> qeSet) throws PgqlToSqlException {
        ArrayList<QueryExpression> varExprs = new ArrayList<QueryExpression>();
        if (qeSet != null) {
            for (QueryExpression qe : qeSet) {
                if (!this.filtersVar(varName, qe)) continue;
                varExprs.add(qe);
            }
        }
        return varExprs;
    }

    private int updateTraversalStructForVariable(String variable, int aliasCntr, boolean isModifyVar, int varPos, TraversalStruct ts, Map<String, ModifyVarInfo> modifyVarsMap) {
        int copyAliasCntr = aliasCntr;
        if (!ts.containsEdgeJoinVar(variable)) {
            String alias = Integer.toString(copyAliasCntr);
            String tableName = "";
            if (isModifyVar) {
                String idCol = varPos == 3 ? "VID" : "EID";
                tableName = "(SELECT DISTINCT PROP_ID, " + idCol + " FROM " + PgqlUtils.getTemporaryTabName(this.ctx.graphName, variable) + ")";
                ts.putAliasModifyList(alias, modifyVarsMap.get(variable).getPositions());
            } else {
                tableName = this.ctx.vtTab;
            }
            ts.putTableNameForId(alias, new String[]{tableName, null});
            ArrayList<int[]> joinList = new ArrayList<int[]>();
            joinList.add(new int[]{copyAliasCntr++, varPos});
            ts.putEdgeJoin(variable, joinList);
        }
        return copyAliasCntr;
    }

    private void addTraversalStructProperty(TraversalStruct ts, int alias, String tab, ValuePair vp, List<int[]> joins, int pos) {
        String propToAdd = vp.v2;
        if (propToAdd.equals(LABEL_PROP)) {
            propToAdd = null;
        }
        ts.putTableNameForId(Integer.toString(alias), new String[]{tab, propToAdd});
        joins.add(new int[]{alias, pos});
        ts.putPropAlias(vp, this.getAliasPfx() + Integer.toString(alias));
    }

    private void populateTraversalStructures(Set<VertexPairConnection> connections, Set<QueryVertex> nodes, List<QueryExpression> constraints, Set<QueryExpression> filterConstraints, TraversalStruct ts) throws PgqlToSqlException {
        this.populateTraversalStructures(connections, nodes, new HashMap<String, ModifyVarInfo>(), constraints, filterConstraints, ts);
    }

    /*
     * WARNING - void declaration
     */
    private void populateTraversalStructures(Set<VertexPairConnection> connections, Set<QueryVertex> nodes, Map<String, ModifyVarInfo> modifyVarsMap, List<QueryExpression> constraints, Set<QueryExpression> filterConstraints, TraversalStruct ts) throws PgqlToSqlException {
        int aliasCntr = 0;
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Processing connections ...");
        }
        for (VertexPairConnection qc : connections) {
            void var12_18;
            void var12_26;
            void var12_23;
            Object connTable;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Connection Type: " + qc.getClass().toString());
            }
            String string = Integer.toString(aliasCntr);
            if (qc instanceof QueryPath) {
                QueryPath queryPath;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Found Query Path");
                }
                if ((queryPath = (QueryPath)qc).getPathFindingGoal() != PathFindingGoal.REACHES) {
                    throw new PgqlToSqlException("Unsupported query path: " + queryPath.getPathFindingGoal());
                }
                String srcVarName = queryPath.getSrc().getName();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Getting filters for [" + srcVarName + "]");
                }
                List<QueryExpression> srcFilters = this.getFiltersForVar(srcVarName, filterConstraints);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\tExtracted Filters:");
                    for (QueryExpression e : srcFilters) {
                        ms_log.debug("\t\t" + e.toString());
                    }
                }
                String dstVarName = queryPath.getDst().getName();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Getting filters for [" + dstVarName + "]");
                }
                List<QueryExpression> dstFilters = this.getFiltersForVar(dstVarName, filterConstraints);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\tExtracted Filters:");
                    for (QueryExpression e : dstFilters) {
                        ms_log.debug("\t\t" + e.toString());
                    }
                }
                PathTranslator pt = new PathTranslator(queryPath, ts.getVarId(queryPath.getSrc().getName()), ts.getVarId(queryPath.getDst().getName()), srcFilters, dstFilters);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Translating Query Path ...");
                }
                connTable = pt.translatePathQuery();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("... done Translating Query Path");
                }
            } else {
                connTable = this.ctx.gtTab;
                if (!((QueryEdge)qc).isDirected()) {
                    ts.addAnyDirectedAlias(string);
                }
            }
            ts.putTableNameForId(string, new String[]{connTable, null});
            List<int[]> list = ts.getEdgeJoin(qc.getSrc().getName());
            if (list == null) {
                ArrayList arrayList = new ArrayList();
            }
            var12_23.add(new int[]{aliasCntr, 1});
            ts.putEdgeJoin(qc.getSrc().getName(), (List<int[]>)var12_23);
            List<int[]> list2 = ts.getEdgeJoin(qc.getName());
            if (list2 == null) {
                ArrayList arrayList = new ArrayList();
            }
            var12_26.add(new int[]{aliasCntr, 0});
            ts.putEdgeJoin(qc.getName(), (List<int[]>)var12_26);
            List<int[]> list3 = ts.getEdgeJoin(qc.getDst().getName());
            if (list3 == null) {
                ArrayList arrayList = new ArrayList();
            }
            var12_18.add(new int[]{aliasCntr++, 2});
            ts.putEdgeJoin(qc.getDst().getName(), (List<int[]>)var12_18);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... done processing connections");
            ms_log.debug("Processing nodes ...");
        }
        for (QueryVertex qn : nodes) {
            aliasCntr = this.updateTraversalStructForVariable(qn.getName(), aliasCntr, false, 3, ts, modifyVarsMap);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... done processing nodes");
            ms_log.debug("Processing variables projected in modify ...");
        }
        for (String var : modifyVarsMap.keySet()) {
            aliasCntr = this.updateTraversalStructForVariable(var, aliasCntr, true, modifyVarsMap.get(var).getType(), ts, modifyVarsMap);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... done processing variables projected in modify");
        }
        HashSet<ValuePair> varPropSet = new HashSet<ValuePair>();
        HashSet<String> varSet = new HashSet<String>();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Extracting vars and props ...");
        }
        for (QueryExpression queryExpression : constraints) {
            this.extractVarsAndProps(queryExpression, varSet, varPropSet);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... done extracting vars and props");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Processing var.property references ...");
        }
        for (ValuePair valuePair : varPropSet) {
            void var12_32;
            Set<String> set = ts.getVarProps(valuePair.v1);
            if (set == null) {
                HashSet hashSet = new HashSet();
            }
            var12_32.add(valuePair.v2);
            ts.putVarProp(valuePair.v1, (Set<String>)var12_32);
        }
        Set<Map.Entry<String, Set<String>>> vpSet = ts.getAllVarProps();
        for (Map.Entry<String, Set<String>> entry : vpSet) {
            String var = entry.getKey();
            List<int[]> joins = ts.getEdgeJoin(var);
            if (joins == null) continue;
            boolean isEdge = false;
            int pos = joins.get(0)[1];
            if (pos == 0) {
                isEdge = true;
            }
            Set<String> props = entry.getValue();
            for (String p : props) {
                ValuePair vp = new ValuePair(var, p);
                boolean handledProp = false;
                for (int[] join : joins) {
                    int alias = join[0];
                    String[] idTab = ts.getTableNameForId(Integer.toString(alias));
                    if (p.equals(IN_DEGREE) || p.equals(OUT_DEGREE)) {
                        this.addTraversalStructProperty(ts, aliasCntr, this.ctx.gtTab, vp, joins, 4);
                        ++aliasCntr;
                        handledProp = true;
                        break;
                    }
                    if (p.equals(LABEL_PROP) && (isEdge || idTab[0].equals(this.ctx.vtTab))) {
                        ts.putPropAlias(vp, this.getAliasPfx() + Integer.toString(alias));
                        handledProp = true;
                        break;
                    }
                    if (idTab[1] == null && isEdge && idTab[0].equals(this.ctx.gtTab)) {
                        idTab[1] = p;
                        idTab[0] = this.ctx.geTab;
                        ts.putPropAlias(vp, this.getAliasPfx() + Integer.toString(alias));
                        handledProp = true;
                        break;
                    }
                    if (idTab[1] != null || isEdge || !idTab[0].equals(this.ctx.vtTab)) continue;
                    idTab[1] = p;
                    ts.putPropAlias(vp, this.getAliasPfx() + Integer.toString(alias));
                    handledProp = true;
                    break;
                }
                if (handledProp) continue;
                pos = 3;
                String tab = this.ctx.vtTab;
                if (isEdge) {
                    pos = 0;
                    tab = this.ctx.geTab;
                }
                if (modifyVarsMap.containsKey(var)) {
                    ts.putAliasModifyList(Integer.toString(aliasCntr), modifyVarsMap.get(var).getPositions());
                }
                this.addTraversalStructProperty(ts, aliasCntr, tab, vp, joins, pos);
                ++aliasCntr;
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... done processing var.property references");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Populating variable aliases ...");
        }
        Set<Map.Entry<String, List<int[]>>> set = ts.getAllEdgeJoins();
        for (Map.Entry<String, List<int[]>> e : set) {
            String var = e.getKey();
            List<int[]> val = e.getValue();
            int[] i = val.get(0);
            for (int j = 1; i[1] == 4 && j < val.size(); ++j) {
                i = val.get(j);
            }
            ts.putVarAlias(var, new String[]{this.getAliasPfx() + Integer.toString(i[0]), COLS[i[1]]});
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... done populating variable aliases");
            ms_log.debug(ts.toString());
        }
    }

    private void generateHint(TraversalStruct ts) {
        String hint;
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Generating hint...");
        }
        if (this.ctx.allEdgeHash) {
            hint = "USE_HASH" + this.getAliasListString(ts.getEdgeAliases(this.ctx.vtTab));
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Adding " + hint);
            }
            this.sqlQuery.addHintElem(hint);
        }
        if (this.ctx.allVertexHash) {
            hint = "USE_HASH" + this.getAliasListString(ts.getVertexAliases(this.ctx.vtTab));
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Adding " + hint);
            }
            this.sqlQuery.addHintElem(hint);
        }
        if (this.ctx.allEdgeNL) {
            hint = "USE_NL" + this.getAliasListString(ts.getEdgeAliases(this.ctx.vtTab));
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Adding " + hint);
            }
            this.sqlQuery.addHintElem(hint);
        }
        if (this.ctx.allVertexNL) {
            hint = "USE_NL" + this.getAliasListString(ts.getVertexAliases(this.ctx.vtTab));
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Adding " + hint);
            }
            this.sqlQuery.addHintElem(hint);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... done generating hint");
        }
    }

    private String getAliasListString(List<String> list) {
        StringBuilder sb = new StringBuilder("(");
        boolean isFirst = true;
        for (String s : list) {
            if (!isFirst) {
                sb.append(" ");
            }
            isFirst = false;
            sb.append(this.getAliasPfx()).append(s);
        }
        sb.append(")");
        return sb.toString();
    }

    private void addModifyWhereElem(TraversalStruct ts, SqlQuery sq, String aliasId, String whereElem) {
        for (Integer modifyIdx : ts.getAliasModifyList(aliasId)) {
            sq.putModifyWhereElem(modifyIdx, whereElem);
        }
    }

    private void addModifyFromElem(TraversalStruct ts, SqlQuery sq, String aliasId, ValuePair fromElem, boolean addRowIdExpr) {
        for (Integer modifyIdx : ts.getAliasModifyList(aliasId)) {
            sq.putModifyFromElem(modifyIdx, fromElem);
            if (!addRowIdExpr) continue;
            sq.putModifyWhereElem(modifyIdx, "MATCH_QUERY.ROW_ID = " + fromElem.v2 + ".PROP_ID");
        }
    }

    private void generateTraversalSQL(TraversalStruct ts, SqlQuery sq, SqlQuery outerSq) {
        this.generateTraversalSQL(ts, sq, outerSq, false);
    }

    private void generateTraversalSQL(TraversalStruct ts, SqlQuery sq, boolean generateMatchQuery) {
        this.generateTraversalSQL(ts, sq, null, generateMatchQuery);
    }

    private void generateTraversalSQL(TraversalStruct ts, SqlQuery sq, SqlQuery outerSq, boolean generateMatchQuery) {
        String where;
        Set<Map.Entry<String, String[]>> idTabSet = ts.getAllTableNamesForIds();
        for (Map.Entry<String, String[]> entry : idTabSet) {
            String value;
            String string = entry.getKey();
            String tab = entry.getValue()[0];
            String prop = entry.getValue()[1];
            String alias = this.getAliasPfx() + string;
            String distinctEdgesTab = this.ctx.gtTab;
            if (!this.ctx.useGtTab) {
                distinctEdgesTab = "(SELECT DISTINCT " + COLS[0] + ", " + COLS[1] + ", " + COLS[2] + "," + EDGE_LBL_COL + " FROM " + this.ctx.geTab + ")";
            }
            String distinctVerticesTab = this.ctx.vdTab;
            if (!this.ctx.useVdTab) {
                distinctVerticesTab = "(SELECT DISTINCT " + COLS[3];
                if (this.ctx.useVLCol) {
                    distinctVerticesTab = distinctVerticesTab + ", VL";
                }
                distinctVerticesTab = distinctVerticesTab + " FROM " + this.ctx.vtTab + ")";
            }
            boolean isModifyTableAlias = ts.isModifyTableAlias(string);
            if (prop != null && prop.equals(IN_DEGREE)) {
                value = "(SELECT " + COLS[2] + " " + COLS[4] + ", COUNT(*) " + IN_DEGREE + "\nFROM " + distinctEdgesTab + "\nGROUP BY " + COLS[2] + ")";
            } else if (prop != null && prop.equals(OUT_DEGREE)) {
                value = "(SELECT " + COLS[1] + " " + COLS[4] + ", COUNT(*) " + OUT_DEGREE + "\nFROM " + distinctEdgesTab + "\nGROUP BY " + COLS[1] + ")";
            } else {
                value = tab.equals(this.ctx.vtTab) && prop == null ? distinctVerticesTab : (tab.equals(this.ctx.gtTab) && prop == null ? distinctEdgesTab : tab);
                if (ts.isAnyDirectedAlias(string)) {
                    ValuePair withClause;
                    if (prop != null && this.ctx.projNullProps) {
                        withClause = this.getAnyDirectedWithClause(distinctEdgesTab, false);
                        distinctEdgesTab = withClause.v2;
                    } else {
                        withClause = this.getAnyDirectedWithClause(value, prop != null);
                        value = withClause.v2;
                    }
                    if (outerSq != null) {
                        outerSq.addWithClause(withClause);
                    } else {
                        sq.addWithClause(withClause);
                    }
                }
                if (prop != null) {
                    where = "K=" + DbmsUtils.escapeAndEnquoteLiteral(PgqlUtils.unescapePgqlString(prop));
                    if (this.ctx.projNullProps) {
                        String distinctTab;
                        String joinColumn;
                        String projectColumns;
                        if (tab.equals(this.ctx.vtTab)) {
                            projectColumns = "L." + COLS[3] + ", ";
                            if (this.ctx.useVLCol) {
                                projectColumns = projectColumns + "L.VL, ";
                            }
                            joinColumn = COLS[3];
                            distinctTab = distinctVerticesTab;
                        } else {
                            projectColumns = "L." + COLS[0] + ", L." + COLS[1] + ", L." + COLS[2] + ", L." + EDGE_LBL_COL + ", ";
                            joinColumn = COLS[0];
                            distinctTab = distinctEdgesTab;
                        }
                        value = "( SELECT " + projectColumns + "R." + K_COL + ", R." + T_COL + ", R." + V_COL + ", R." + VN_COL + ", R." + VT_COL + "\n  FROM " + distinctTab + " L,\n       (SELECT * FROM " + value + " WHERE " + where + " ) R\n  WHERE L." + joinColumn + " = R." + joinColumn + "(+)\n)";
                    } else {
                        where = alias + "." + where;
                        if (isModifyTableAlias) {
                            this.addModifyWhereElem(ts, sq, string, where);
                        } else {
                            sq.addWhereElem(where);
                        }
                    }
                }
            }
            ValuePair from = new ValuePair(value, alias);
            if (isModifyTableAlias) {
                this.addModifyFromElem(ts, sq, string, from, generateMatchQuery);
                continue;
            }
            sq.addFromElem(from);
        }
        Set<Map.Entry<String, List<int[]>>> ejSet = ts.getAllEdgeJoins();
        for (Map.Entry<String, List<int[]>> entry : ejSet) {
            List<int[]> val = entry.getValue();
            if (val.size() <= 1) continue;
            int[] anchorVal = val.get(0);
            int anchorIdx = 0;
            while (anchorVal[1] == 4 && anchorIdx < val.size() - 1) {
                anchorVal = val.get(++anchorIdx);
            }
            String joinCond = this.getAliasPfx() + Integer.toString(anchorVal[0]) + "." + COLS[anchorVal[1]];
            for (int i = 0; i < val.size(); ++i) {
                if (i == anchorIdx) continue;
                int[] nextVal = val.get(i);
                String outer = "";
                if (nextVal[1] == 4) {
                    outer = "(+)";
                }
                where = joinCond + "=" + this.getAliasPfx() + Integer.toString(nextVal[0]) + "." + COLS[nextVal[1]] + outer;
                if (ts.isModifyTableAlias(Integer.toString(nextVal[0]))) {
                    this.addModifyWhereElem(ts, sq, Integer.toString(nextVal[0]), where);
                    continue;
                }
                sq.addWhereElem(where);
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\nChecking isomorphism: useIso=[" + this.ctx.useIso + "]");
        }
        if (this.ctx.useIso) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\nAdding conditions for isomorphism");
            }
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
            for (Map.Entry<String, List<int[]>> ej : ejSet) {
                List<int[]> val = ej.getValue();
                boolean foundNode = false;
                boolean foundEdge = false;
                for (int i = 0; i < val.size(); ++i) {
                    int[] currVal = val.get(i);
                    if (!(currVal[1] != 1 && currVal[1] != 2 && currVal[1] != 3 || foundNode)) {
                        if (ms_log.isDebugEnabled()) {
                            ms_log.debug("\nAdding [" + currVal[0] + "," + currVal[1] + "] to isoDistinctNodes");
                        }
                        arrayList.add(currVal);
                        foundNode = true;
                        continue;
                    }
                    if (currVal[1] != 0 || foundEdge) continue;
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("\nAdding [" + currVal[0] + "," + currVal[1] + "] to isoDistinctEdges");
                    }
                    arrayList2.add(currVal);
                    foundEdge = true;
                }
            }
            this.addIsoConditions(arrayList, sq);
            this.addIsoConditions(arrayList2, sq);
        }
    }

    private void generateSelect(ExprTransVisitor etv, ExprNavigator nav, List<ExpAsVar> projections, PgqlColumnDescriptor[] returnCols, boolean forModify, boolean generateMatchQuery) {
        int logicalIdx = 0;
        int offset = 1;
        BiConsumer<SqlQuery, ValuePair> addSelectElem = (sqlQuery, vp) -> sqlQuery.addSelectElem((ValuePair)vp);
        for (ExpAsVar eav : projections) {
            QueryExpression exp = eav.getExp();
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\nTranslating Select Expression:\n" + exp.toString());
            }
            if (forModify) {
                addSelectElem = !generateMatchQuery || exp.getExpType() == QueryExpression.ExpressionType.VARREF && this.modifyVarsMap.containsKey(((QueryExpression.VarRef)exp).getVariable().getName()) ? (sqlQuery, vp) -> sqlQuery.addModifySelectElem((ValuePair)vp) : (sqlQuery, vp) -> sqlQuery.addMatchModifySelectElem((ValuePair)vp);
            }
            ExprTranslation t = nav.accept(exp, etv);
            String[] exprSQL = t.getSQL();
            if (offset == 1) {
                this.firstColTypeFam = t.getTypeFam();
            }
            String origName = eav.getName();
            String cleanName = PgqlTranslator.cleanGeneratedName(origName);
            if (exprSQL.length == 4) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nSelect Expression SQL[0]:\n" + exprSQL[0]);
                }
                addSelectElem.accept(this.sqlQuery, new ValuePair(exprSQL[0], "\"" + cleanName + "$T\""));
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nSelect Expression SQL[1]:\n" + exprSQL[1]);
                }
                addSelectElem.accept(this.sqlQuery, new ValuePair(exprSQL[1], "\"" + cleanName + "$V\""));
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nSelect Expression SQL[2]:\n" + exprSQL[2]);
                }
                addSelectElem.accept(this.sqlQuery, new ValuePair(exprSQL[2], "\"" + cleanName + "$VN\""));
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nSelect Expression SQL[3]:\n" + exprSQL[3]);
                }
                addSelectElem.accept(this.sqlQuery, new ValuePair(exprSQL[3], "\"" + cleanName + "$VT\""));
                returnCols[logicalIdx] = new PgqlColumnDescriptorImpl(origName, PgqlColumnDescriptor.Type.VALUE, offset);
                ++logicalIdx;
                offset += 4;
                continue;
            }
            if (exprSQL.length == 2) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nSelect Expression SQL[0]:\n" + exprSQL[0]);
                }
                addSelectElem.accept(this.sqlQuery, new ValuePair(exprSQL[0], "\"" + cleanName + "$IT\""));
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nSelect Expression SQL[1]:\n" + exprSQL[1]);
                }
                addSelectElem.accept(this.sqlQuery, new ValuePair(exprSQL[1], "\"" + cleanName + "$ID\""));
                PgqlColumnDescriptor.Type varType = PgqlColumnDescriptor.Type.VERTEX;
                if (exprSQL[0].equals("n'E'")) {
                    varType = PgqlColumnDescriptor.Type.EDGE;
                }
                returnCols[logicalIdx] = new PgqlColumnDescriptorImpl(origName, varType, offset);
                ++logicalIdx;
                offset += 2;
                continue;
            }
            throw new PgqlToSqlException("Unexpected number of columns returned from expression translation");
        }
    }

    private void generateSQL(boolean forModify, boolean generateMatchQuery) throws PgqlToSqlException {
        int i;
        String[] exprSQL;
        QueryExpression exp;
        this.generateHint(this.tStruct);
        this.generateTraversalSQL(this.tStruct, this.sqlQuery, generateMatchQuery);
        ExprContext eCtx = ExprContext.createExprContext(this.tStruct, this.parentTStruct, this.ctx, this.bvInfo, this.exprAliasMap);
        ExprTransVisitor etv = ExprTransVisitor.getExprTransVisitor(eCtx);
        ExprNavigator nav = ExprNavigator.getExprNavigator(this.exprAliasMap, this.bvInfo);
        eCtx.transMode = 0;
        if (this.pattern != null) {
            for (QueryExpression queryExpression : this.pattern.getConstraints()) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nTranslating Expression:\n" + queryExpression.toString());
                }
                String[] exprSQL2 = nav.accept(queryExpression, etv).getSQL();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nExpression SQL:\n" + exprSQL2[0]);
                }
                this.sqlQuery.addWhereElem(exprSQL2[0]);
            }
        }
        if (this.parentTStruct != null) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\nParent query block is non-null ... adding join conditions");
            }
            for (Map.Entry entry : this.parentTStruct.getAllVarAliases()) {
                String pVar = (String)entry.getKey();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nChecking parent variable " + pVar);
                }
                if (!this.tStruct.containsVarAlias(pVar)) continue;
                String[] parentAlias = (String[])entry.getValue();
                String[] localAlias = this.tStruct.getVarAlias(pVar);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nMatch found ... adding:\n" + parentAlias[0] + "." + parentAlias[1] + "=" + localAlias[0] + "." + localAlias[1]);
                }
                this.sqlQuery.addWhereElem(parentAlias[0] + "." + parentAlias[1] + "=" + localAlias[0] + "." + localAlias[1]);
            }
        }
        eCtx.transMode = 2;
        if (this.qg.getGroupBy() != null) {
            List groupBy = this.qg.getGroupBy().getElements();
            for (ExpAsVar eav : groupBy) {
                exp = eav.getExp();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nTranslating GROUP BY Expression:\n" + exp.toString());
                }
                exprSQL = nav.accept(exp, etv).getSQL();
                for (i = 0; i < exprSQL.length; ++i) {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("\nGROUP BY Expression SQL[" + i + "]:\n" + exprSQL[i]);
                    }
                    this.sqlQuery.addGroupElem(exprSQL[i]);
                }
            }
        }
        if (this.modHaving != null) {
            eCtx.transMode = 0;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\nTranslating Having Expression:\n" + this.modHaving.toString());
            }
            String[] exprSQL3 = nav.accept(this.modHaving, etv).getSQL();
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\nHaving Expression SQL:\n" + exprSQL3[0]);
            }
            this.sqlQuery.addHavingElem(exprSQL3[0]);
        }
        if (this.qg.getQueryType() == QueryType.SELECT && ((SelectQuery)this.qg).getProjection().isDistinct()) {
            this.sqlQuery.setDistinct(true);
        }
        if (generateMatchQuery) {
            this.sqlQuery.setMatchTableName(MATCH_TABLE_NAME);
        }
        eCtx.transMode = 3;
        if (!forModify) {
            List<ExpAsVar> projections = this.modSelectElemsList.get(0);
            this.returnCols = new PgqlColumnDescriptorImpl[projections.size()];
            this.generateSelect(etv, nav, projections, this.returnCols, forModify, generateMatchQuery);
        } else {
            for (List list : this.modSelectElemsList) {
                this.sqlQuery.addModifySqlQueryElem(generateMatchQuery);
                PgqlColumnDescriptor[] returnCols = new PgqlColumnDescriptorImpl[list.size()];
                this.modifyReturnColsList.add(returnCols);
                this.generateSelect(etv, nav, list, returnCols, forModify, generateMatchQuery);
            }
            if (!generateMatchQuery) {
                this.sqlQuery.moveMatchElemsToModify();
            }
        }
        eCtx.transMode = 1;
        List<OrderByElem> orderBy = this.modOrderByElems;
        for (OrderByElem obe : orderBy) {
            exp = obe.getExp();
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\nTranslating ORDER BY Expression:\n" + exp.toString());
            }
            eCtx.direction = obe.isAscending() ? 0 : 1;
            exprSQL = nav.accept(exp, etv).getSQL();
            for (i = 0; i < exprSQL.length; ++i) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nORDER BY Expression SQL[" + i + "]:\n" + exprSQL[i]);
                }
                this.sqlQuery.addOrderElem(exprSQL[i]);
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug(this.sqlQuery.toString());
        }
    }

    private void buildSQLString() {
        this.sqlBuff = this.sqlQuery.buildSQLString();
    }

    private void buildSQLModifyString(int elemsIdx) {
        this.sqlBuff = this.sqlQuery.buildSQLModifyString(elemsIdx);
    }

    private String[] buildMatchTranslation() {
        String[] matchTranslation = this.sqlQuery.buildMatchTranslation(this.ctx.useExtdSize);
        if (matchTranslation != null && this.queryBlockId == 0) {
            this.sqlBuff = new StringBuffer(matchTranslation[2]);
            this.processBindVariables(0);
            matchTranslation[2] = this.sqlBuff.toString();
        }
        return matchTranslation;
    }

    private String[] buildSQLStringsForUpdate(int returnColsIdx) throws PgqlException {
        this.buildSQLModifyString(returnColsIdx);
        if (this.queryBlockId == 0) {
            this.processBindVariables(returnColsIdx + 1);
        }
        ArrayList<String> vertexTableColumns = new ArrayList<String>();
        if (this.ctx.useVLCol) {
            vertexTableColumns.addAll(VERTEX_TABLE_COLS);
        } else {
            vertexTableColumns.addAll(VERTEX_TABLE_NO_LABEL_COLS);
        }
        vertexTableColumns.addAll(KEY_VALUE_COLS);
        ArrayList<String> edgeTableColumns = new ArrayList<String>();
        edgeTableColumns.addAll(EDGE_TABLE_COLS);
        edgeTableColumns.addAll(KEY_VALUE_COLS);
        SqlQuery vertexQuery = new SqlQuery();
        vertexQuery.setDistinct(true);
        vertexQuery.addFromElem(new ValuePair("(" + this.sqlBuff + ")", "q"));
        vertexQuery.addUnpivot("PROP_ID, ", "PROP_ID", String.join((CharSequence)", ", vertexTableColumns));
        SqlQuery edgeQuery = new SqlQuery();
        edgeQuery.setDistinct(true);
        edgeQuery.addFromElem(new ValuePair("(" + this.sqlBuff + ")", "q"));
        edgeQuery.addUnpivot("PROP_ID, ", "PROP_ID", String.join((CharSequence)", ", edgeTableColumns));
        int vertexTableIdx = 0;
        int edgeTableIdx = 0;
        String[] vertexValues = new String[vertexTableColumns.size()];
        String[] edgeValues = new String[edgeTableColumns.size()];
        PgqlColumnDescriptor[] returnCols = this.modifyReturnColsList.get(returnColsIdx);
        for (int i = 0; i < returnCols.length; i += 2) {
            int col;
            int idx;
            String[] currentValues;
            ArrayList<String> currentColumns;
            String tableAlias;
            String tableName;
            SqlQuery currentQuery;
            String currentElement = returnCols[i].getColName();
            String currentK = currentElement.substring(currentElement.indexOf("$") + 1);
            int colIdx = 0;
            switch (returnCols[i].getColType()) {
                case VERTEX: {
                    currentQuery = vertexQuery;
                    tableName = this.ctx.vtTab;
                    tableAlias = "T0$" + vertexTableIdx;
                    currentColumns = vertexTableColumns;
                    vertexValues[colIdx++] = tableAlias + "." + COLS[3];
                    if (this.ctx.useVLCol) {
                        vertexValues[colIdx++] = tableAlias + "." + VERTEX_LBL_COL;
                    }
                    currentValues = vertexValues;
                    ++vertexTableIdx;
                    break;
                }
                case EDGE: {
                    currentQuery = edgeQuery;
                    tableName = this.ctx.geTab;
                    tableAlias = "T0$" + edgeTableIdx;
                    currentColumns = edgeTableColumns;
                    for (idx = 0; idx < EDGE_TABLE_COLS.size(); ++idx) {
                        edgeValues[colIdx++] = tableAlias + "." + EDGE_TABLE_COLS.get(idx);
                    }
                    currentValues = edgeValues;
                    ++edgeTableIdx;
                    break;
                }
                default: {
                    throw new PgqlException("Unexpected return type" + (Object)((Object)returnCols[i].getColType()));
                }
            }
            currentValues[colIdx++] = "n'" + currentK + "'";
            for (idx = 1; idx < KEY_VALUE_COLS.size(); ++idx) {
                currentValues[colIdx++] = "q.\"" + currentElement + "$" + KEY_VALUE_COLS.get(idx) + "\"";
            }
            for (col = 0; col < currentValues.length; ++col) {
                currentQuery.addSelectElem(new ValuePair(currentValues[col], "\"" + currentElement + (String)currentColumns.get(col) + "\""));
            }
            currentQuery.addFromElem(new ValuePair(tableName, tableAlias));
            currentQuery.addWhereElem("q.\"" + currentElement + "$ID\" = " + tableAlias + "." + (String)currentColumns.get(0));
            currentQuery.addUnpivotList();
            for (col = 0; col < currentColumns.size(); ++col) {
                currentQuery.addUnpivotElem("\"" + currentElement + (String)currentColumns.get(col) + "\"");
            }
        }
        String selectVertices = null;
        if (vertexTableIdx > 0) {
            selectVertices = vertexQuery.buildQueryUnpivot().toString();
        }
        String selectEdges = null;
        if (edgeTableIdx > 0) {
            selectEdges = edgeQuery.buildQueryUnpivot().toString();
        }
        return new String[]{selectVertices, selectEdges};
    }

    private String getSQLRandomIDString() {
        return "round(sys_op_combined_hash(sys_guid()) / 2) + ROWNUM - ROWNUM";
    }

    private String buildSQLStringForInsert(int returnColsIdx, boolean forEdgeInsert, boolean projectRowId) {
        this.buildSQLModifyString(returnColsIdx);
        if (this.queryBlockId == 0) {
            this.processBindVariables(returnColsIdx + 1);
        }
        SqlQuery insertQuery = new SqlQuery();
        insertQuery.addHintElem("NO_MERGE");
        insertQuery.addFromElem(new ValuePair("(" + this.sqlBuff + ")", "q"));
        PgqlColumnDescriptor[] returnCols = this.modifyReturnColsList.get(returnColsIdx);
        int idxCols = 0;
        ArrayList<String> elementColumns = new ArrayList<String>();
        String idSelectExpr = this.getSQLRandomIDString();
        String rowIdExpr = "";
        if (projectRowId) {
            insertQuery.addSelectElem(new ValuePair("ROW_ID", "ROW_ID"));
            rowIdExpr = "ROW_ID, ";
        }
        if (forEdgeInsert) {
            String source = returnCols[idxCols++].getColName();
            String dest = returnCols[idxCols].getColType() == PgqlColumnDescriptor.Type.VERTEX ? returnCols[idxCols++].getColName() : source;
            String edge = returnCols[idxCols++].getColName();
            insertQuery.addSelectElem(new ValuePair("\"" + source + "$ID\"", COLS[1]));
            insertQuery.addSelectElem(new ValuePair("\"" + dest + "$ID\"", COLS[2]));
            insertQuery.addSelectElem(new ValuePair("\"" + edge + "$V\"", EDGE_LBL_COL));
            elementColumns.addAll(EDGE_TABLE_COLS);
        } else {
            String vertex = returnCols[idxCols++].getColName();
            insertQuery.addSelectElem(new ValuePair("\"" + vertex + "$V\"", VERTEX_LBL_COL));
            if (this.ctx.useVLCol) {
                elementColumns.addAll(VERTEX_TABLE_COLS);
            } else {
                elementColumns.addAll(VERTEX_TABLE_NO_LABEL_COLS);
            }
        }
        ArrayList<String> allColumns = new ArrayList<String>();
        allColumns.addAll(elementColumns);
        allColumns.addAll(KEY_VALUE_COLS);
        String elementColumnsStr = allColumns.stream().collect(Collectors.joining(", "));
        insertQuery.addUnpivot(rowIdExpr, "PROP_ID", elementColumnsStr);
        boolean buildUnpivot = false;
        for (int i = idxCols; i < returnCols.length; ++i) {
            String currentElement = returnCols[i].getColName();
            String currentK = currentElement.substring(currentElement.indexOf("$") + 1);
            if ("_ora_id".equals(currentK)) {
                idSelectExpr = "\"" + currentElement + "$VN\"";
                continue;
            }
            int propIdx = i - idxCols;
            insertQuery.addSelectElem(new ValuePair("n'" + currentK + "'", K_COL + propIdx));
            for (int j = 1; j < KEY_VALUE_COLS.size(); ++j) {
                insertQuery.addSelectElem(new ValuePair("\"" + currentElement + "$" + KEY_VALUE_COLS.get(j) + "\"", KEY_VALUE_COLS.get(j) + propIdx));
            }
            insertQuery.addUnpivotList();
            for (String col : elementColumns) {
                insertQuery.addUnpivotElem(col);
            }
            for (String col : KEY_VALUE_COLS) {
                insertQuery.addUnpivotElem(col + propIdx);
            }
            buildUnpivot = true;
        }
        insertQuery.addSelectElem(new ValuePair(idSelectExpr, (String)elementColumns.get(0)));
        if (!buildUnpivot) {
            for (String col : KEY_VALUE_COLS) {
                insertQuery.addSelectElem(new ValuePair("null", col));
            }
        }
        return insertQuery.buildQueryUnpivot().toString();
    }

    private String[] buildSQLStringsForDelete(int returnColsIdx) throws PgqlException {
        this.buildSQLModifyString(returnColsIdx);
        if (this.queryBlockId == 0) {
            this.processBindVariables(returnColsIdx + 1);
        }
        SqlQuery vertexQuery = new SqlQuery();
        vertexQuery.addFromElem(new ValuePair("(" + this.sqlBuff + ")", "q"));
        vertexQuery.addUnpivot("", "ELEMENT_ID", "ID");
        SqlQuery edgeQuery = new SqlQuery();
        edgeQuery.addFromElem(new ValuePair("(" + this.sqlBuff + ")", "q"));
        edgeQuery.addUnpivot("", "ELEMENT_ID", "ID");
        int vertexIdx = 0;
        int edgeIdx = 0;
        PgqlColumnDescriptor[] returnCols = this.modifyReturnColsList.get(returnColsIdx);
        for (int i = 0; i < returnCols.length; ++i) {
            SqlQuery currentQuery;
            String currentElement = returnCols[i].getColName();
            switch (returnCols[i].getColType()) {
                case VERTEX: {
                    currentQuery = vertexQuery;
                    ++vertexIdx;
                    break;
                }
                case EDGE: {
                    currentQuery = edgeQuery;
                    ++edgeIdx;
                    break;
                }
                default: {
                    throw new PgqlException("Unexpected return type" + (Object)((Object)returnCols[i].getColType()));
                }
            }
            String idCol = "\"" + currentElement + "$ID\"";
            currentQuery.addSelectElem(new ValuePair(idCol, idCol));
            currentQuery.addUnpivotList();
            currentQuery.addUnpivotElem(idCol);
        }
        String queryVertices = null;
        String queryEdges = null;
        if (vertexIdx > 0) {
            queryVertices = vertexQuery.buildQueryUnpivot().toString();
        }
        if (edgeIdx > 0) {
            queryEdges = edgeQuery.buildQueryUnpivot().toString();
        }
        return new String[]{queryVertices, queryEdges};
    }

    private void processBindVariables(int modifyIdx) {
        this.sqlBuff = new StringBuffer(this.bvInfo.processBindVariables(this.sqlBuff.toString(), modifyIdx));
    }

    private QueryExpression addRequiredAggregates(QueryExpression qe, boolean[] transformed) {
        QueryExpression.ExpressionType exprType = qe.getExpType();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("addRequiredAggregates: " + qe.toString());
        }
        switch (exprType) {
            case INTEGER: 
            case DECIMAL: 
            case STRING: 
            case BOOLEAN: 
            case STAR: 
            case BIND_VARIABLE: {
                transformed[0] = false;
                return qe;
            }
            case VARREF: {
                transformed[0] = false;
                return qe;
            }
            case PROP_ACCESS: {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("  addRequiredAggregates: wrapping property access");
                }
                transformed[0] = true;
                return new QueryExpression.Aggregation.AggrMax(false, qe);
            }
            case SUB: 
            case ADD: 
            case MUL: 
            case DIV: 
            case MOD: 
            case AND: 
            case OR: 
            case EQUAL: 
            case NOT_EQUAL: 
            case GREATER: 
            case GREATER_EQUAL: 
            case LESS: 
            case LESS_EQUAL: {
                QueryExpression.BinaryExpression be = (QueryExpression.BinaryExpression)qe;
                boolean[] c1Transformed = new boolean[1];
                QueryExpression c1 = this.addRequiredAggregates(be.getExp1(), c1Transformed);
                boolean[] c2Transformed = new boolean[1];
                QueryExpression c2 = this.addRequiredAggregates(be.getExp2(), c2Transformed);
                if (c1Transformed[0] || c2Transformed[0]) {
                    transformed[0] = true;
                    if (exprType == QueryExpression.ExpressionType.SUB) {
                        return new QueryExpression.ArithmeticExpression.Sub(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.ADD) {
                        return new QueryExpression.ArithmeticExpression.Add(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.MUL) {
                        return new QueryExpression.ArithmeticExpression.Mul(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.DIV) {
                        return new QueryExpression.ArithmeticExpression.Div(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.MOD) {
                        return new QueryExpression.ArithmeticExpression.Mod(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.AND) {
                        return new QueryExpression.LogicalExpression.And(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.OR) {
                        return new QueryExpression.LogicalExpression.Or(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.EQUAL) {
                        return new QueryExpression.RelationalExpression.Equal(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.NOT_EQUAL) {
                        return new QueryExpression.RelationalExpression.NotEqual(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.GREATER) {
                        return new QueryExpression.RelationalExpression.Greater(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.GREATER_EQUAL) {
                        return new QueryExpression.RelationalExpression.GreaterEqual(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.LESS) {
                        return new QueryExpression.RelationalExpression.Less(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.LESS_EQUAL) {
                        return new QueryExpression.RelationalExpression.LessEqual(c1, c2);
                    }
                } else {
                    transformed[0] = false;
                    return qe;
                }
            }
            case CAST: {
                QueryExpression.Function.Cast c = (QueryExpression.Function.Cast)qe;
                boolean[] c1Transformed = new boolean[1];
                QueryExpression c1 = this.addRequiredAggregates(c.getExp(), c1Transformed);
                if (c1Transformed[0]) {
                    transformed[0] = true;
                    return new QueryExpression.Function.Cast(c1, c.getTargetTypeName());
                }
                transformed[0] = false;
                return qe;
            }
            case SIMPLE_CASE: {
                QueryExpression.SimpleCase sc = (QueryExpression.SimpleCase)qe;
                return this.addRequiredAggregates((QueryExpression)sc.getIfElseRepresentation(), transformed);
            }
            case IF_ELSE: {
                QueryExpression.IfElse ie = (QueryExpression.IfElse)qe;
                boolean[] c1Transformed = new boolean[1];
                QueryExpression c1 = this.addRequiredAggregates(ie.getExp1(), c1Transformed);
                boolean[] c2Transformed = new boolean[1];
                QueryExpression c2 = this.addRequiredAggregates(ie.getExp2(), c2Transformed);
                boolean[] c3Transformed = new boolean[1];
                QueryExpression c3 = this.addRequiredAggregates(ie.getExp3(), c3Transformed);
                if (c1Transformed[0] || c2Transformed[0] || c3Transformed[0]) {
                    transformed[0] = true;
                    return new QueryExpression.IfElse(c1, c2, c3);
                }
                transformed[0] = false;
                return qe;
            }
            case EXTRACT_EXPRESSION: {
                QueryExpression.ExtractExpression e = (QueryExpression.ExtractExpression)qe;
                boolean[] c1Transformed = new boolean[1];
                QueryExpression c1 = this.addRequiredAggregates(e.getExp(), c1Transformed);
                if (c1Transformed[0]) {
                    transformed[0] = true;
                    return new QueryExpression.ExtractExpression(e.getField(), c1);
                }
                transformed[0] = false;
                return qe;
            }
            case IN_EXPRESSION: {
                QueryExpression.InPredicate inp = (QueryExpression.InPredicate)qe;
                boolean[] c1Transformed = new boolean[1];
                QueryExpression c1 = this.addRequiredAggregates(inp.getExp(), c1Transformed);
                if (c1Transformed[0]) {
                    transformed[0] = true;
                    return new QueryExpression.InPredicate(c1, inp.getInValueList());
                }
                transformed[0] = false;
                return qe;
            }
            case IS_NULL: {
                QueryExpression.IsNull in = (QueryExpression.IsNull)qe;
                boolean[] c1Transformed = new boolean[1];
                QueryExpression c1 = this.addRequiredAggregates(in.getExp(), c1Transformed);
                if (c1Transformed[0]) {
                    transformed[0] = true;
                    return new QueryExpression.IsNull(c1);
                }
                transformed[0] = false;
                return qe;
            }
            case FUNCTION_CALL: {
                QueryExpression.FunctionCall fc = (QueryExpression.FunctionCall)qe;
                String fName = fc.getFunctionName().toUpperCase();
                if ("IN_DEGREE".equals(fName) || "OUT_DEGREE".equals(fName) || "LABEL".equals(fName) || "HAS_LABEL".equals(fName) || "HAS_PROP".equals(fName)) {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("  addRequiredAggregates: wrapping function call");
                    }
                    transformed[0] = true;
                    return new QueryExpression.Aggregation.AggrMax(false, qe);
                }
                List exps = fc.getArgs();
                int numExps = exps.size();
                transformed[0] = false;
                boolean[] cTransformed = new boolean[1];
                ArrayList<QueryExpression> tExps = new ArrayList<QueryExpression>(numExps);
                for (int i = 0; i < numExps; ++i) {
                    tExps.add(this.addRequiredAggregates((QueryExpression)exps.get(i), cTransformed));
                    if (!cTransformed[0]) continue;
                    transformed[0] = true;
                }
                if (transformed[0]) {
                    return new QueryExpression.FunctionCall(fc.getPackageName(), fc.getFunctionName(), tExps);
                }
                return qe;
            }
            case NOT: 
            case UMIN: {
                QueryExpression.UnaryExpression ue = (QueryExpression.UnaryExpression)qe;
                boolean[] c1Transformed = new boolean[1];
                QueryExpression c1 = this.addRequiredAggregates(ue.getExp(), c1Transformed);
                if (c1Transformed[0]) {
                    transformed[0] = true;
                    if (exprType == QueryExpression.ExpressionType.UMIN) {
                        return new QueryExpression.ArithmeticExpression.UMin(c1);
                    }
                    if (exprType == QueryExpression.ExpressionType.NOT) {
                        return new QueryExpression.LogicalExpression.Not(c1);
                    }
                } else {
                    transformed[0] = false;
                    return qe;
                }
                throw new RuntimeException("Unexpected error");
            }
            case AGGR_COUNT: 
            case AGGR_MIN: 
            case AGGR_MAX: 
            case AGGR_SUM: 
            case AGGR_AVG: {
                transformed[0] = false;
                return qe;
            }
            case EXISTS: {
                transformed[0] = false;
                return qe;
            }
        }
        transformed[0] = false;
        return qe;
    }

    private void extractVarsAndProps(QueryExpression qe, Set<String> vars, Set<ValuePair> varProps) throws PgqlToSqlException {
        Stack<QueryExpression> s = new Stack<QueryExpression>();
        s.push(qe);
        while (!s.empty()) {
            QueryExpression.FunctionCall fc;
            String fName;
            QueryExpression currQe = (QueryExpression)s.pop();
            if (currQe.getExpType() == QueryExpression.ExpressionType.VARREF) {
                QueryExpression.VarRef vr = (QueryExpression.VarRef)currQe;
                vars.add(this.resolveVarAlias(vr.getVariable().getName()));
            } else if (currQe.getExpType() == QueryExpression.ExpressionType.PROP_ACCESS) {
                QueryExpression.PropertyAccess pa = (QueryExpression.PropertyAccess)currQe;
                varProps.add(new ValuePair(this.resolveVarAlias(pa.getVariable().getName()), pa.getPropertyName()));
            } else if (currQe.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ("LABEL".equals(fName = (fc = (QueryExpression.FunctionCall)currQe).getFunctionName().toUpperCase()) || "HAS_LABEL".equals(fName) || "IN_DEGREE".equals(fName) || "OUT_DEGREE".equals(fName)) && fc.getArgs().size() > 0) {
                QueryExpression arg = (QueryExpression)fc.getArgs().get(0);
                if (arg.getExpType() == QueryExpression.ExpressionType.VARREF) {
                    QueryExpression.VarRef vr = (QueryExpression.VarRef)arg;
                    String varName = vr.getVariable().getName();
                    if ("LABEL".equals(fName) || "HAS_LABEL".equals(fName)) {
                        varProps.add(new ValuePair(this.resolveVarAlias(varName), LABEL_PROP));
                    } else if ("IN_DEGREE".equals(fName)) {
                        varProps.add(new ValuePair(this.resolveVarAlias(varName), IN_DEGREE));
                    } else if ("OUT_DEGREE".equals(fName)) {
                        varProps.add(new ValuePair(this.resolveVarAlias(varName), OUT_DEGREE));
                    }
                } else {
                    throw new PgqlToSqlException("VARREF not found under " + fName);
                }
            }
            if (currQe instanceof QueryExpression.UnaryExpression) {
                QueryExpression.UnaryExpression ue = (QueryExpression.UnaryExpression)currQe;
                s.push(ue.getExp());
            }
            if (currQe instanceof QueryExpression.Function.Cast) {
                QueryExpression.Function.Cast c = (QueryExpression.Function.Cast)currQe;
                s.push(c.getExp());
            }
            if (currQe instanceof QueryExpression.IfElse) {
                QueryExpression.IfElse ie = (QueryExpression.IfElse)currQe;
                s.push(ie.getExp1());
                s.push(ie.getExp2());
                s.push(ie.getExp3());
            }
            if (currQe instanceof QueryExpression.ExtractExpression) {
                QueryExpression.ExtractExpression e = (QueryExpression.ExtractExpression)currQe;
                s.push(e.getExp());
            }
            if (currQe instanceof QueryExpression.InPredicate) {
                QueryExpression.InPredicate inp = (QueryExpression.InPredicate)currQe;
                s.push(inp.getExp());
            }
            if (currQe instanceof QueryExpression.IsNull) {
                QueryExpression.IsNull in = (QueryExpression.IsNull)currQe;
                s.push(in.getExp());
            }
            if (currQe instanceof QueryExpression.FunctionCall) {
                fc = (QueryExpression.FunctionCall)currQe;
                for (QueryExpression e : fc.getArgs()) {
                    s.push(e);
                }
            }
            if (!(currQe instanceof QueryExpression.BinaryExpression)) continue;
            QueryExpression.BinaryExpression be = (QueryExpression.BinaryExpression)currQe;
            s.push(be.getExp1());
            s.push(be.getExp2());
        }
    }

    private void addIsoConditions(List<int[]> isoDistinctVals, SqlQuery sq) {
        for (int i = 0; i < isoDistinctVals.size(); ++i) {
            int[] anchorVal = isoDistinctVals.get(i);
            String anchorRef = this.getAliasPfx() + Integer.toString(anchorVal[0]) + "." + COLS[anchorVal[1]];
            for (int j = i + 1; j < isoDistinctVals.size(); ++j) {
                int[] nextVal = isoDistinctVals.get(j);
                sq.addWhereElem(anchorRef + "<>" + this.getAliasPfx() + Integer.toString(nextVal[0]) + "." + COLS[nextVal[1]]);
            }
        }
    }

    protected static String cleanGeneratedName(String name) {
        int i = name.indexOf(GENERATED_KW);
        if (i >= 0) {
            return name.substring(0, i);
        }
        return name.replaceAll("\"", "_");
    }

    private String resolveVarAlias(String name) {
        String rootName = name;
        QueryExpression e = this.exprAliasMap.get(rootName);
        while (e != null) {
            if (e.getExpType() == QueryExpression.ExpressionType.VARREF) {
                QueryVariable v = ((QueryExpression.VarRef)e).getVariable();
                rootName = v.getName();
                if (v.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR) {
                    e = this.exprAliasMap.get(rootName);
                    continue;
                }
                e = null;
                continue;
            }
            e = null;
        }
        return rootName;
    }

    private String getVarName(QueryExpression expr) {
        String varName = null;
        if (expr.getExpType() == QueryExpression.ExpressionType.VARREF) {
            varName = ((QueryExpression.VarRef)expr).getVariable().getName();
        }
        return varName;
    }

    private String getAliasPfx() {
        return T_COL + Integer.toString(this.queryBlockId) + "$";
    }

    private void addNodesEdgesForParentRefs(Set<VertexPairConnection> connections, Set<QueryVertex> nodes, List<QueryExpression> constraints) throws PgqlToSqlException {
        HashSet<ValuePair> varPropSet = new HashSet<ValuePair>();
        HashSet<String> varSet = new HashSet<String>();
        for (QueryExpression expr : constraints) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Checking expr:\n" + expr.toString());
            }
            varPropSet.clear();
            varSet.clear();
            this.extractVarsAndProps(expr, varSet, varPropSet);
            for (ValuePair vp : varPropSet) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Checking var.prop: " + vp.v1 + "." + vp.v2);
                }
                if (this.parentTStruct.containsPropAlias(vp)) continue;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("var.prop: " + vp.v1 + "." + vp.v2 + " is not referenced in parent so we need to check it");
                }
                this.addNodesEdgesForParentVar(connections, nodes, vp.v1);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addNodesEdgesForParentVar(Set<VertexPairConnection> connections, Set<QueryVertex> nodes, String var) throws PgqlToSqlException {
        if (!this.containsVarRef(connections, nodes, var)) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("We do not have a reference to this parent node/edge ... need to add it");
            }
            if (this.isParentEdge(var)) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Found parent edge reference ...");
                }
                VertexPairConnection vpc = this.getParentEdgeFromVarName(var);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("... adding " + vpc.toString());
                }
                connections.add(vpc);
                return;
            } else {
                if (!this.isParentVertex(var)) throw new PgqlToSqlException("Invalid parent reference for [" + var + "]: not a vertex or edge");
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Found parent vertex reference ...");
                }
                QueryVertex qv = this.getQueryVertexFromVarName(var);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("... adding " + qv.toString());
                }
                nodes.add(qv);
            }
            return;
        } else {
            if (!ms_log.isDebugEnabled()) return;
            ms_log.debug("We already have a reference to this parent node/edge ... not adding it");
        }
    }

    private boolean containsVarRef(Set<VertexPairConnection> connections, Set<QueryVertex> nodes, String var) {
        for (QueryVertex qv : nodes) {
            if (!qv.getName().equals(var)) continue;
            return true;
        }
        for (VertexPairConnection vpc : connections) {
            if (vpc.getName().equals(var)) {
                return true;
            }
            if (vpc.getSrc().getName().equals(var)) {
                return true;
            }
            if (!vpc.getDst().getName().equals(var)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentEdge(String var) {
        List<int[]> joins = this.parentTStruct.getEdgeJoin(var);
        int varId = joins.get(0)[0];
        int varPos = joins.get(0)[1];
        return varPos == 0;
    }

    private boolean isParentVertex(String var) {
        List<int[]> joins = this.parentTStruct.getEdgeJoin(var);
        int varId = joins.get(0)[0];
        int varPos = joins.get(0)[1];
        return varPos == 1 || varPos == 2 || varPos == 3;
    }

    private QueryVertex getQueryVertexFromVarName(String var) {
        return new QueryVertex(var, false);
    }

    private VertexPairConnection getParentEdgeFromVarName(String var) {
        List<int[]> joins = this.parentTStruct.getEdgeJoin(var);
        int varId = joins.get(0)[0];
        String startNode = null;
        String endNode = null;
        for (Map.Entry<String, List<int[]>> currJoin : this.parentTStruct.getAllEdgeJoins()) {
            String currVar = currJoin.getKey();
            for (int[] joinInfo : currJoin.getValue()) {
                if (varId != joinInfo[0]) continue;
                if (joinInfo[1] == 1) {
                    startNode = currVar;
                    continue;
                }
                if (joinInfo[1] != 2) continue;
                endNode = currVar;
            }
            if (startNode == null || endNode == null) continue;
            break;
        }
        return new QueryEdge(this.getQueryVertexFromVarName(startNode), this.getQueryVertexFromVarName(endNode), var, false, Direction.OUTGOING);
    }

    private ValuePair getAnyDirectedWithClause(String gtTab, boolean projectKVColumns) {
        String tableAlias = ANY_DIRECTED_ALIAS;
        String kvColumns = "";
        if (projectKVColumns) {
            kvColumns = ", K, T, V, VN, VT";
            tableAlias = ANY_DIRECTED_KV_ALIAS;
        }
        String translation = "\n(SELECT " + COLS[0] + ", " + COLS[1] + ", " + COLS[2] + ", " + EDGE_LBL_COL + kvColumns + "\n FROM " + gtTab + "\n UNION ALL\n SELECT " + COLS[0] + ", " + COLS[2] + " AS " + COLS[1] + ", " + COLS[1] + " AS " + COLS[2] + ", " + EDGE_LBL_COL + kvColumns + "\n FROM " + gtTab + "\n WHERE " + COLS[2] + " <> " + COLS[1] + ")";
        return new ValuePair(translation, tableAlias);
    }

    private static boolean isIdFunction(QueryExpression qe) {
        boolean isId = false;
        if (qe.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)qe).getFunctionName().toUpperCase().equals("ID")) {
            isId = true;
        }
        return isId;
    }

    private static GraphType getCreateType(CreatePropertyGraph cpg) {
        List options = cpg.getOptions();
        if (options == null) {
            return GraphType.PG_SCHEMA;
        }
        if (options.size() != 1) {
            throw new PgqlToSqlException("Wrong number of options in CREATE PROPERTY GRAPH");
        }
        String option = (String)options.get(0);
        if ("PG_SCHEMA".equalsIgnoreCase(option)) {
            return GraphType.PG_SCHEMA;
        }
        if ("PG_VIEW".equalsIgnoreCase(option)) {
            return GraphType.PG_VIEWS;
        }
        throw new PgqlToSqlException("Unknown option in CREATE PROPERTY GRAPH:" + option);
    }

    static {
        block2: {
            ms_log = LoggerFactory.getLogger(PgqlTranslator.class);
            pgql = null;
            try {
                pgql = new Pgql();
            }
            catch (PgqlException ex) {
                if (!ms_log.isDebugEnabled()) break block2;
                ms_log.debug("\nFailed to initialize Pgql instance");
            }
        }
        COLS = new String[]{"EID", "SVID", "DVID", "VID", "VIDDG"};
        VERTEX_TABLE_NO_LABEL_COLS = Arrays.asList(COLS[3]);
        VERTEX_TABLE_COLS = Arrays.asList(COLS[3], VERTEX_LBL_COL);
        EDGE_TABLE_COLS = Arrays.asList(COLS[0], COLS[1], COLS[2], EDGE_LBL_COL);
        KEY_VALUE_COLS = Arrays.asList(K_COL, T_COL, V_COL, VN_COL, VT_COL);
    }

    private class PathTranslator {
        boolean useAnchor;
        TraversalStruct anchorStruct;
        SqlQuery anchorQuery;
        TraversalStruct tStruct;
        SqlQuery sqlQuery;
        TraversalStruct zeroStruct;
        SqlQuery zeroQuery;
        QueryPath queryPath;
        String sourceID;
        String destID;
        List<QueryExpression> sourceConstraints;
        List<QueryExpression> destConstraints;

        PathTranslator(QueryPath queryPath, String sourceID, String destID, List<QueryExpression> sourceConstraints, List<QueryExpression> destConstraints) {
            this.queryPath = queryPath;
            this.sourceID = sourceID;
            this.destID = destID;
            this.useAnchor = false;
            this.anchorStruct = new TraversalStruct();
            this.anchorQuery = new SqlQuery();
            this.tStruct = new TraversalStruct();
            this.sqlQuery = new SqlQuery();
            this.zeroStruct = new TraversalStruct();
            this.zeroQuery = new SqlQuery();
            this.sourceConstraints = sourceConstraints;
            this.destConstraints = destConstraints;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\tSource: " + queryPath.getSrc().toString() + ", ID:" + sourceID);
                ms_log.debug("\tDestination: " + queryPath.getDst().toString() + ", ID:" + destID);
                ms_log.debug("\tVertices:");
                for (QueryVertex queryVertex : queryPath.getVertices()) {
                    ms_log.debug("\t\t" + queryVertex.toString());
                }
                ms_log.debug("\tConnections:");
                for (VertexPairConnection vertexPairConnection : queryPath.getConnections()) {
                    ms_log.debug("\t\t" + vertexPairConnection.toString());
                }
                ms_log.debug("\tConstraints:");
                for (QueryExpression queryExpression : queryPath.getConstraints()) {
                    ms_log.debug("\t\t" + queryExpression.toString());
                }
                ms_log.debug("\tMin Hops: " + queryPath.getMinHops());
                ms_log.debug("\tMax Hops: " + queryPath.getMaxHops());
                ms_log.debug("\tSource Constraints:");
                for (QueryExpression queryExpression : sourceConstraints) {
                    ms_log.debug("\t\t" + queryExpression.toString());
                }
                ms_log.debug("\tDestination Constraints:");
                for (QueryExpression queryExpression : destConstraints) {
                    ms_log.debug("\t\t" + queryExpression.toString());
                }
            }
        }

        public String translatePathQuery() throws PgqlToSqlException {
            this.populatePathDataStructures();
            this.generateBaseSQL(false);
            if (this.useAnchor) {
                this.generateBaseSQL(true);
            }
            return this.buildPathSQL();
        }

        private boolean useSourceConstraints() {
            return this.sourceConstraints.size() > 0 && this.destID == null && this.sourceID == null;
        }

        private boolean useDestConstraints() {
            return this.sourceConstraints.size() == 0 && this.destConstraints.size() > 0 && this.destID == null && this.sourceID == null;
        }

        private QueryVertex getLocalSource() {
            QueryVertex sourceVar = null;
            if (this.queryPath.getVertices().size() > 0) {
                sourceVar = (QueryVertex)this.queryPath.getVertices().get(0);
            }
            return sourceVar;
        }

        private QueryVertex getLocalDest() {
            QueryVertex destVar = null;
            if (this.queryPath.getVertices().size() > 0) {
                destVar = (QueryVertex)this.queryPath.getVertices().get(this.queryPath.getVertices().size() - 1);
            }
            return destVar;
        }

        private boolean shouldReverseRW() {
            if (this.sourceID != null) {
                return false;
            }
            if (this.destID != null) {
                return true;
            }
            if (this.sourceConstraints.size() > 0) {
                return false;
            }
            return this.destConstraints.size() > 0;
        }

        private void populatePathDataStructures() throws PgqlToSqlException {
            ArrayList<QueryExpression> modConstraints;
            if (this.sourceConstraints.size() > 0) {
                QueryVertex localSource = this.getLocalSource();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Updating source constraints for local var [" + localSource + "]");
                }
                modConstraints = new ArrayList<QueryExpression>();
                for (QueryExpression qe : this.sourceConstraints) {
                    modConstraints.add(this.updateForLocalVar(qe, (QueryVariable)localSource));
                }
                this.sourceConstraints = modConstraints;
                ms_log.debug("\tUpdated source constraints:");
                for (QueryExpression v : this.sourceConstraints) {
                    ms_log.debug("\t\t" + v.toString());
                }
            }
            if (this.destConstraints.size() > 0) {
                QueryVertex localDest = this.getLocalDest();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Updating destination constraints for local var [" + localDest + "]");
                }
                modConstraints = new ArrayList();
                for (QueryExpression qe : this.destConstraints) {
                    modConstraints.add(this.updateForLocalVar(qe, (QueryVariable)localDest));
                }
                this.destConstraints = modConstraints;
                ms_log.debug("\tUpdated destination constraints:");
                for (QueryExpression v : this.destConstraints) {
                    ms_log.debug("\t\t" + v.toString());
                }
            }
            HashSet connections = new HashSet(this.queryPath.getConnections());
            HashSet nodes = new HashSet(this.queryPath.getVertices());
            ArrayList<QueryExpression> constraints = new ArrayList<QueryExpression>(this.queryPath.getConstraints());
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Populating data structures for recursive path segment");
            }
            PgqlTranslator.this.populateTraversalStructures(connections, nodes, constraints, null, this.tStruct);
            if (this.sourceID != null || this.destID != null) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Using ID constraints for achor query");
                }
                this.useAnchor = true;
            } else if (this.useSourceConstraints()) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Using source constraints for achor query");
                }
                constraints.addAll(this.sourceConstraints);
                this.useAnchor = true;
            } else if (this.useDestConstraints()) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Using destination constraints for achor query");
                }
                constraints.addAll(this.destConstraints);
                this.useAnchor = true;
            }
            if (this.useAnchor) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Populating data structures for anchor path segment");
                }
                PgqlTranslator.this.populateTraversalStructures(connections, nodes, constraints, null, this.anchorStruct);
                HashSet zConnections = new HashSet();
                HashSet<QueryVertex> zNodes = new HashSet<QueryVertex>();
                ArrayList<QueryExpression> zConstraints = new ArrayList<QueryExpression>();
                if (this.useSourceConstraints()) {
                    zNodes.add(this.getLocalSource());
                    zConstraints.addAll(this.sourceConstraints);
                } else {
                    zNodes.add(this.getLocalDest());
                    zConstraints.addAll(this.destConstraints);
                }
                PgqlTranslator.this.populateTraversalStructures(zConnections, zNodes, zConstraints, null, this.zeroStruct);
            }
        }

        private void generateBaseSQL(boolean forAnchor) throws PgqlToSqlException {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Generating path segment sql forAnchor=[" + forAnchor + "] ...");
            }
            TraversalStruct ts = this.tStruct;
            SqlQuery sq = this.sqlQuery;
            ArrayList<QueryExpression> constraints = new ArrayList<QueryExpression>(this.queryPath.getConstraints());
            if (forAnchor) {
                ts = this.anchorStruct;
                sq = this.anchorQuery;
                if (this.sourceID != null) {
                    String sourceVar = this.getLocalSource().getName();
                    List<int[]> sourceJoin = ts.getEdgeJoin(sourceVar);
                    sq.addWhereElem(PgqlTranslator.this.getAliasPfx() + sourceJoin.get(0)[0] + "." + COLS[sourceJoin.get(0)[1]] + " = " + this.sourceID);
                } else if (this.destID != null) {
                    String destVar = this.getLocalDest().getName();
                    List<int[]> destJoin = ts.getEdgeJoin(destVar);
                    sq.addWhereElem(PgqlTranslator.this.getAliasPfx() + destJoin.get(0)[0] + "." + COLS[destJoin.get(0)[1]] + " = " + this.destID);
                } else if (this.useSourceConstraints()) {
                    constraints.addAll(this.sourceConstraints);
                } else if (this.useDestConstraints()) {
                    constraints.addAll(this.destConstraints);
                }
            }
            PgqlTranslator.this.generateTraversalSQL(ts, sq, PgqlTranslator.this.sqlQuery);
            ExprContext eCtx = ExprContext.createExprContext(ts, PgqlTranslator.this.parentTStruct, PgqlTranslator.this.ctx, PgqlTranslator.this.bvInfo, PgqlTranslator.this.exprAliasMap);
            ExprTransVisitor etv = ExprTransVisitor.getExprTransVisitor(eCtx);
            ExprNavigator nav = ExprNavigator.getExprNavigator(new HashMap<String, QueryExpression>(), PgqlTranslator.this.bvInfo);
            eCtx.transMode = 0;
            for (QueryExpression qe : constraints) {
                String[] exprSQL;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nTranslating Expression:\n" + qe.toString());
                }
                if ((exprSQL = nav.accept(qe, etv).getSQL()).length == 1) {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("\nExpression SQL:\n" + exprSQL[0]);
                    }
                    sq.addWhereElem(exprSQL[0]);
                    continue;
                }
                throw new PgqlToSqlException("Unexpected number of columns in translated FILTER");
            }
            if (this.queryPath.getConnections().size() > 0) {
                String sourceVar = this.getLocalSource().getName();
                List<int[]> sourceJoin = ts.getEdgeJoin(sourceVar);
                sq.addSelectElem(new ValuePair(PgqlTranslator.this.getAliasPfx() + sourceJoin.get(0)[0] + "." + COLS[sourceJoin.get(0)[1]], "SVID"));
                String destVar = this.getLocalDest().getName();
                List<int[]> destJoin = ts.getEdgeJoin(destVar);
                sq.addSelectElem(new ValuePair(PgqlTranslator.this.getAliasPfx() + destJoin.get(0)[0] + "." + COLS[destJoin.get(0)[1]], "DVID"));
            } else {
                sq.addSelectElem(new ValuePair("0", "SVID"));
                sq.addSelectElem(new ValuePair("0", "DVID"));
                sq.addWhereElem("NULL = NULL");
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("... Done generating path segment sql");
                ms_log.debug(sq.toString());
            }
        }

        private String buildPathSQL() throws PgqlToSqlException {
            String recurSQL;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Building path SQL ...");
            }
            String sqlString = "";
            String anchorSQL = recurSQL = this.sqlQuery.buildSQLString().toString();
            if (this.useAnchor) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Using anchor to build path SQL");
                }
                anchorSQL = this.anchorQuery.buildSQLString().toString();
            }
            long minHops = this.queryPath.getMinHops();
            long maxHops = this.queryPath.getMaxHops();
            if (maxHops <= 0L && ((PgqlTranslator)PgqlTranslator.this).ctx.maxPathLen > 0) {
                maxHops = ((PgqlTranslator)PgqlTranslator.this).ctx.maxPathLen;
            }
            sqlString = minHops == 1L && maxHops == 1L ? recurSQL : (minHops == 0L && maxHops == 1L ? this.buildZeroOrOnePath(recurSQL, anchorSQL, this.sourceID, this.destID) : this.buildUnboundPath(recurSQL, anchorSQL, this.sourceID, this.destID, minHops, maxHops));
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("... Done building path SQL");
            }
            return "(/*Path[*/" + sqlString + "/*]Path*/)";
        }

        private String buildZeroOrOnePath(String recurSQL, String anchorSQL, String sourceID, String destID) {
            String zeroQuery = this.buildZeroQuery(sourceID, destID);
            String nHopWith = this.buildNhopWithBlock(recurSQL, anchorSQL, sourceID, destID, 1L);
            String zeroOrOneSql = "SELECT DISTINCT " + COLS[1] + ", " + COLS[2] + "\nFROM (\n" + nHopWith + zeroQuery + "SELECT NH." + COLS[1] + ", NH." + COLS[2] + " FROM HOP1 NH)";
            return zeroOrOneSql;
        }

        private String buildUnboundPath(String recurSQL, String anchorSQL, String sourceID, String destID, long minHops, long maxHops) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Building unbound path SQL ...");
            }
            String unboundPath = "";
            if (minHops > 1L) {
                unboundPath = this.buildRecursiveWith(recurSQL, anchorSQL, sourceID, destID, minHops, maxHops);
            } else {
                if (minHops == 0L) {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("Adding zero-length path");
                    }
                    unboundPath = this.buildZeroQuery(sourceID, destID);
                }
                unboundPath = ((PgqlTranslator)PgqlTranslator.this).ctx.useRW ? unboundPath + this.buildRecursiveWith(recurSQL, anchorSQL, sourceID, destID, minHops, maxHops) : unboundPath + this.buildConnectBy(recurSQL, sourceID, destID, maxHops);
            }
            unboundPath = "SELECT DISTINCT " + COLS[1] + ", " + COLS[2] + "\nFROM (\n" + unboundPath + ")";
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("... Done building unbound path SQL");
            }
            return unboundPath;
        }

        private String buildZeroQuery(String sourceID, String destID) {
            String zeroPath = "";
            if (sourceID != null || destID != null) {
                String stNode = "";
                String dstNode = "";
                boolean haveZeroQuery = false;
                if (sourceID != null) {
                    if (destID != null) {
                        if (sourceID.equals(destID)) {
                            stNode = sourceID;
                            dstNode = destID;
                            haveZeroQuery = true;
                        }
                    } else {
                        stNode = sourceID;
                        dstNode = sourceID;
                        haveZeroQuery = true;
                    }
                } else if (destID != null) {
                    stNode = destID;
                    dstNode = destID;
                    haveZeroQuery = true;
                }
                if (haveZeroQuery) {
                    zeroPath = "SELECT " + stNode + " AS " + COLS[1] + ", " + dstNode + " AS " + COLS[2] + "\nFROM SYS.DUAL\nWHERE EXISTS(\nSELECT 1\nFROM " + ((PgqlTranslator)PgqlTranslator.this).ctx.vtTab + "\nWHERE " + COLS[3] + " = " + stNode + ")\nUNION ALL\n";
                }
            } else if (this.useAnchor) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Building constrained zero-length path segment");
                }
                PgqlTranslator.this.generateTraversalSQL(this.zeroStruct, this.zeroQuery, PgqlTranslator.this.sqlQuery);
                ExprContext eCtx = ExprContext.createExprContext(this.zeroStruct, PgqlTranslator.this.parentTStruct, PgqlTranslator.this.ctx, PgqlTranslator.this.bvInfo, PgqlTranslator.this.exprAliasMap);
                ExprTransVisitor etv = ExprTransVisitor.getExprTransVisitor(eCtx);
                ExprNavigator nav = ExprNavigator.getExprNavigator(new HashMap<String, QueryExpression>(), PgqlTranslator.this.bvInfo);
                String zeroVar = "";
                ArrayList<QueryExpression> constraints = new ArrayList<QueryExpression>();
                if (this.useSourceConstraints()) {
                    zeroVar = this.getLocalSource().getName();
                    constraints.addAll(this.sourceConstraints);
                } else if (this.useDestConstraints()) {
                    zeroVar = this.getLocalDest().getName();
                    constraints.addAll(this.destConstraints);
                }
                eCtx.transMode = 0;
                for (QueryExpression qe : constraints) {
                    String[] exprSQL;
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("\nTranslating Expression:\n" + qe.toString());
                    }
                    if ((exprSQL = nav.accept(qe, etv).getSQL()).length == 1) {
                        if (ms_log.isDebugEnabled()) {
                            ms_log.debug("\nExpression SQL:\n" + exprSQL[0]);
                        }
                        this.zeroQuery.addWhereElem(exprSQL[0]);
                        continue;
                    }
                    throw new PgqlToSqlException("Unexpected number of columns in translated FILTER");
                }
                List<int[]> zeroJoin = this.zeroStruct.getEdgeJoin(zeroVar);
                this.zeroQuery.addSelectElem(new ValuePair(PgqlTranslator.this.getAliasPfx() + zeroJoin.get(0)[0] + "." + COLS[zeroJoin.get(0)[1]], "SVID"));
                this.zeroQuery.addSelectElem(new ValuePair(PgqlTranslator.this.getAliasPfx() + zeroJoin.get(0)[0] + "." + COLS[zeroJoin.get(0)[1]], "DVID"));
                zeroPath = this.zeroQuery.buildSQLString().toString();
                zeroPath = zeroPath + "\nUNION ALL\n";
            } else {
                zeroPath = "SELECT " + COLS[3] + " AS " + COLS[1] + ", " + COLS[3] + " AS " + COLS[2] + "\nFROM " + ((PgqlTranslator)PgqlTranslator.this).ctx.vtTab + "\nUNION ALL\n";
            }
            return zeroPath;
        }

        private String buildConnectBy(String recurSQL, String sourceID, String destID, long maxHops) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Building CONNECT BY sourceID=[" + sourceID + "] destID=[" + destID + "] maxHops=[" + maxHops + "]...");
            }
            String rootNode = COLS[1];
            String leafNode = COLS[2];
            String startWithClause = "";
            if (sourceID != null) {
                startWithClause = "START WITH " + PgqlTranslator.this.getAliasPfx() + "0." + COLS[1] + " = " + sourceID + "\n";
            } else if (destID != null) {
                rootNode = COLS[2];
                leafNode = COLS[1];
                startWithClause = "START WITH " + PgqlTranslator.this.getAliasPfx() + "0." + COLS[2] + " = " + destID + "\n";
            }
            String lenLimit = "";
            if (maxHops > 0L) {
                lenLimit = " AND LEVEL <= " + maxHops;
            }
            String connectBy = "SELECT " + COLS[1] + ", " + COLS[2] + "\nFROM\n(SELECT CONNECT_BY_ROOT " + PgqlTranslator.this.getAliasPfx() + "0." + rootNode + " AS " + rootNode + ", " + PgqlTranslator.this.getAliasPfx() + "0." + leafNode + " AS " + leafNode + "\nFROM(\n" + recurSQL + ") " + PgqlTranslator.this.getAliasPfx() + "0\n" + startWithClause + "CONNECT BY NOCYCLE PRIOR " + leafNode + " = " + rootNode + lenLimit + ")";
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("... Done building CONNECT BY");
            }
            return connectBy;
        }

        private String buildRecursiveWith(String recurSQL, String anchorSQL, String sourceID, String destID, long minHops, long maxHops) {
            long maxLen;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Building RECURSIVE WITH sourceID=[" + sourceID + "] destID=[" + destID + "] minHops=[" + minHops + "] maxHops=[" + maxHops + "]...");
            }
            String rootNode = COLS[1];
            String leafNode = COLS[2];
            if (this.shouldReverseRW()) {
                rootNode = COLS[2];
                leafNode = COLS[1];
            }
            String distinct = "";
            if (((PgqlTranslator)PgqlTranslator.this).ctx.useDistRW) {
                distinct = "DISTINCT ";
            }
            boolean unbound = (maxLen = maxHops) <= 0L;
            long moreHops = maxLen;
            String nHopWith = "";
            if (minHops > 1L) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Building N-hop WITH [" + minHops + "] hops ...");
                }
                nHopWith = this.buildNhopWithBlock(recurSQL, anchorSQL, sourceID, destID, minHops);
                anchorSQL = "SELECT NH." + COLS[1] + ", NH." + COLS[2] + " FROM HOP" + minHops + " NH";
                moreHops = maxLen - minHops + 1L;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("... Done building N-hop WITH [" + minHops + "] hops ...");
                }
            }
            String recursiveWith = "";
            if (!unbound) {
                if (moreHops <= 1L) {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("No more hops ... using plain join query");
                    }
                    recursiveWith = nHopWith + "SELECT " + COLS[1] + ", " + COLS[2] + "\nFROM (" + anchorSQL + ")\n";
                } else {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("[" + moreHops + "] more hops needed ... using RW");
                    }
                    String innerLenLimit = " AND RW.LVL <= " + moreHops;
                    String lenLimit = " WHERE LVL <= " + moreHops;
                    recursiveWith = nHopWith + "SELECT " + COLS[1] + "," + COLS[2] + " FROM\n(WITH RW (ROOT, " + leafNode + ", LVL) AS\n( SELECT ROOT, " + leafNode + ",  LVL FROM\n(SELECT " + rootNode + " ROOT, " + leafNode + ", 1 LVL\nFROM (" + anchorSQL + ")\n) UNION ALL\nSELECT " + distinct + "RW.ROOT, R." + leafNode + ", RW.LVL+1\nFROM (" + recurSQL + ") R, RW\nWHERE RW." + leafNode + " = R." + rootNode + innerLenLimit + " )\nCYCLE " + leafNode + " SET cycle_col TO 1 DEFAULT 0\nSELECT ROOT " + rootNode + ", " + leafNode + " FROM RW" + lenLimit + ")";
                }
            } else {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("No max length constraint ... using unbounded RW");
                }
                recursiveWith = nHopWith + "SELECT " + COLS[1] + "," + COLS[2] + " FROM\n(WITH RW (ROOT, " + leafNode + ") AS\n( SELECT ROOT, " + leafNode + " FROM\n(SELECT " + rootNode + " ROOT, " + leafNode + "\nFROM (" + anchorSQL + ")\n) UNION ALL\nSELECT " + distinct + "RW.ROOT, R." + leafNode + "\nFROM (" + recurSQL + ") R, RW\nWHERE RW." + leafNode + " = R." + rootNode + " )\nCYCLE " + leafNode + " SET cycle_col TO 1 DEFAULT 0\nSELECT ROOT " + rootNode + ", " + leafNode + " FROM RW)";
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("... Done Building RECURSIVE WITH");
            }
            return recursiveWith;
        }

        private String buildNhopWithBlock(String recurSQL, String anchorSQL, String sourceID, String destID, long numHops) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Building Nhop Block sourceID=[" + sourceID + "] destID=[" + destID + "] numHops=[" + numHops + "] ...");
            }
            String rootNode = COLS[1];
            String leafNode = COLS[2];
            if (this.shouldReverseRW()) {
                rootNode = COLS[2];
                leafNode = COLS[1];
            }
            StringBuffer nHop = new StringBuffer("WITH ");
            nHop.append("HOP1 AS\n").append("(SELECT DISTINCT " + rootNode + ", " + leafNode + "\nFROM (" + anchorSQL + ")\n)\n");
            int i = 2;
            while ((long)i <= numHops) {
                nHop.append(", HOP" + i + " AS\n").append("(SELECT DISTINCT PREV." + rootNode + ", NEXT." + leafNode + "\nFROM (" + recurSQL + ") NEXT, HOP" + (i - 1) + " PREV\nWHERE PREV." + leafNode + " = NEXT." + rootNode + ")\n");
                ++i;
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("... Done Building Nhop Block");
            }
            return nHop.toString();
        }

        private QueryExpression updateForLocalVar(QueryExpression qe, QueryVariable localVar) throws PgqlToSqlException {
            QueryExpression.ExpressionType exprType = qe.getExpType();
            switch (exprType) {
                case INTEGER: 
                case DECIMAL: 
                case STRING: 
                case BOOLEAN: 
                case STAR: 
                case BIND_VARIABLE: 
                case DATE: 
                case TIME: 
                case TIMESTAMP: 
                case TIME_WITH_TIMEZONE: 
                case TIMESTAMP_WITH_TIMEZONE: {
                    return qe;
                }
                case PROP_ACCESS: {
                    return new QueryExpression.PropertyAccess(localVar, ((QueryExpression.PropertyAccess)qe).getPropertyName());
                }
                case VARREF: {
                    return new QueryExpression.VarRef(localVar);
                }
                case SUB: 
                case ADD: 
                case MUL: 
                case DIV: 
                case MOD: 
                case AND: 
                case OR: 
                case EQUAL: 
                case NOT_EQUAL: 
                case GREATER: 
                case GREATER_EQUAL: 
                case LESS: 
                case LESS_EQUAL: {
                    QueryExpression.BinaryExpression be = (QueryExpression.BinaryExpression)qe;
                    QueryExpression c1 = this.updateForLocalVar(be.getExp1(), localVar);
                    QueryExpression c2 = this.updateForLocalVar(be.getExp2(), localVar);
                    if (exprType == QueryExpression.ExpressionType.SUB) {
                        return new QueryExpression.ArithmeticExpression.Sub(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.ADD) {
                        return new QueryExpression.ArithmeticExpression.Add(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.MUL) {
                        return new QueryExpression.ArithmeticExpression.Mul(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.DIV) {
                        return new QueryExpression.ArithmeticExpression.Div(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.MOD) {
                        return new QueryExpression.ArithmeticExpression.Mod(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.AND) {
                        return new QueryExpression.LogicalExpression.And(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.OR) {
                        return new QueryExpression.LogicalExpression.Or(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.EQUAL) {
                        return new QueryExpression.RelationalExpression.Equal(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.NOT_EQUAL) {
                        return new QueryExpression.RelationalExpression.NotEqual(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.GREATER) {
                        return new QueryExpression.RelationalExpression.Greater(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.GREATER_EQUAL) {
                        return new QueryExpression.RelationalExpression.GreaterEqual(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.LESS) {
                        return new QueryExpression.RelationalExpression.Less(c1, c2);
                    }
                    if (exprType == QueryExpression.ExpressionType.LESS_EQUAL) {
                        return new QueryExpression.RelationalExpression.LessEqual(c1, c2);
                    }
                    throw new PgqlToSqlException(PgqlTranslator.UNSUPPORTED_PATH_TYPE + exprType);
                }
                case CAST: {
                    QueryExpression.Function.Cast c = (QueryExpression.Function.Cast)qe;
                    QueryExpression c1 = this.updateForLocalVar(c.getExp(), localVar);
                    return new QueryExpression.Function.Cast(c1, c.getTargetTypeName());
                }
                case SIMPLE_CASE: {
                    QueryExpression.SimpleCase sc = (QueryExpression.SimpleCase)qe;
                    return this.updateForLocalVar((QueryExpression)sc.getIfElseRepresentation(), localVar);
                }
                case IF_ELSE: {
                    QueryExpression.IfElse ie = (QueryExpression.IfElse)qe;
                    QueryExpression c1 = this.updateForLocalVar(ie.getExp1(), localVar);
                    QueryExpression c2 = this.updateForLocalVar(ie.getExp2(), localVar);
                    QueryExpression c3 = this.updateForLocalVar(ie.getExp3(), localVar);
                    return new QueryExpression.IfElse(c1, c2, c3);
                }
                case EXTRACT_EXPRESSION: {
                    QueryExpression.ExtractExpression e = (QueryExpression.ExtractExpression)qe;
                    QueryExpression c1 = this.updateForLocalVar(e.getExp(), localVar);
                    return new QueryExpression.ExtractExpression(e.getField(), c1);
                }
                case IN_EXPRESSION: {
                    QueryExpression.InPredicate inp = (QueryExpression.InPredicate)qe;
                    QueryExpression c1 = this.updateForLocalVar(inp.getExp(), localVar);
                    return new QueryExpression.InPredicate(c1, inp.getInValueList());
                }
                case IS_NULL: {
                    QueryExpression.IsNull in = (QueryExpression.IsNull)qe;
                    QueryExpression c1 = this.updateForLocalVar(in.getExp(), localVar);
                    return new QueryExpression.IsNull(c1);
                }
                case FUNCTION_CALL: {
                    QueryExpression.FunctionCall fc = (QueryExpression.FunctionCall)qe;
                    List exps = fc.getArgs();
                    int numExps = exps.size();
                    ArrayList<QueryExpression> tExps = new ArrayList<QueryExpression>(numExps);
                    for (int i = 0; i < numExps; ++i) {
                        tExps.add(this.updateForLocalVar((QueryExpression)exps.get(i), localVar));
                    }
                    return new QueryExpression.FunctionCall(fc.getPackageName(), fc.getFunctionName(), tExps);
                }
                case NOT: 
                case UMIN: 
                case AGGR_COUNT: 
                case AGGR_MIN: 
                case AGGR_MAX: 
                case AGGR_SUM: 
                case AGGR_AVG: {
                    QueryExpression.UnaryExpression ue = (QueryExpression.UnaryExpression)qe;
                    QueryExpression c1 = this.updateForLocalVar(ue.getExp(), localVar);
                    if (exprType == QueryExpression.ExpressionType.UMIN) {
                        return new QueryExpression.ArithmeticExpression.UMin(c1);
                    }
                    if (exprType == QueryExpression.ExpressionType.NOT) {
                        return new QueryExpression.LogicalExpression.Not(c1);
                    }
                    if (exprType == QueryExpression.ExpressionType.AGGR_COUNT) {
                        return new QueryExpression.Aggregation.AggrCount(((QueryExpression.Aggregation.AggrCount)ue).isDistinct(), c1);
                    }
                    if (exprType == QueryExpression.ExpressionType.AGGR_MIN) {
                        return new QueryExpression.Aggregation.AggrMin(((QueryExpression.Aggregation.AggrMin)ue).isDistinct(), c1);
                    }
                    if (exprType == QueryExpression.ExpressionType.AGGR_MAX) {
                        return new QueryExpression.Aggregation.AggrMax(((QueryExpression.Aggregation.AggrMax)ue).isDistinct(), c1);
                    }
                    if (exprType == QueryExpression.ExpressionType.AGGR_SUM) {
                        return new QueryExpression.Aggregation.AggrSum(((QueryExpression.Aggregation.AggrSum)ue).isDistinct(), c1);
                    }
                    if (exprType == QueryExpression.ExpressionType.AGGR_AVG) {
                        return new QueryExpression.Aggregation.AggrAvg(((QueryExpression.Aggregation.AggrAvg)ue).isDistinct(), c1);
                    }
                    throw new PgqlToSqlException(PgqlTranslator.UNSUPPORTED_PATH_TYPE + exprType);
                }
                case EXISTS: 
                case SCALAR_SUBQUERY: {
                    return qe;
                }
            }
            throw new PgqlToSqlException(PgqlTranslator.UNSUPPORTED_PATH_TYPE + qe.getExpType());
        }
    }
}

