/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgnative;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pgql.lang.ir.Direction;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.GroupBy;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.VertexPairConnection;

public class PgNativeQueryTranslator {
    private static final String JAVA_DATETIME_FMT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String JAVA_DATETIME_TZ_FMT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final String DATETIME_TZ_FMT = "'SYYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM'";

    public static String translateQuery(GraphQuery gq) {
        SelectQuery select = (SelectQuery)gq;
        Set vertexPairConnections = select.getGraphPattern().getConnections();
        Set queryVertices = select.getGraphPattern().getVertices();
        HashSet<QueryExpression> labelExpressions = new HashSet<QueryExpression>();
        HashSet whereElements = new HashSet();
        select.getGraphPattern().getConstraints().stream().forEach(e -> {
            QueryExpression.FunctionCall fc;
            if (e.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && (fc = (QueryExpression.FunctionCall)e).getPackageName() == null && fc.getFunctionName().equalsIgnoreCase("has_label")) {
                labelExpressions.add((QueryExpression)e);
                return;
            }
            whereElements.add(e);
        });
        ArrayList<String> paths = new ArrayList<String>();
        HashSet<QueryVertex> matchedVertices = new HashSet<QueryVertex>();
        String path = "";
        for (VertexPairConnection vpc : vertexPairConnections) {
            if (vpc instanceof QueryPath) {
                throw new UnsupportedOperationException("Variable length paths are not supported in PG_Native");
            }
            path = "";
            QueryVertex src = vpc.getSrc();
            QueryVertex dst = vpc.getDst();
            path = path + PgNativeQueryTranslator.getPathForVertex((QueryVariable)src, labelExpressions, true);
            path = path + "-";
            path = path + PgNativeQueryTranslator.getPathForVertex((QueryVariable)vpc, labelExpressions, false);
            path = path + (vpc.getDirection() == Direction.ANY ? "-" : "->");
            path = path + PgNativeQueryTranslator.getPathForVertex((QueryVariable)dst, labelExpressions, true);
            paths.add(path);
            matchedVertices.add(src);
            matchedVertices.add(dst);
        }
        for (QueryVertex v : queryVertices) {
            if (matchedVertices.contains(v)) continue;
            paths.add(PgNativeQueryTranslator.getPathForVertex((QueryVariable)v, labelExpressions, true));
        }
        List projectionElements = select.getProjection().getElements();
        HashSet<String> columnsElement = new HashSet<String>();
        ArrayList<String> selectElements = new ArrayList<String>();
        ArrayList<String> selectColumn = new ArrayList<String>();
        for (Object expAsVar : projectionElements) {
            selectElements.add(PgNativeQueryTranslator.translateExpression(PgNativeQueryTranslator.tryToDereference(expAsVar.getExp()), selectColumn, true) + " AS " + PgqlUtils.printIdentifier((String)expAsVar.getName()));
        }
        columnsElement.addAll(selectColumn);
        ArrayList<String> whereElementsVisited = new ArrayList<String>();
        for (QueryExpression qe : whereElements) {
            whereElementsVisited.add(PgNativeQueryTranslator.translateExpression(qe, null, false));
        }
        GroupBy gp = select.getGroupBy();
        List gpElements = gp == null ? new ArrayList() : gp.getElements();
        ArrayList<String> gpColumn = new ArrayList<String>();
        ArrayList<String> groupByElements = new ArrayList<String>();
        for (ExpAsVar expAsVar : gpElements) {
            groupByElements.add(PgNativeQueryTranslator.translateExpression(PgNativeQueryTranslator.tryToDereference(expAsVar.getExp()), gpColumn, true));
        }
        columnsElement.addAll(gpColumn);
        QueryExpression having = select.getHaving();
        ArrayList<String> havingcol = new ArrayList<String>();
        String sqlHaving = having == null ? null : PgNativeQueryTranslator.translateExpression(having, havingcol, true);
        columnsElement.addAll(havingcol);
        List orderByElems = select.getOrderBy().getElements();
        ArrayList<String> orderByElements = new ArrayList<String>();
        ArrayList<String> orderByColumn = new ArrayList<String>();
        for (OrderByElem orderByElem : orderByElems) {
            orderByElements.add(PgNativeQueryTranslator.translateExpression(PgNativeQueryTranslator.tryToDereference(orderByElem.getExp()), orderByColumn, true) + (orderByElem.isAscending() ? " ASC" : " DESC"));
        }
        columnsElement.addAll(orderByColumn);
        String sqlQuery = "SELECT " + (select.getProjection().isDistinct() ? "DISTINCT " : "") + String.join((CharSequence)", ", selectElements);
        sqlQuery = sqlQuery + " FROM GRAPH_TABLE( " + PgqlUtils.printIdentifier((String)select.getGraphName().getName());
        sqlQuery = sqlQuery + " MATCH " + String.join((CharSequence)", ", paths);
        if (whereElementsVisited.size() > 0) {
            sqlQuery = sqlQuery + " WHERE " + String.join((CharSequence)" and ", whereElementsVisited);
        }
        sqlQuery = sqlQuery + " COLUMNS( " + String.join((CharSequence)", ", columnsElement) + "))";
        if (groupByElements.size() > 0) {
            sqlQuery = sqlQuery + " GROUP BY " + String.join((CharSequence)", ", groupByElements);
        }
        if (sqlHaving != null) {
            sqlQuery = sqlQuery + " HAVING " + sqlHaving;
        }
        if (orderByElements.size() > 0) {
            sqlQuery = sqlQuery + " ORDER BY " + String.join((CharSequence)", ", orderByElements);
        }
        if (select.getOffset() != null) {
            sqlQuery = sqlQuery + PgNativeQueryTranslator.getLimitOffset(select.getOffset(), false);
        }
        if (select.getLimit() != null) {
            sqlQuery = sqlQuery + PgNativeQueryTranslator.getLimitOffset(select.getLimit(), true);
        }
        return sqlQuery;
    }

    public static String getLimitOffset(QueryExpression qe, boolean isLimit) {
        switch (qe.getExpType()) {
            case INTEGER: {
                return isLimit ? " FETCH FIRST " + ((QueryExpression.Constant.ConstInteger)qe).getValue() + " ROWS ONLY" : " OFFSET " + ((QueryExpression.Constant.ConstInteger)qe).getValue() + " ROWS";
            }
            case BIND_VARIABLE: {
                return isLimit ? " FETCH FIRST ? ROWS ONLY" : " OFFSET ? ROWS";
            }
        }
        throw new UnsupportedOperationException(qe.getExpType() + " is not supported in " + (isLimit ? "LIMIT" : "OFFSET") + " clause");
    }

    public static String getVertexLabel(String var, Set<QueryExpression> queryExpressions) throws PgqlToSqlException {
        for (QueryExpression qe : queryExpressions) {
            QueryExpression.FunctionCall fc = (QueryExpression.FunctionCall)qe;
            if (!var.equalsIgnoreCase(((QueryExpression.VarRef)fc.getArgs().get(0)).getVariable().getName())) continue;
            return (String)((QueryExpression.Constant.ConstString)fc.getArgs().get(1)).getValue();
        }
        return null;
    }

    public static String getPathForVertex(QueryVariable v, Set<QueryExpression> qe, boolean isVertex) {
        String label;
        String path;
        String string = path = isVertex ? "(" : "[";
        if (!v.isAnonymous()) {
            path = path + v.getName();
        }
        if ((label = PgNativeQueryTranslator.getVertexLabel(v.getName(), qe)) != null) {
            path = path + " IS " + PgqlUtils.printIdentifier((String)label);
        }
        path = path + (isVertex ? ")" : "]");
        return path;
    }

    private static QueryExpression tryToDereference(QueryExpression exp) {
        if (exp.getExpType() == QueryExpression.ExpressionType.VARREF) {
            QueryExpression.VarRef varRef = (QueryExpression.VarRef)exp;
            if (varRef.getVariable().getVariableType() == QueryVariable.VariableType.EXP_AS_VAR) {
                ExpAsVar expAsVar = (ExpAsVar)varRef.getVariable();
                return expAsVar.getExp();
            }
            throw new UnsupportedOperationException(varRef.getVariable().getVariableType() + " Cannot be projected in COLUMNS clause");
        }
        return exp;
    }

    public static String translateExpression(QueryExpression qe, List<String> columnElem, boolean isColumn) {
        QueryExpression.ExpressionType expType = qe.getExpType();
        switch (expType) {
            case INTEGER: {
                return String.valueOf(((QueryExpression.Constant.ConstInteger)qe).getValue());
            }
            case STRING: {
                return PgqlUtils.printLiteral((String)((String)((QueryExpression.Constant.ConstString)qe).getValue()));
            }
            case DECIMAL: {
                return String.valueOf(((QueryExpression.Constant.ConstDecimal)qe).getValue());
            }
            case DATE: {
                return "DATE '" + ((LocalDate)((QueryExpression.Constant.ConstDate)qe).getValue()).toString() + "'";
            }
            case TIME: {
                return "TIME '" + ((LocalTime)((QueryExpression.Constant.ConstTime)qe).getValue()).toString() + "'";
            }
            case TIME_WITH_TIMEZONE: {
                return "TIME '" + ((OffsetTime)((QueryExpression.Constant.ConstTimeWithTimezone)qe).getValue()).toString() + "'";
            }
            case TIMESTAMP: {
                LocalDateTime ts = (LocalDateTime)((QueryExpression.Constant.ConstTimestamp)qe).getValue();
                ZoneId tsz = ZoneId.systemDefault();
                OffsetDateTime tsodt = ts.atOffset(tsz.getRules().getOffset(ts));
                String tsdate = tsodt.format(DateTimeFormatter.ofPattern(JAVA_DATETIME_FMT));
                return "TO_TIMESTAMP_TZ('" + tsdate + "', " + DATETIME_TZ_FMT + ")";
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                OffsetDateTime tsodt = (OffsetDateTime)((QueryExpression.Constant.ConstTimestampWithTimezone)qe).getValue();
                String tsdate = tsodt.format(DateTimeFormatter.ofPattern(JAVA_DATETIME_FMT));
                return "TO_TIMESTAMP_TZ('" + tsdate + "', " + DATETIME_TZ_FMT + ")";
            }
            case PROP_ACCESS: {
                QueryExpression.PropertyAccess pa = (QueryExpression.PropertyAccess)qe;
                if (isColumn) {
                    columnElem.add(PgqlUtils.printIdentifier((String)pa.getVariable().getName()) + "." + PgqlUtils.printIdentifier((String)pa.getPropertyName()) + " AS " + PgqlUtils.printIdentifier((String)pa.toString()));
                    return PgqlUtils.printIdentifier((String)pa.toString());
                }
                return PgqlUtils.printIdentifier((String)pa.getVariable().getName()) + "." + PgqlUtils.printIdentifier((String)pa.getPropertyName());
            }
            case GREATER: {
                QueryExpression.RelationalExpression.Greater gr = (QueryExpression.RelationalExpression.Greater)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(gr.getExp1(), columnElem, isColumn) + " > " + PgNativeQueryTranslator.translateExpression(gr.getExp2(), columnElem, isColumn) + ")";
            }
            case GREATER_EQUAL: {
                QueryExpression.RelationalExpression.GreaterEqual gre = (QueryExpression.RelationalExpression.GreaterEqual)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(gre.getExp1(), columnElem, isColumn) + " >= " + PgNativeQueryTranslator.translateExpression(gre.getExp2(), columnElem, isColumn) + ")";
            }
            case LESS: {
                QueryExpression.RelationalExpression.Less le = (QueryExpression.RelationalExpression.Less)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(le.getExp1(), columnElem, isColumn) + " < " + PgNativeQueryTranslator.translateExpression(le.getExp2(), columnElem, isColumn) + ")";
            }
            case LESS_EQUAL: {
                QueryExpression.RelationalExpression.LessEqual lee = (QueryExpression.RelationalExpression.LessEqual)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(lee.getExp1(), columnElem, isColumn) + " <= " + PgNativeQueryTranslator.translateExpression(lee.getExp2(), columnElem, isColumn) + ")";
            }
            case SUB: {
                QueryExpression.ArithmeticExpression.Sub sub = (QueryExpression.ArithmeticExpression.Sub)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(sub.getExp1(), columnElem, isColumn) + " - " + PgNativeQueryTranslator.translateExpression(sub.getExp2(), columnElem, isColumn) + ")";
            }
            case ADD: {
                QueryExpression.ArithmeticExpression.Add add = (QueryExpression.ArithmeticExpression.Add)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(add.getExp1(), columnElem, isColumn) + " + " + PgNativeQueryTranslator.translateExpression(add.getExp2(), columnElem, isColumn) + ")";
            }
            case MUL: {
                QueryExpression.ArithmeticExpression.Mul mul = (QueryExpression.ArithmeticExpression.Mul)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(mul.getExp1(), columnElem, isColumn) + " * " + PgNativeQueryTranslator.translateExpression(mul.getExp2(), columnElem, isColumn) + ")";
            }
            case DIV: {
                QueryExpression.ArithmeticExpression.Div div = (QueryExpression.ArithmeticExpression.Div)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(div.getExp1(), columnElem, isColumn) + " / " + PgNativeQueryTranslator.translateExpression(div.getExp2(), columnElem, isColumn) + ")";
            }
            case MOD: {
                QueryExpression.ArithmeticExpression.Mod mod = (QueryExpression.ArithmeticExpression.Mod)qe;
                return "(MOD(" + PgNativeQueryTranslator.translateExpression(mod.getExp1(), columnElem, isColumn) + ", " + PgNativeQueryTranslator.translateExpression(mod.getExp2(), columnElem, isColumn) + "))";
            }
            case UMIN: {
                QueryExpression.ArithmeticExpression.UMin umin = (QueryExpression.ArithmeticExpression.UMin)qe;
                return "-(" + PgNativeQueryTranslator.translateExpression(umin.getExp(), columnElem, isColumn) + ")";
            }
            case AND: {
                QueryExpression.LogicalExpression.And and = (QueryExpression.LogicalExpression.And)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(and.getExp1(), columnElem, isColumn) + " AND " + PgNativeQueryTranslator.translateExpression(and.getExp2(), columnElem, isColumn) + ")";
            }
            case OR: {
                QueryExpression.LogicalExpression.Or or = (QueryExpression.LogicalExpression.Or)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(or.getExp1(), columnElem, isColumn) + " OR " + PgNativeQueryTranslator.translateExpression(or.getExp2(), columnElem, isColumn) + ")";
            }
            case NOT: {
                QueryExpression.LogicalExpression.Not not = (QueryExpression.LogicalExpression.Not)qe;
                return "NOT (" + PgNativeQueryTranslator.translateExpression(not.getExp(), columnElem, isColumn) + ")";
            }
            case EQUAL: {
                QueryExpression.RelationalExpression.Equal eq = (QueryExpression.RelationalExpression.Equal)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(eq.getExp1(), columnElem, isColumn) + " = " + PgNativeQueryTranslator.translateExpression(eq.getExp2(), columnElem, isColumn) + ")";
            }
            case NOT_EQUAL: {
                QueryExpression.RelationalExpression.NotEqual neq = (QueryExpression.RelationalExpression.NotEqual)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(neq.getExp1(), columnElem, isColumn) + " <> " + PgNativeQueryTranslator.translateExpression(neq.getExp2(), columnElem, isColumn) + ")";
            }
            case CONCAT: {
                QueryExpression.ConcatExpression concat = (QueryExpression.ConcatExpression)qe;
                return "(" + PgNativeQueryTranslator.translateExpression(concat.getExp1(), columnElem, isColumn) + " || " + PgNativeQueryTranslator.translateExpression(concat.getExp2(), columnElem, isColumn) + ")";
            }
            case AGGR_COUNT: {
                QueryExpression.Aggregation.AggrCount aggrCount = (QueryExpression.Aggregation.AggrCount)qe;
                return "COUNT(" + (aggrCount.isDistinct() ? "DISTINCT " : "") + PgNativeQueryTranslator.translateExpression(aggrCount.getExp(), columnElem, isColumn) + ")";
            }
            case AGGR_MIN: {
                QueryExpression.Aggregation.AggrMin aggrMin = (QueryExpression.Aggregation.AggrMin)qe;
                return "MIN(" + (aggrMin.isDistinct() ? "DISTINCT " : "") + PgNativeQueryTranslator.translateExpression(aggrMin.getExp(), columnElem, isColumn) + ")";
            }
            case AGGR_MAX: {
                QueryExpression.Aggregation.AggrMax aggrMax = (QueryExpression.Aggregation.AggrMax)qe;
                return "MAX(" + (aggrMax.isDistinct() ? "DISTINCT " : "") + PgNativeQueryTranslator.translateExpression(aggrMax.getExp(), columnElem, isColumn) + ")";
            }
            case AGGR_SUM: {
                QueryExpression.Aggregation.AggrSum aggrSum = (QueryExpression.Aggregation.AggrSum)qe;
                return "SUM(" + (aggrSum.isDistinct() ? "DISTINCT " : "") + PgNativeQueryTranslator.translateExpression(aggrSum.getExp(), columnElem, isColumn) + ")";
            }
            case AGGR_AVG: {
                QueryExpression.Aggregation.AggrAvg aggrAvg = (QueryExpression.Aggregation.AggrAvg)qe;
                return "AVG(" + (aggrAvg.isDistinct() ? "DISTINCT " : "") + PgNativeQueryTranslator.translateExpression(aggrAvg.getExp(), columnElem, isColumn) + ")";
            }
            case AGGR_LISTAGG: {
                QueryExpression.Aggregation.AggrListagg aggrListagg = (QueryExpression.Aggregation.AggrListagg)qe;
                String rslt = "LISTAGG(" + (aggrListagg.isDistinct() ? "DISTINCT " : "") + PgNativeQueryTranslator.translateExpression(aggrListagg.getExp(), columnElem, isColumn);
                if (aggrListagg.getSeparator() != null) {
                    rslt = rslt + ", " + PgqlUtils.printLiteral((String)aggrListagg.getSeparator());
                }
                rslt = rslt + ")";
                return rslt;
            }
            case VARREF: {
                QueryExpression.VarRef varRef = (QueryExpression.VarRef)qe;
                return PgNativeQueryTranslator.translateExpression(PgNativeQueryTranslator.tryToDereference((QueryExpression)varRef), columnElem, isColumn);
            }
            case BIND_VARIABLE: {
                return "?";
            }
            case STAR: {
                return "(*)";
            }
            case SCALAR_SUBQUERY: {
                return "( " + PgNativeQueryTranslator.translateQuery((GraphQuery)((QueryExpression.ScalarSubquery)qe).getQuery()) + " )";
            }
            case CAST: {
                QueryExpression.Function.Cast cast = (QueryExpression.Function.Cast)qe;
                String normalizedType = cast.getTargetTypeName().replace("TIMEZONE", "TIME ZONE");
                return "CAST(" + PgNativeQueryTranslator.translateExpression(cast.getExp(), columnElem, isColumn) + " AS " + normalizedType + ")";
            }
            case EXISTS: {
                return "EXISTS ( " + PgNativeQueryTranslator.translateQuery((GraphQuery)((QueryExpression.Function.Exists)qe).getQuery()) + " )";
            }
            case FUNCTION_CALL: {
                QueryExpression.FunctionCall functionCall = (QueryExpression.FunctionCall)qe;
                String expressions = functionCall.getArgs().stream().map(e -> PgNativeQueryTranslator.translateExpression(e, columnElem, isColumn)).collect(Collectors.joining(", "));
                String packageNamePart = functionCall.getPackageName() == null ? "" : functionCall.getPackageName() + ".";
                return packageNamePart + functionCall.getFunctionName() + "(" + expressions + ")";
            }
            case EXTRACT_EXPRESSION: {
                QueryExpression.ExtractExpression extractExpression = (QueryExpression.ExtractExpression)qe;
                return "EXTRACT(" + extractExpression.getField().name() + " FROM " + PgNativeQueryTranslator.translateExpression(extractExpression.getExp(), columnElem, isColumn) + ")";
            }
            case IN_EXPRESSION: {
                QueryExpression.InPredicate ip = (QueryExpression.InPredicate)qe;
                return PgNativeQueryTranslator.translateExpression(ip.getExp(), columnElem, isColumn) + " IN " + PgNativeQueryTranslator.translateExpression(ip.getInValueList(), columnElem, isColumn);
            }
            case IN_VALUE_LIST: {
                QueryExpression.InPredicate.InValueList ivl = (QueryExpression.InPredicate.InValueList)qe;
                QueryExpression.ExpressionType arrayType = ivl.getArrayElementType();
                String str_ivl = "";
                switch (arrayType) {
                    case INTEGER: {
                        str_ivl = Arrays.stream(ivl.getIntegerValues()).mapToObj(val -> String.valueOf(val)).collect(Collectors.joining(", ", "( ", " )"));
                        break;
                    }
                    case DECIMAL: {
                        str_ivl = Arrays.stream(ivl.getDecimalValues()).mapToObj(val -> String.valueOf(val)).collect(Collectors.joining(", ", "( ", " )"));
                        break;
                    }
                    case DATE: {
                        str_ivl = Arrays.stream(ivl.getDateValues()).map(ld -> {
                            String datetimeStr = ld.atStartOfDay(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(JAVA_DATETIME_TZ_FMT));
                            return "TO_TIMESTAMP_TZ('" + datetimeStr + "', " + DATETIME_TZ_FMT + ")";
                        }).collect(Collectors.joining(", ", "( ", " )"));
                        break;
                    }
                    case TIMESTAMP: {
                        str_ivl = Arrays.stream(ivl.getTimestampValues()).map(ldt -> {
                            ZoneId zone = ZoneId.systemDefault();
                            OffsetDateTime odt = ldt.atOffset(zone.getRules().getOffset((LocalDateTime)ldt));
                            String datetimeStr = odt.format(DateTimeFormatter.ofPattern(JAVA_DATETIME_FMT));
                            return "TO_TIMESTAMP_TZ('" + datetimeStr + "', " + DATETIME_TZ_FMT + ")";
                        }).collect(Collectors.joining(", ", "( ", " )"));
                        break;
                    }
                    case STRING: {
                        str_ivl = Arrays.stream(ivl.getStringValues()).map(str -> PgqlUtils.printLiteral((String)str)).collect(Collectors.joining(", ", "( ", " )"));
                    }
                }
                return str_ivl;
            }
            case IS_NULL: {
                QueryExpression.IsNull isNull = (QueryExpression.IsNull)qe;
                return PgNativeQueryTranslator.translateExpression(isNull.getExp(), columnElem, isColumn) + " IS NULL";
            }
            case IF_ELSE: {
                QueryExpression.IfElse ifElse = (QueryExpression.IfElse)qe;
                String elseClause = "";
                if (ifElse.getExp3() != null) {
                    elseClause = elseClause + " ELSE " + PgNativeQueryTranslator.translateExpression(ifElse.getExp3(), columnElem, isColumn);
                }
                return "CASE WHEN " + PgNativeQueryTranslator.translateExpression(ifElse.getExp1(), columnElem, isColumn) + " THEN " + PgNativeQueryTranslator.translateExpression(ifElse.getExp2(), columnElem, isColumn) + elseClause + " END";
            }
            case SIMPLE_CASE: {
                QueryExpression.SimpleCase simpleCase = (QueryExpression.SimpleCase)qe;
                String result = "CASE " + PgNativeQueryTranslator.translateExpression(simpleCase.getCaseOperand(), columnElem, isColumn) + " ";
                result = result + simpleCase.getWhenThenExps().stream().map(x -> "WHEN " + PgNativeQueryTranslator.translateExpression(x.getWhen(), columnElem, isColumn) + " THEN " + PgNativeQueryTranslator.translateExpression(x.getThen(), columnElem, isColumn)).collect(Collectors.joining(" "));
                if (simpleCase.getElseExp() != null) {
                    result = result + " ELSE " + PgNativeQueryTranslator.translateExpression(simpleCase.getElseExp(), columnElem, isColumn);
                }
                result = result + " END";
                return result;
            }
            case SUBSTRING: {
                QueryExpression.SubstringExpression substring = (QueryExpression.SubstringExpression)qe;
                String res = "SUBSTR(" + PgNativeQueryTranslator.translateExpression(substring.getExp(), columnElem, isColumn) + ", " + PgNativeQueryTranslator.translateExpression(substring.getStartPosition(), columnElem, isColumn);
                if (substring.getStringLength() != null) {
                    res = res + ", " + PgNativeQueryTranslator.translateExpression(substring.getStringLength(), columnElem, isColumn);
                }
                res = res + ")";
                return res;
            }
        }
        throw new IllegalArgumentException("Unsupported expression " + qe.getExpType());
    }
}

