/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlStatement;
import oracle.pgql.lang.PgqlException;

public class GraphMetadataHandler {
    static final String createGraphStatement = "CREATE PROPERTY GRAPH PROPERTY_GRAPH_METADATA VERTEX TABLES (   temp_property_graphs AS property_graph    KEY(owner, graph_name)    PROPERTIES ARE ALL COLUMNS,  temp_vertex_tables AS vertex_table     KEY(owner, graph_name, vertex_table_alias)    PROPERTIES ARE ALL COLUMNS EXCEPT(owner, graph_name),  temp_edge_tables AS edge_table    KEY(owner, graph_name, edge_table_alias)    PROPERTIES ARE ALL COLUMNS EXCEPT(owner, graph_name, source_table_alias, destination_table_alias),  temp_vertex_key_columns AS vertex_key_column     KEY(owner, graph_name, vertex_table_alias, column_name)    LABEL key_column    PROPERTIES (column_name, ordinal_position),  temp_edge_key_columns AS edge_key_column    KEY(owner, graph_name, edge_table_alias, column_name)    LABEL key_column    PROPERTIES (column_name, ordinal_position),  temp_labels AS label    KEY(owner, graph_name, label_name)    PROPERTIES (label_name),  temp_label_properties AS property    KEY(owner, graph_name, label_name, property_name)    PROPERTIES (property_name)) EDGE TABLES (  temp_vertex_tables    KEY(owner, graph_name, vertex_table_alias)    SOURCE KEY(owner, graph_name) REFERENCES property_graph    DESTINATION KEY(owner, graph_name, vertex_table_alias) REFERENCES vertex_table    LABEL has_vertex_table NO PROPERTIES,  temp_edge_tables    KEY(owner, graph_name, edge_table_alias)    SOURCE KEY(owner, graph_name) REFERENCES property_graph    DESTINATION KEY(owner, graph_name, edge_table_alias) REFERENCES edge_table    LABEL has_edge_table NO PROPERTIES,  temp_vertex_key_columns    KEY(owner, graph_name, vertex_table_alias, column_name)    SOURCE KEY(owner, graph_name, vertex_table_alias) REFERENCES vertex_table    DESTINATION KEY(owner, graph_name, vertex_table_alias, column_name) REFERENCES vertex_key_column    LABEL has_key_column NO PROPERTIES,  temp_edge_key_columns    KEY(owner, graph_name, edge_table_alias, column_name)    SOURCE KEY(owner, graph_name, edge_table_alias) REFERENCES edge_table    DESTINATION KEY(owner, graph_name, edge_table_alias, column_name) REFERENCES edge_key_column    LABEL has_key_column NO PROPERTIES,  temp_vertex_labels    KEY(owner, graph_name, vertex_table_alias, label_name)    SOURCE KEY(owner, graph_name, vertex_table_alias) REFERENCES vertex_table    DESTINATION KEY(owner, graph_name, label_name) REFERENCES label    LABEL has_label NO PROPERTIES,  temp_edge_labels    KEY(owner, graph_name, edge_table_alias, label_name)    SOURCE KEY(owner, graph_name, edge_table_alias) REFERENCES edge_table    DESTINATION KEY(owner, graph_name, label_name) REFERENCES label    LABEL has_label NO PROPERTIES,  temp_edge_tables AS edge_has_source_table    KEY(owner, graph_name, edge_table_alias, source_table_alias)    SOURCE KEY(owner, graph_name, edge_table_alias) REFERENCES edge_table    DESTINATION KEY(owner, graph_name, source_table_alias) REFERENCES vertex_table    LABEL has_source_table NO PROPERTIES,  temp_edge_tables AS edge_has_destination_table    KEY(owner, graph_name, edge_table_alias, destination_table_alias)    SOURCE KEY(owner, graph_name, edge_table_alias) REFERENCES edge_table    DESTINATION KEY(owner, graph_name, destination_table_alias) REFERENCES vertex_table    LABEL has_destination_table NO PROPERTIES,  temp_label_properties AS label_properties    KEY(owner, graph_name, label_name, property_name)    SOURCE KEY(owner, graph_name, label_name) REFERENCES label    DESTINATION KEY(owner, graph_name, label_name, property_name) REFERENCES property    LABEL has_property NO PROPERTIES) OPTIONS (PG_VIEW)";
    static final String bulkDeleteStatement = "DECLARE\n    type array_t is varray(8) of varchar2(30);\n    array_view array_t := array_t('TEMP_VERTEX_TABLES', 'TEMP_VERTEX_LABELS', 'TEMP_EDGE_LABELS', 'TEMP_EDGE_TABLES', 'TEMP_VERTEX_KEY_COLUMNS', 'TEMP_EDGE_KEY_COLUMNS', 'TEMP_LABEL_PROPERTIES', 'TEMP_LABELS');\n    type array_s is varray(7) of varchar2(50);\n    array_table array_s := array_s('TEMP_PROPERTY_GRAPHS', 'GRAPH_LIST$', 'PROPERTY_GRAPH_METADATA_ELEM_TABLE$', 'PROPERTY_GRAPH_METADATA_LABEL$', 'PROPERTY_GRAPH_METADATA_PROPERTY$', 'PROPERTY_GRAPH_METADATA_KEY$', 'PROPERTY_GRAPH_METADATA_SRC_DST_KEY$');\nBEGIN\n    FOR i in 1..array_view.count LOOP\n    BEGIN\n        EXECUTE IMMEDIATE 'DROP VIEW ' || array_view(i);\n        EXCEPTION\n            WHEN OTHERS THEN\n            IF SQLCODE != -942 THEN\n                RAISE;\n            END IF;\n    END;\n    END LOOP;\n    FOR i in 1..array_table.count LOOP\n    BEGIN\n        EXECUTE IMMEDIATE 'DROP TABLE ' || array_table(i);\n        EXCEPTION\n            WHEN OTHERS THEN\n            IF SQLCODE != -942 THEN\n                RAISE;\n            END IF;\n    END;\n    END LOOP;\nEND;";
    private static String viewsBlock = "DECLARE\n    TYPE graph_data IS RECORD (\n        OWNER VARCHAR(128),\n        GRAPH_NAME VARCHAR(128)\n    );\n    TYPE graph_data_table IS TABLE OF graph_data;\n    temp_graph_data graph_data_table;\n    query1 VARCHAR2(4000);\n    query2 VARCHAR2(4000);\n    query3 VARCHAR2(4000);\n    query4 VARCHAR2(4000);\n    query5 VARCHAR2(4000);\n    query6 VARCHAR2(4000);\n    query7 VARCHAR2(4000);\n    query8 VARCHAR2(4000);\n    graph_count DBMS_ID;\n    CURSOR cur IS\n            SELECT OWNER, SUBSTR(TABLE_NAME, 1, INSTR(TABLE_NAME, '_ELEM_TABLE$') - 1) AS GRAPH_NAME, ROWNUM rn, count(*) over (partition by 1) as cnt\n            FROM SYS.ALL_TABLES\n            WHERE TABLE_NAME LIKE '%_ELEM_TABLE$' AND TABLE_NAME <> 'PROPERTY_GRAPH_METADATA_ELEM_TABLE$';\nBEGIN\n    BEGIN\n        EXECUTE IMMEDIATE 'CREATE TABLE GRAPH_LIST$ (OWNER VARCHAR2(128), GRAPH_NAME VARCHAR2(128))';\n        EXCEPTION\n            WHEN OTHERS THEN\n            IF SQLCODE != -955 THEN\n                RAISE;\n            END IF;\n    END;\n    BEGIN\n        EXECUTE IMMEDIATE 'CREATE TABLE temp_property_graphs (OWNER VARCHAR2(128), GRAPH_NAME VARCHAR2(128))';\n        EXCEPTION\n            WHEN OTHERS THEN\n            IF SQLCODE != -955 THEN\n                RAISE;\n            END IF;\n    END;\n    EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_property_graphs';\n    EXECUTE IMMEDIATE 'WITH temp_table AS (SELECT /*+ materialize */ OWNER, SUBSTR(TABLE_NAME, 1, INSTR(TABLE_NAME, ''_ELEM_TABLE$'') - 1) AS GRAPH_NAME \n        FROM SYS.ALL_TABLES\n        WHERE TABLE_NAME LIKE ''%_ELEM_TABLE$'' AND TABLE_NAME <> ''PROPERTY_GRAPH_METADATA_ELEM_TABLE$'') SELECT * FROM temp_table' BULK COLLECT INTO temp_graph_data;\n             \n    FOR i IN 1..temp_graph_data.count LOOP\n        EXECUTE IMMEDIATE 'INSERT INTO temp_property_graphs(owner, graph_name) VALUES(:1, :2)' USING temp_graph_data(i).owner, temp_graph_data(i).graph_name;\n    END LOOP;\n    EXECUTE IMMEDIATE 'SELECT COUNT(*) as cnt FROM (\n                (SELECT OWNER, GRAPH_NAME FROM GRAPH_LIST$ MINUS SELECT OWNER, GRAPH_NAME FROM temp_property_graphs)\n                UNION ALL\n                (SELECT OWNER, GRAPH_NAME FROM temp_property_graphs MINUS SELECT OWNER, GRAPH_NAME FROM GRAPH_LIST$)\n            )' INTO graph_count;\n    IF graph_count != 0 OR temp_graph_data.count = 0 THEN\n        EXECUTE IMMEDIATE 'TRUNCATE TABLE GRAPH_LIST$';\n        EXECUTE IMMEDIATE 'INSERT INTO GRAPH_LIST$ SELECT * FROM temp_property_graphs';\n        query1 := 'CREATE OR REPLACE VIEW temp_vertex_tables AS SELECT * FROM ( ';\n        query2 := 'CREATE OR REPLACE VIEW temp_edge_tables AS SELECT * FROM ( ';\n        query3 := 'CREATE OR REPLACE VIEW temp_vertex_key_columns AS SELECT * FROM ( ';\n        query4 := 'CREATE OR REPLACE VIEW temp_edge_key_columns AS SELECT * FROM ( ';\n        query5 := 'CREATE OR REPLACE VIEW temp_vertex_labels AS SELECT * FROM ( ';\n        query6 := 'CREATE OR REPLACE VIEW temp_edge_labels AS SELECT * FROM ( ';\n        query7 := 'CREATE OR REPLACE VIEW temp_labels AS SELECT * FROM ( ';\n        query8 := 'CREATE OR REPLACE VIEW temp_label_properties AS SELECT * FROM ( ';\n        FOR g_rec IN cur LOOP \n            query1:= query1 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, et_name AS VERTEX_TABLE_ALIAS, table_name AS TABLE_NAME  \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_ELEM_TABLE$', false) || '\n                    WHERE et_type=''VERTEX''';\n                     \n            query2:= query2 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, t.et_name AS EDGE_TABLE_ALIAS, t.table_name AS TABLE_NAME, t1.vt_name AS SOURCE_TABLE_ALIAS, t2.vt_name AS DESTINATION_TABLE_ALIAS \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_ELEM_TABLE$', false) ||' t, ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_SRC_DST_KEY$', false) || ' t1, ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_SRC_DST_KEY$', false) ||' t2\n                    WHERE t.et_type = ''EDGE'' AND t1.key_type = ''EDGE_SOURCE'' AND t1.et_name=t.et_name AND t2.key_type = ''EDGE_DESTINATION'' AND t2.et_name=t.et_name';\n                     \n            query3:= query3 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, et_name AS VERTEX_TABLE_ALIAS , column_name AS COLUMN_NAME, column_number AS ORDINAL_POSITION  \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_KEY$', false) ||'\n                    WHERE key_type = ''VERTEX''';\n                     \n            query4:= query4 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, et_name AS EDGE_TABLE_ALIAS , column_name AS COLUMN_NAME, column_number AS ORDINAL_POSITION  \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_KEY$', false) ||'\n                    WHERE key_type = ''EDGE''';\n                     \n            query5:= query5 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, et_name AS VERTEX_TABLE_ALIAS, label_name AS LABEL_NAME \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_LABEL$', false) ||'\n                    WHERE et_type = ''VERTEX''';\n                     \n            query6:= query6 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, et_name AS EDGE_TABLE_ALIAS, label_name AS LABEL_NAME \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_LABEL$', false) ||'\n                    WHERE et_type = ''EDGE''';\n                     \n            query7:= query7 || 'SELECT DISTINCT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, label_name AS LABEL_NAME \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_LABEL$', false) ||'\n                    ';\n            query8:= query8 || 'SELECT DISTINCT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, label_name AS LABEL_NAME, property_name AS PROPERTY_NAME \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_PROPERTY$', false) ||'\n                    ';\n             \n            IF g_rec.rn != g_rec.cnt THEN \n                query1:= query1 || ' UNION ALL ';\n                query2:= query2 || ' UNION ALL ';\n                query3:= query3 || ' UNION ALL ';\n                query4:= query4 || ' UNION ALL ';\n                query5:= query5 || ' UNION ALL ';\n                query6:= query6 || ' UNION ALL ';\n                query7:= query7 || ' UNION ALL ';\n                query8:= query8 || ' UNION ALL ';\n            END IF;\n        END LOOP;\n        IF temp_graph_data.count = 0 THEN\n            query1 := query1 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''et_name'' AS VERTEX_TABLE_ALIAS, ''table_name'' AS TABLE_NAME FROM DUAL where 1 <> 1';\n            query2 := query2 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''et_name'' AS EDGE_TABLE_ALIAS, ''table_name'' AS TABLE_NAME, ''vt_name'' AS SOURCE_TABLE_ALIAS, ''vt_name'' AS DESTINATION_TABLE_ALIAS FROM dual WHERE 1 <> 1';\n            query3 := query3 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''et_name'' AS VERTEX_TABLE_ALIAS , ''column_name'' AS COLUMN_NAME, 1 AS ORDINAL_POSITION FROM dual WHERE 1 <> 1';\n            query4 := query4 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''et_name'' AS EDGE_TABLE_ALIAS , ''column_name'' AS COLUMN_NAME, 1 AS ORDINAL_POSITION FROM dual WHERE 1 <> 1';\n            query5 := query5 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''et_name'' AS VERTEX_TABLE_ALIAS, ''label_name'' AS LABEL_NAME FROM dual WHERE 1 <> 1';\n            query6 := query6 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''et_name'' AS EDGE_TABLE_ALIAS, ''label_name'' AS LABEL_NAME FROM dual WHERE 1 <> 1';\n            query7 := query7 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''label_name'' as LABEL_NAME FROM dual WHERE 1 <> 1';\n            query8 := query8 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''label_name'' as LABEL_NAME, ''property_name'' AS PROPERTY_NAME FROM dual WHERE 1 <> 1';\n        END IF;\n        query1:= query1 || ' )';\n        query2:= query2 || ' )';\n        query3:= query3 || ' )';\n        query4:= query4 || ' )';\n        query5:= query5 || ' )';\n        query6:= query6 || ' )';\n        query7:= query7 || ' )';\n        query8:= query8 || ' )';\n        EXECUTE IMMEDIATE query1;\n        EXECUTE IMMEDIATE query2;\n        EXECUTE IMMEDIATE query3;\n        EXECUTE IMMEDIATE query4;\n        EXECUTE IMMEDIATE query5;\n        EXECUTE IMMEDIATE query6;\n        EXECUTE IMMEDIATE query7;\n        EXECUTE IMMEDIATE query8;\n    END IF;\nEND;";
    private static Connection conn;
    private static PgqlConnection pgqlConn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphType graphMetadataInitiator(Connection connection, String schemaName) throws SQLException {
        conn = connection;
        pgqlConn = PgqlConnection.getConnection(conn);
        try (ResultSet rs = null;
             PreparedStatement ps = connection.prepareStatement("SELECT TABLE_NAME         FROM SYS.ALL_TABLES        WHERE TABLE_NAME = 'PROPERTY_GRAPH_METADATA_ELEM_TABLE$' AND OWNER=?");){
            GraphMetadataHandler.bulkExecute(viewsBlock);
            ps.setString(1, schemaName);
            rs = ps.executeQuery();
            if (!rs.next()) {
                GraphMetadataHandler.createGraph();
            }
        }
        return GraphType.PG_VIEWS;
    }

    private static void bulkExecute(String plsqlBlock) throws SQLException {
        try (CallableStatement stmt = null;){
            stmt = conn.prepareCall(plsqlBlock);
            stmt.execute();
        }
    }

    public static void cleanup() {
        try {
            GraphMetadataHandler.bulkExecute(bulkDeleteStatement);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void createGraph() throws PgqlException {
        try (PgqlStatement pgqlStmt = null;){
            pgqlStmt = pgqlConn.createStatement();
            pgqlStmt.execute(createGraphStatement);
        }
    }

    public static void dropGraph() throws PgqlException {
        try (PgqlStatement pgqlStmt = null;){
            pgqlStmt = pgqlConn.createStatement();
            pgqlStmt.execute("DROP PROPERTY GRAPH PROPERTY_GRAPH_METADATA");
        }
    }
}

