/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.ExecutionInfo;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.PgViewModifyTrans;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgViewDmlExecution {
    private static final Logger ms_log = LoggerFactory.getLogger(PgViewDmlExecution.class);
    private final Connection conn;
    private final ExecutionInfo executionInfo;

    public PgViewDmlExecution(Connection conn, ExecutionInfo executionInfo) {
        this.conn = conn;
        this.executionInfo = executionInfo;
    }

    public void executeModify(PgViewModifyTrans modifyTrans, boolean autoCommit, int parallel, int dynamicSampling, boolean append) throws SQLException {
        Savepoint savepoint = null;
        boolean usePtt = modifyTrans.getPatternTranslation() != null;
        long modifyCount = 0L;
        try {
            if (autoCommit) {
                savepoint = this.conn.setSavepoint();
            }
            String hint = DbmsUtils.buildHint(parallel, dynamicSampling, append, false);
            if (usePtt) {
                for (Pair pair : modifyTrans.getPatternTranslation()) {
                    String stmt = this.replaceHint((String)pair.first, hint);
                    ms_log.debug("Executing:[" + stmt + "]");
                    PreparedStatement ps = this.prepareStatement(stmt);
                    Throwable throwable = null;
                    try {
                        DbmsUtils.setBindValues(ps, (List)pair.second);
                        ps.execute();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ps == null) continue;
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ps.close();
                    }
                }
            }
            for (List list : modifyTrans.getModifications()) {
                for (Pair modify : list) {
                    String stmt = this.replaceHint((String)modify.first, hint);
                    ms_log.debug("Executing:[" + stmt + "]");
                    CallableStatement cs = this.prepareCall(stmt);
                    Throwable throwable = null;
                    try {
                        List bindValues = (List)modify.second;
                        DbmsUtils.setBindValues(cs, bindValues);
                        int countIdx = bindValues == null ? 1 : bindValues.size() + 1;
                        cs.registerOutParameter(countIdx, 4);
                        cs.execute();
                        modifyCount += (long)cs.getInt(countIdx);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (cs == null) continue;
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        cs.close();
                    }
                }
            }
            this.executionInfo.modifyCount = modifyCount;
            if (usePtt) {
                String drop = "DROP TABLE ORA$PTT_MATCH_QUERY";
                ms_log.debug("Executing:[" + drop + "]");
                PreparedStatement preparedStatement = this.prepareStatement(drop);
                Object object = null;
                try {
                    preparedStatement.execute();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (preparedStatement != null) {
                        if (object != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            preparedStatement.close();
                        }
                    }
                }
            }
            if (autoCommit) {
                this.conn.commit();
            }
        }
        catch (Exception ex) {
            if (usePtt) {
                String drop = "DROP TABLE ORA$PTT_MATCH_QUERY";
                ms_log.debug("Executing:[" + drop + "]");
                try (PreparedStatement preparedStatement = this.conn.prepareStatement(drop);){
                    preparedStatement.execute();
                }
                catch (Exception exception) {
                    ms_log.debug("Error while dropping PTT:" + exception.getMessage());
                }
            }
            if (autoCommit && savepoint != null) {
                this.conn.rollback(savepoint);
            }
            throw ex;
        }
    }

    private String replaceHint(String stmt, String hint) {
        if ("".equals(hint)) {
            return stmt.replaceFirst("/\\*\\+ \\*/ ", "");
        }
        return stmt.replaceFirst("/\\*\\+ ", "/*+ " + hint);
    }

    private PreparedStatement prepareStatement(String str) throws SQLException {
        if (this.executionInfo.isCanceled) {
            throw new PgqlToSqlException("User requested cancel of current operation");
        }
        PreparedStatement stmt = this.conn.prepareStatement(str);
        this.executionInfo.currentStmts = new Statement[]{stmt};
        return stmt;
    }

    private CallableStatement prepareCall(String str) throws SQLException {
        if (this.executionInfo.isCanceled) {
            throw new PgqlToSqlException("User requested cancel of current operation");
        }
        CallableStatement stmt = this.conn.prepareCall(str);
        this.executionInfo.currentStmts = new Statement[]{stmt};
        return stmt;
    }
}

