/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import oracle.jdbc.OracleResultSet;
import oracle.pg.rdbms.pgql.PgqlExecution;
import oracle.pg.rdbms.pgql.PgqlResultSetImpl;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgview.PgViewResultSetMetaData;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSetMetaData;
import oracle.sql.TIMESTAMPTZ;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgViewResultSet
extends PgqlResultSetImpl {
    private static final Logger ms_log = LoggerFactory.getLogger(PgViewResultSet.class);
    private static final String PG_VIEW_VALUE_TYPE_ERROR = "PG view result set does not have a value type";

    public PgViewResultSet(ResultSet rs, Statement stmt, int fetchSize, QueryContext ctx, PgqlExecution ope, long id) throws SQLException {
        super(rs, stmt, fetchSize, ctx, ope, id);
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Constructing a new PgqlResultSet id=[" + id + "]");
        }
    }

    public ResultSetMetaData getMetaData() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Returning a new PgqlResultSetMetaData");
        }
        try {
            return new PgViewResultSetMetaData(this.rs.getMetaData());
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    public Object getObject(int elementIdx) throws PgqlException {
        try {
            return this.rs.getObject(elementIdx);
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Object getObject(String elementName) throws PgqlException {
        try {
            return this.rs.getObject(elementName);
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public String getString(int elementIdx) throws PgqlException {
        try {
            return this.rs.getString(elementIdx);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public String getString(String elementName) throws PgqlException {
        try {
            return this.rs.getString(elementName);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Integer getInteger(int elementIdx) throws PgqlException {
        try {
            int result = this.rs.getInt(elementIdx);
            return this.rs.wasNull() ? null : Integer.valueOf(result);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Integer getInteger(String elementName) throws PgqlException {
        try {
            int result = this.rs.getInt(elementName);
            return this.rs.wasNull() ? null : Integer.valueOf(result);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Long getLong(int elementIdx) throws PgqlException {
        try {
            long result = this.rs.getLong(elementIdx);
            return this.rs.wasNull() ? null : Long.valueOf(result);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Long getLong(String elementName) throws PgqlException {
        try {
            long result = this.rs.getLong(elementName);
            return this.rs.wasNull() ? null : Long.valueOf(result);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Float getFloat(int elementIdx) throws PgqlException {
        try {
            float result = this.rs.getFloat(elementIdx);
            return this.rs.wasNull() ? null : Float.valueOf(result);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Float getFloat(String elementName) throws PgqlException {
        try {
            float result = this.rs.getFloat(elementName);
            return this.rs.wasNull() ? null : Float.valueOf(result);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Double getDouble(int elementIdx) throws PgqlException {
        try {
            double result = this.rs.getDouble(elementIdx);
            return this.rs.wasNull() ? null : Double.valueOf(result);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Double getDouble(String elementName) throws PgqlException {
        try {
            double result = this.rs.getDouble(elementName);
            return this.rs.wasNull() ? null : Double.valueOf(result);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Boolean getBoolean(int elementIdx) throws PgqlException {
        try {
            boolean result = this.rs.getBoolean(elementIdx);
            return this.rs.wasNull() ? null : Boolean.valueOf(result);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public Boolean getBoolean(String elementName) throws PgqlException {
        try {
            boolean result = this.rs.getBoolean(elementName);
            return this.rs.wasNull() ? null : Boolean.valueOf(result);
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    @Override
    public LocalDate getDate(int columnIdx) throws PgqlException {
        try {
            Date result = this.rs.getDate(columnIdx);
            return this.rs.wasNull() ? null : result.toLocalDate();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    @Override
    public LocalDate getDate(String columnName) throws PgqlException {
        try {
            Date result = this.rs.getDate(columnName);
            return this.rs.wasNull() ? null : result.toLocalDate();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    @Override
    public LocalTime getTime(int columnIdx) throws PgqlException {
        try {
            Time result = this.rs.getTime(columnIdx);
            return this.rs.wasNull() ? null : result.toLocalTime();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    @Override
    public LocalTime getTime(String columnName) throws PgqlException {
        try {
            Time result = this.rs.getTime(columnName);
            return this.rs.wasNull() ? null : result.toLocalTime();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    @Override
    public LocalDateTime getTimestamp(int columnIdx) throws PgqlException {
        try {
            Timestamp result = this.rs.getTimestamp(columnIdx);
            return this.rs.wasNull() ? null : result.toLocalDateTime();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    @Override
    public LocalDateTime getTimestamp(String columnName) throws PgqlException {
        try {
            Timestamp result = this.rs.getTimestamp(columnName);
            return this.rs.wasNull() ? null : result.toLocalDateTime();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    @Override
    public OffsetTime getTimeWithTimezone(int columnIdx) throws PgqlException {
        try {
            OracleResultSet ors = (OracleResultSet)this.rs;
            TIMESTAMPTZ result = ors.getTIMESTAMPTZ(columnIdx);
            return ors.wasNull() ? null : result.offsetDateTimeValue(this.rs.getStatement().getConnection()).toOffsetTime();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    @Override
    public OffsetTime getTimeWithTimezone(String columnName) throws PgqlException {
        try {
            OracleResultSet ors = (OracleResultSet)this.rs;
            TIMESTAMPTZ result = ors.getTIMESTAMPTZ(columnName);
            return ors.wasNull() ? null : result.offsetDateTimeValue(this.rs.getStatement().getConnection()).toOffsetTime();
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    @Override
    public OffsetDateTime getTimestampWithTimezone(int elementIdx) throws PgqlException {
        try {
            OracleResultSet ors = (OracleResultSet)this.rs;
            TIMESTAMPTZ result = ors.getTIMESTAMPTZ(elementIdx);
            return ors.wasNull() ? null : result.offsetDateTimeValue(this.rs.getStatement().getConnection());
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    public OffsetDateTime getTimestampWithTimezone(String elementName) throws PgqlException {
        try {
            OracleResultSet ors = (OracleResultSet)this.rs;
            TIMESTAMPTZ result = ors.getTIMESTAMPTZ(elementName);
            return ors.wasNull() ? null : result.offsetDateTimeValue(this.rs.getStatement().getConnection());
        }
        catch (Exception ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    @Override
    public int getValueType(int elementIdx) throws PgqlException {
        throw new PgqlException(PG_VIEW_VALUE_TYPE_ERROR);
    }

    @Override
    public int getValueType(String elementName) throws PgqlException {
        throw new PgqlException(PG_VIEW_VALUE_TYPE_ERROR);
    }
}

