/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class PgViewMetadataConnector
implements MetadataConnector {
    public static final String VERTEX_TYPE = "VERTEX";
    public static final String EDGE_TYPE = "EDGE";
    public static final String EDGE_SOURCE_TYPE = "EDGE_SOURCE";
    public static final String EDGE_DESTINATION_TYPE = "EDGE_DESTINATION";
    public static final String ELEM_TABLE_SUFFIX = "_ELEM_TABLE$";
    public static final String LABEL_SUFFIX = "_LABEL$";
    public static final String PROPERTY_SUFFIX = "_PROPERTY$";
    public static final String KEY_SUFFIX = "_KEY$";
    public static final String SRC_DST_KEY_SUFFIX = "_SRC_DST_KEY$";
    private final Connection conn;
    private final String graphSchema;
    private final String graphName;

    public PgViewMetadataConnector(Connection conn, String graphSchema, String graphName) {
        this.conn = conn;
        this.graphSchema = graphSchema;
        this.graphName = graphName;
    }

    @Override
    public boolean isVertexLabel(String labelName) {
        return this.isLabel(labelName, true);
    }

    @Override
    public boolean isEdgeLabel(String labelName) {
        return this.isLabel(labelName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isLabel(String labelName, boolean isVertexTable) {
        String elementType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryVertexLabel = "SELECT count(*) FROM " + this.getTableForSuffix(LABEL_SUFFIX) + "\nWHERE LABEL_NAME = ?\n  AND ET_TYPE = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(queryVertexLabel);){
            ps.setString(1, labelName);
            ps.setString(2, elementType);
            ResultSet rs = ps.executeQuery();
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public boolean isPropertyForVertexTable(String tableName, String propertyName) {
        return this.isPropertyForTable(tableName, propertyName, true);
    }

    @Override
    public boolean isPropertyForEdgeTable(String tableName, String propertyName) {
        return this.isPropertyForTable(tableName, propertyName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPropertyForTable(String tableName, String propertyName, boolean isVertexTable) {
        String elementType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryVertexProperty = "SELECT count(*) FROM " + this.getTableForSuffix(PROPERTY_SUFFIX) + "\nWHERE ET_NAME = ?\n  AND ET_TYPE = ?\n  AND PROPERTY_NAME = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(queryVertexProperty);){
            ps.setString(1, tableName);
            ps.setString(2, elementType);
            ps.setString(3, propertyName);
            ResultSet rs = ps.executeQuery();
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public Set<String> getAllVertexLabels() {
        return this.getAllLabels(true);
    }

    @Override
    public Set<String> getAllEdgeLabels() {
        return this.getAllLabels(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getAllLabels(boolean isVertexTable) {
        String elementType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryEdgeLabels = "SELECT LABEL_NAME FROM " + this.getTableForSuffix(LABEL_SUFFIX) + "\nWHERE ET_TYPE = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(queryEdgeLabels);){
            ps.setString(1, elementType);
            ResultSet rs = ps.executeQuery();
            HashSet<String> edgeLabels = new HashSet<String>();
            while (rs.next()) {
                edgeLabels.add(rs.getString(1));
            }
            HashSet<String> hashSet = edgeLabels;
            return hashSet;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public Set<String> getVertexTablesForLabel(String labelName) {
        return this.getTablesForLabel(labelName, true);
    }

    @Override
    public Set<String> getEdgeTablesForLabel(String labelName) {
        return this.getTablesForLabel(labelName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getTablesForLabel(String labelName, boolean isVertexTable) {
        String elementType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryVertexTables = "SELECT ET_NAME FROM " + this.getTableForSuffix(LABEL_SUFFIX) + "\nWHERE LABEL_NAME = ? \n  AND ET_TYPE = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(queryVertexTables);){
            ps.setString(1, labelName);
            ps.setString(2, elementType);
            ResultSet rs = ps.executeQuery();
            HashSet<String> vertexTables = new HashSet<String>();
            while (rs.next()) {
                vertexTables.add(rs.getString(1));
            }
            HashSet<String> hashSet = vertexTables;
            return hashSet;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    public Set<String> getVertexPropertiesForLabel(String labelName) {
        return this.getPropertiesForLabel(labelName, true);
    }

    public Set<String> getEdgePropertiesForLabel(String labelName) {
        return this.getPropertiesForLabel(labelName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getPropertiesForLabel(String labelName, boolean isVertexTable) {
        String elementType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryProperties = "SELECT PROPERTY_NAME FROM " + this.getTableForSuffix(PROPERTY_SUFFIX) + "\nWHERE LABEL_NAME = ? \n  AND ET_TYPE = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(queryProperties);){
            ps.setString(1, labelName);
            ps.setString(2, elementType);
            ResultSet rs = ps.executeQuery();
            HashSet<String> vertexTables = new HashSet<String>();
            while (rs.next()) {
                vertexTables.add(rs.getString(1));
            }
            HashSet<String> hashSet = vertexTables;
            return hashSet;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public String getSrcTable(String edgeTable) {
        return this.getAdjacentTable(edgeTable, true);
    }

    @Override
    public String getDstTable(String edgeTable) {
        return this.getAdjacentTable(edgeTable, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAdjacentTable(String edgeTable, boolean isSourceTable) {
        String keyType = isSourceTable ? EDGE_SOURCE_TYPE : EDGE_DESTINATION_TYPE;
        String querySrcTable = "SELECT VT_NAME FROM " + this.getTableForSuffix(SRC_DST_KEY_SUFFIX) + "\nWHERE ET_NAME = ?\n  AND KEY_TYPE = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(querySrcTable);){
            ps.setString(1, edgeTable);
            ps.setString(2, keyType);
            ResultSet rs = ps.executeQuery();
            rs.next();
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public Set<String> getInputTables(String vertexTable) {
        return this.getInputOrOutputTables(vertexTable, true);
    }

    @Override
    public Set<String> getOutputTables(String vertexTable) {
        return this.getInputOrOutputTables(vertexTable, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getInputOrOutputTables(String edgeTable, boolean getInputTables) {
        String keyType = getInputTables ? EDGE_DESTINATION_TYPE : EDGE_SOURCE_TYPE;
        String querySrcTable = "SELECT ET_NAME FROM " + this.getTableForSuffix(SRC_DST_KEY_SUFFIX) + "\nWHERE VT_NAME = ?\n  AND KEY_TYPE = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(querySrcTable);){
            ps.setString(1, edgeTable);
            ps.setString(2, keyType);
            ResultSet rs = ps.executeQuery();
            HashSet<String> tables = new HashSet<String>();
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
            HashSet<String> hashSet = tables;
            return hashSet;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public SchemaQualifiedName getSchemaQualifiedVertexTableName(String tableName) {
        return this.getSchemaQualifiedTableName(tableName, true);
    }

    @Override
    public SchemaQualifiedName getSchemaQualifiedEdgeTableName(String tableName) {
        return this.getSchemaQualifiedTableName(tableName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SchemaQualifiedName getSchemaQualifiedTableName(String edgeTable, boolean isVertexTable) {
        String tableType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryEdgeTable = "SELECT SCHEMA_NAME, TABLE_NAME FROM " + this.getTableForSuffix(ELEM_TABLE_SUFFIX) + "\nWHERE ET_NAME = ?\n  AND ET_TYPE = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(queryEdgeTable);){
            ps.setString(1, edgeTable);
            ps.setString(2, tableType);
            ResultSet rs = ps.executeQuery();
            rs.next();
            SchemaQualifiedName schemaQualifiedName = new SchemaQualifiedName(rs.getString(1), rs.getString(2));
            return schemaQualifiedName;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public List<String> getVertexTableKey(String tableName) {
        return this.getTableKey(tableName, true);
    }

    @Override
    public List<String> getEdgeTableKey(String tableName) {
        return this.getTableKey(tableName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getTableKey(String tableName, boolean isVertexTable) {
        String elementType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryVertexKey = "SELECT COLUMN_NAME FROM " + this.getTableForSuffix(KEY_SUFFIX) + "\nWHERE ET_NAME = ?\n  AND KEY_TYPE = ?\nORDER BY COLUMN_NUMBER";
        try (PreparedStatement ps = this.conn.prepareStatement(queryVertexKey);){
            ps.setString(1, tableName);
            ps.setString(2, elementType);
            ResultSet rs = ps.executeQuery();
            ArrayList<String> vertexKey = new ArrayList<String>();
            while (rs.next()) {
                vertexKey.add(rs.getString(1));
            }
            ArrayList<String> arrayList = vertexKey;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public List<Pair<String, String>> getEdgeTableSrcKey(String tableName) {
        return this.getEdgeTableAdjacentKey(tableName, true);
    }

    @Override
    public List<Pair<String, String>> getEdgeTableDstKey(String tableName) {
        return this.getEdgeTableAdjacentKey(tableName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Pair<String, String>> getEdgeTableAdjacentKey(String tableName, boolean isSourceTable) {
        String keyType = isSourceTable ? EDGE_SOURCE_TYPE : EDGE_DESTINATION_TYPE;
        String queryDstKey = "SELECT E_TAB.ET_COLUMN_NAME, V_TAB.COLUMN_NAME\nFROM " + this.getTableForSuffix(SRC_DST_KEY_SUFFIX) + " E_TAB, " + this.getTableForSuffix(KEY_SUFFIX) + " V_TAB\nWHERE E_TAB.ET_NAME = ?\n  AND E_TAB.KEY_TYPE = ?\n  AND E_TAB.VT_NAME = V_TAB.ET_NAME\n  AND E_TAB.ET_COLUMN_NUMBER = V_TAB.COLUMN_NUMBER\n  AND V_TAB.KEY_TYPE = ?\nORDER BY E_TAB.ET_COLUMN_NUMBER";
        try (PreparedStatement ps = this.conn.prepareStatement(queryDstKey);){
            ps.setString(1, tableName);
            ps.setString(2, keyType);
            ps.setString(3, VERTEX_TYPE);
            ResultSet rs = ps.executeQuery();
            ArrayList<Pair<String, String>> srcKey = new ArrayList<Pair<String, String>>();
            while (rs.next()) {
                srcKey.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
            ArrayList<Pair<String, String>> arrayList = srcKey;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public String getColumnNameForVertexTable(String tableName, String propertyName) {
        return this.getColumnNameForTable(tableName, propertyName, true);
    }

    @Override
    public String getColumnNameForEdgeTable(String tableName, String propertyName) {
        return this.getColumnNameForTable(tableName, propertyName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getColumnNameForTable(String tableName, String propertyName, boolean isVertexTable) {
        String elementType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryVertexColumn = "SELECT COLUMN_NAME FROM " + this.getTableForSuffix(PROPERTY_SUFFIX) + "\nWHERE ET_NAME = ?\n  AND ET_TYPE = ?\n  AND PROPERTY_NAME = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(queryVertexColumn);){
            ps.setString(1, tableName);
            ps.setString(2, elementType);
            ps.setString(3, propertyName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    public String getTableForSuffix(String suffix) {
        try {
            return DbmsUtils.sanitizeGraphOwner(this.conn, this.graphSchema) + "." + DbmsUtils.enquoteTableName(this.conn, this.graphName + suffix);
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    public String getTablePrimaryKeyForSuffix(String suffix) {
        try {
            return DbmsUtils.enquoteTableName(this.conn, this.graphName + suffix + "_PK");
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existsPgView(Connection conn, String graphOwner, String graphName) {
        if (graphName == null) {
            throw new PgqlToSqlException("Graph name is not set for this PgqlStatement. Use setGraph method in PgqlConnection or specify a graph name in the query");
        }
        String queryPgView = "SELECT count(*) FROM SYS.ALL_TABLES\nWHERE OWNER = ?\n  AND TABLE_NAME = ?";
        try (PreparedStatement ps = conn.prepareStatement(queryPgView);){
            ps.setString(1, graphOwner);
            ps.setString(2, graphName + ELEM_TABLE_SUFFIX);
            ResultSet rs = ps.executeQuery();
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public String getLabelForVertexTable(String tableName) {
        return this.getLabelForTable(tableName, true);
    }

    @Override
    public String getLabelForEdgeTable(String tableName) {
        return this.getLabelForTable(tableName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLabelForTable(String tableName, boolean isVertexTable) {
        String elementType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryEdgeLabels = "SELECT LABEL_NAME FROM " + this.getTableForSuffix(LABEL_SUFFIX) + "\nWHERE ET_NAME = ?\n  AND ET_TYPE = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(queryEdgeLabels);){
            ps.setString(1, tableName);
            ps.setString(2, elementType);
            ResultSet rs = ps.executeQuery();
            rs.next();
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public boolean isVertexTableStringColumn(String tableName, String columnName) {
        return this.isStringColumn(tableName, columnName, true);
    }

    @Override
    public boolean isEdgeTableStringColumn(String tableName, String columnName) {
        return this.isStringColumn(tableName, columnName, false);
    }

    private boolean isStringColumn(String tableName, String columnName, boolean isVertexTable) {
        String type;
        switch (type = this.getColumnDataType(tableName, columnName, isVertexTable, false)) {
            case "CHAR": 
            case "VARCHAR": 
            case "VARCHAR2": 
            case "NCHAR": 
            case "NVARCHAR": 
            case "NVARCHAR2": 
            case "CLOB": 
            case "NCLOB": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getColumnTypeForVertexColumn(String tableName, String columnName) {
        return this.getColumnDataType(tableName, columnName, true, true);
    }

    @Override
    public String getColumnTypeForEdgeColumn(String tableName, String columnName) {
        return this.getColumnDataType(tableName, columnName, false, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getColumnDataType(String tableName, String columnName, boolean isVertexTable, boolean appendLength) {
        String tableType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryDataType = "SELECT T1.DATA_TYPE " + (appendLength ? "|| CASE WHEN data_type IN ('VARCHAR2', 'NVARCHAR2', 'RAW') THEN '(' || data_length || ')' END" : "") + "\nFROM sys.all_tab_columns T1, " + this.getTableForSuffix(ELEM_TABLE_SUFFIX) + " T2\nWHERE T2.ET_NAME = ?\n  AND T2.ET_TYPE = ?\n  AND T1.OWNER = T2.SCHEMA_NAME\n  AND T1.TABLE_NAME = T2.TABLE_NAME\n  AND T1.COLUMN_NAME = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(queryDataType);){
            ps.setString(1, tableName);
            ps.setString(2, tableType);
            ps.setString(3, columnName);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                throw new PgqlToSqlException("Table " + tableName + " does not have a column " + columnName);
            }
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    @Override
    public String getColumnTypeForVertexProperty(String table, String propertyName) {
        return this.getColumnTypeForProperty(table, propertyName, true);
    }

    @Override
    public String getColumnTypeForEdgeProperty(String table, String propertyName) {
        return this.getColumnTypeForProperty(table, propertyName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getColumnTypeForProperty(String tableName, String propertyName, boolean isVertexTable) {
        String tableType = isVertexTable ? VERTEX_TYPE : EDGE_TYPE;
        String queryDataType = "SELECT T1.DATA_TYPE\nFROM sys.all_tab_columns T1,\n     " + this.getTableForSuffix(ELEM_TABLE_SUFFIX) + " T2,\n     " + this.getTableForSuffix(PROPERTY_SUFFIX) + " T3\nWHERE T2.ET_NAME = ?\n  AND T2.ET_TYPE = ?\n  AND T1.OWNER = T2.SCHEMA_NAME\n  AND T1.TABLE_NAME = T2.TABLE_NAME\n  AND T3.ET_NAME = T2.ET_NAME\n  AND T3.ET_TYPE = T2.ET_TYPE\n  AND T1.COLUMN_NAME = T3.COLUMN_NAME\n  AND T3.PROPERTY_NAME = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(queryDataType);){
            ps.setString(1, tableName);
            ps.setString(2, tableType);
            ps.setString(3, propertyName);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                String string = null;
                return string;
            }
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }
}

