/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.pgview.metadata.PgViewMetadataConnector;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.metadata.AbstractMetadataProvider;
import oracle.pgql.lang.metadata.EdgeLabel;
import oracle.pgql.lang.metadata.GraphSchema;
import oracle.pgql.lang.metadata.Property;
import oracle.pgql.lang.metadata.VertexLabel;

public class PgViewMetadataProvider
extends AbstractMetadataProvider {
    private final PgqlConnection pgqlConn;

    public PgViewMetadataProvider(PgqlConnection pgqlConn) {
        this.pgqlConn = pgqlConn;
    }

    public Optional<GraphSchema> getGraphSchema() {
        return Optional.ofNullable(this.getGraphSchema(this.pgqlConn.getSchema(), this.pgqlConn.getGraph()));
    }

    public Optional<GraphSchema> getGraphSchema(SchemaQualifiedName graphName) {
        String schemaName = graphName.getSchemaName() == null ? this.pgqlConn.getSchema() : graphName.getSchemaName();
        return Optional.ofNullable(this.getGraphSchema(schemaName, graphName.getName()));
    }

    private GraphSchema getGraphSchema(String schemaName, String graphName) {
        if (PgViewMetadataConnector.existsPgView(this.pgqlConn.getJdbcConnection(), schemaName, graphName)) {
            PgViewMetadataConnector metadataConnector = new PgViewMetadataConnector(this.pgqlConn.getJdbcConnection(), schemaName, graphName);
            List vertexLabels = metadataConnector.getAllVertexLabels().stream().map(x -> new VertexLabel(x, metadataConnector.getVertexPropertiesForLabel((String)x).stream().map(p -> new Property(p, "UNKNOWN")).collect(Collectors.toList()))).collect(Collectors.toList());
            List edgeLabels = metadataConnector.getAllEdgeLabels().stream().map(x -> new EdgeLabel(x, metadataConnector.getEdgePropertiesForLabel((String)x).stream().map(p -> new Property(p, "UNKNOWN")).collect(Collectors.toList()))).collect(Collectors.toList());
            return new GraphSchema(vertexLabels, edgeLabels);
        }
        return null;
    }
}

