/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.Direction;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

class AnyDirectedEdgeExtender
extends AbstractQueryExpressionVisitor {
    final List<VertexPairConnection> connections;
    final Map<String, QueryEdge> extendedEdges;

    public AnyDirectedEdgeExtender(Pair<List<VertexPairConnection>, Map<String, QueryEdge>> extension) {
        this.connections = (List)extension.first;
        this.extendedEdges = (Map)extension.second;
    }

    static List<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extendAnyDirectedEdges(Pair<List<VertexPairConnection>, Map<String, QueryEdge>> previousExtension) {
        ArrayList<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extension = new ArrayList<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>>();
        List connections = (List)previousExtension.first;
        Map extendedEdges = (Map)previousExtension.second;
        for (VertexPairConnection connection : connections) {
            if (connection.getVariableType() != QueryVariable.VariableType.EDGE || ((QueryEdge)connection).isDirected()) continue;
            connections.remove(connection);
            QueryEdge edge = (QueryEdge)connection;
            QueryEdge outgoingEdge = new QueryEdge(edge.getSrc(), edge.getDst(), edge.getName(), edge.isAnonymous(), Direction.OUTGOING);
            ArrayList<QueryEdge> connectionsOutgoing = new ArrayList<QueryEdge>(connections);
            connectionsOutgoing.add(outgoingEdge);
            HashMap<String, QueryEdge> extendedOutgoing = new HashMap<String, QueryEdge>(extendedEdges);
            extendedOutgoing.put(edge.getName(), outgoingEdge);
            extension.add(new Pair(connectionsOutgoing, extendedOutgoing));
            QueryEdge incomingEdge = new QueryEdge(edge.getDst(), edge.getSrc(), edge.getName(), edge.isAnonymous(), Direction.INCOMING);
            ArrayList<QueryEdge> connectionsIncoming = new ArrayList<QueryEdge>(connections);
            connectionsIncoming.add(incomingEdge);
            HashMap<String, QueryEdge> extendedIncoming = new HashMap<String, QueryEdge>(extendedEdges);
            extendedIncoming.put(edge.getName(), incomingEdge);
            extension.add(new Pair(connectionsIncoming, extendedIncoming));
            return AnyDirectedEdgeExtender.extendAnyDirectedEdges(extension);
        }
        extension.add(previousExtension);
        return extension;
    }

    private static List<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extendAnyDirectedEdges(List<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> previousExtension) {
        ArrayList<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extension = new ArrayList<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>>();
        for (Pair<List<VertexPairConnection>, Map<String, QueryEdge>> pair : previousExtension) {
            extension.addAll(AnyDirectedEdgeExtender.extendAnyDirectedEdges(pair));
        }
        return extension;
    }

    public void visit(QueryExpression.VarRef varRef) {
        QueryEdge edge;
        if (varRef.getVariable().getVariableType() == QueryVariable.VariableType.EDGE && this.extendedEdges.containsKey((edge = (QueryEdge)varRef.getVariable()).getName())) {
            QueryEdge extendedEdge = this.extendedEdges.get(edge.getName());
            edge.setSrc(extendedEdge.getSrc());
            edge.setDst(extendedEdge.getDst());
            edge.setDirection(extendedEdge.getDirection());
        }
    }

    void replaceExtendedEdges(GraphPattern graphPattern, List<ExpAsVar> selectElements) {
        graphPattern.setConnections(new HashSet<VertexPairConnection>(this.connections));
        this.replaceExtendedEdges(graphPattern.getConstraints());
        this.replaceExtendedEdges(selectElements);
    }

    void replaceExtendedEdges(QueryPath queryPath, List<ExpAsVar> selectElements) {
        queryPath.setConnections(this.connections);
        this.replaceExtendedEdges(queryPath.getConstraints());
        this.replaceExtendedEdges(selectElements);
    }

    private void replaceExtendedEdges(Set<QueryExpression> constraints) {
        for (QueryExpression exp : constraints) {
            exp.accept((QueryExpressionVisitor)this);
        }
        this.eliminateSelfEdgesDuplicates(constraints);
    }

    private void replaceExtendedEdges(List<ExpAsVar> selectElements) {
        for (ExpAsVar exp : selectElements) {
            exp.getExp().accept((QueryExpressionVisitor)this);
        }
    }

    private void eliminateSelfEdgesDuplicates(Collection<QueryExpression> constraints) {
        for (QueryEdge edge : this.extendedEdges.values()) {
            if (edge.getDirection() != Direction.INCOMING) continue;
            constraints.add((QueryExpression)new QueryExpression.RelationalExpression.NotEqual((QueryExpression)new QueryExpression.VarRef((QueryVariable)edge.getSrc()), (QueryExpression)new QueryExpression.VarRef((QueryVariable)edge.getDst())));
        }
    }
}

