/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.BindValueInfo;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.PgViewModifyTrans;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.translation.ExpressionTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.QueryTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.TableTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.expression.CreatePtt;
import oracle.pg.rdbms.pgql.pgview.translation.expression.ElementDeletion;
import oracle.pg.rdbms.pgql.pgview.translation.expression.ElementInsertion;
import oracle.pg.rdbms.pgql.pgview.translation.expression.ElementUpdate;
import oracle.pg.rdbms.pgql.pgview.translation.expression.InsertionBlock;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableReference;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pg.rdbms.pgql.pgview.util.TriFunction;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.modify.AbstractInsertion;
import oracle.pgql.lang.ir.modify.DeleteClause;
import oracle.pgql.lang.ir.modify.EdgeInsertion;
import oracle.pgql.lang.ir.modify.InsertClause;
import oracle.pgql.lang.ir.modify.Insertion;
import oracle.pgql.lang.ir.modify.InsertionType;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.ir.modify.SetPropertyExpression;
import oracle.pgql.lang.ir.modify.Update;
import oracle.pgql.lang.ir.modify.UpdateClause;
import oracle.pgql.lang.ir.modify.VertexInsertion;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public class ModifyTranslator {
    static final String COMPOSITE_KEY = "_ora_comp_key_";
    static final String COMPOSITE_KEY_FUNCTION = "_ora_comp_key_f_";

    public static PgViewModifyTrans translateModify(ModifyQuery modifyQuery, final MetadataConnector metadataConnector, BindValueInfo bvInfo) {
        final CreatePtt createPtt = new CreatePtt();
        final List<TableExpression> matchTranslation = ModifyTranslator.translateMatch(modifyQuery, metadataConnector, createPtt);
        final TableTranslator.VariableTableBinding variableTableBinding = TableTranslator.generateVariableTableBinding(modifyQuery.getGraphPattern(), metadataConnector);
        final Set<QueryVertex> patternVertices = ModifyTranslator.getPatternVertices(modifyQuery);
        final ArrayList modifyTranslations = new ArrayList();
        modifyQuery.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(UpdateClause updateClause) {
                modifyTranslations.add(ModifyTranslator.translateUpdate(updateClause, variableTableBinding, metadataConnector, createPtt));
            }

            public void visit(InsertClause insertClause) {
                modifyTranslations.add(ModifyTranslator.translateInsert(insertClause, metadataConnector, patternVertices, matchTranslation != null, createPtt));
            }

            public void visit(DeleteClause deleteClause) {
                modifyTranslations.add(ModifyTranslator.translateDelete(deleteClause, variableTableBinding, metadataConnector, createPtt));
            }
        });
        int bvIdx = 0;
        ArrayList<Pair<String, List<Object>>> patternTranslation = null;
        if (matchTranslation != null) {
            patternTranslation = new ArrayList<Pair<String, List<Object>>>();
            patternTranslation.add(new Pair<String, Object>(matchTranslation.get(0).prettyPrint(), null));
            String select = bvInfo.processBindVariables(matchTranslation.get(1).prettyPrint(), bvIdx);
            String hint = "/*+ */ ";
            if (DbmsUtils.hasWithClause(select)) {
                hint = "/*+ WITH_PLSQL */ ";
            }
            String insert = "INSERT " + hint + "INTO " + "ORA$PTT_MATCH_QUERY" + " " + select;
            List<Object> bindValues = bvInfo.getSqlBvList(bvIdx++);
            patternTranslation.add(new Pair<String, List<Object>>(insert, bindValues));
        }
        ArrayList<List<Pair<String, List<Object>>>> modifications = new ArrayList<List<Pair<String, List<Object>>>>();
        for (List modifyTranslation : modifyTranslations) {
            ArrayList<Pair<String, List<Object>>> modification = new ArrayList<Pair<String, List<Object>>>();
            modifications.add(modification);
            for (TableExpression translation : modifyTranslation) {
                String sql = bvInfo.processBindVariables(translation.prettyPrint(), bvIdx);
                List<Object> bindValues = bvInfo.getSqlBvList(bvIdx++);
                modification.add(new Pair<String, List<Object>>(sql, bindValues));
            }
        }
        return new PgViewModifyTrans(patternTranslation, modifications);
    }

    private static List<TableExpression> translateMatch(ModifyQuery modifyQuery, MetadataConnector metadataConnector, CreatePtt createPtt) {
        ArrayList<TableExpression> matchTranslation = null;
        if (modifyQuery.getGraphPattern() != null) {
            matchTranslation = new ArrayList<TableExpression>();
            matchTranslation.add(createPtt);
            matchTranslation.add(QueryTranslator.translateQuery((GraphQuery)modifyQuery, metadataConnector));
        }
        return matchTranslation;
    }

    private static List<InsertionBlock> translateInsert(InsertClause insertClause, MetadataConnector metadataConnector, Set<QueryVertex> patternVertices, boolean withMatchClause, CreatePtt createPtt) {
        InsertionBlock insertionBlock = new InsertionBlock(withMatchClause);
        for (Insertion insertion : insertClause.getInsertions()) {
            ModifyTranslator.translateInsertion((AbstractInsertion)insertion, metadataConnector, patternVertices, insertionBlock, createPtt);
        }
        return Collections.singletonList(insertionBlock);
    }

    private static void translateInsertion(AbstractInsertion insertion, MetadataConnector metadataConnector, Set<QueryVertex> patternVertices, InsertionBlock insertionBlock, CreatePtt createPtt) {
        Function<String, List> getKey;
        Function<String, SchemaQualifiedName> getTableName;
        Function<String, Set> getTables;
        String elementType;
        QueryEdge element;
        switch (insertion.getInsertionType()) {
            case VERTEX_INSERTION: {
                if (insertion.getProperties().size() == 0) {
                    throw new PgqlToSqlException("Vertex insertion should have at least one property");
                }
                VertexInsertion vertexInsertion = (VertexInsertion)insertion;
                element = vertexInsertion.getVertex();
                elementType = "VERTEX";
                getTables = metadataConnector::getVertexTablesForLabel;
                getTableName = metadataConnector::getSchemaQualifiedVertexTableName;
                getKey = metadataConnector::getVertexTableKey;
                break;
            }
            case EDGE_INSERTION: {
                EdgeInsertion edgeInsertion = (EdgeInsertion)insertion;
                element = edgeInsertion.getEdge();
                elementType = "EDGE";
                getTables = metadataConnector::getEdgeTablesForLabel;
                getTableName = metadataConnector::getSchemaQualifiedEdgeTableName;
                getKey = metadataConnector::getEdgeTableKey;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Insertion type not supported:" + insertion.getInsertionType());
            }
        }
        String variableName = element.getName();
        if (insertion.getLabels().size() != 1) {
            throw new PgqlToSqlException("Only one label is supported. " + elementType + " " + variableName + " has " + insertion.getLabels().size() + " labels");
        }
        String label = (String)((QueryExpression.Constant.ConstString)insertion.getLabels().get(0)).getValue();
        Set tables = getTables.apply(label);
        if (tables.size() == 0) {
            throw new PgqlToSqlException("Cannot insert " + elementType + " " + variableName + ". Label " + label + " does not exist");
        }
        if (tables.size() > 1) {
            throw new PgqlToSqlException("Cannot insert " + elementType + " " + variableName + ". Label " + label + " maps to several tables");
        }
        String table = (String)tables.iterator().next();
        String tableName = new TableReference(getTableName.apply(table), null).prettyPrint();
        ElementInsertion elementInsertion = new ElementInsertion(variableName, tableName, getKey.apply(table));
        for (SetPropertyExpression property : insertion.getProperties()) {
            String value;
            String type;
            String column;
            QueryExpression.PropertyAccess propertyAccess = property.getPropertyAccess();
            QueryVariable variable = ExpressionTranslator.getQueryVariable(propertyAccess.getVariable());
            if (variable.getVariableType() == QueryVariable.VariableType.VERTEX) {
                column = metadataConnector.getColumnNameForVertexTable(table, propertyAccess.getPropertyName());
                type = metadataConnector.getColumnTypeForVertexColumn(table, column);
            } else if (variable.getVariableType() == QueryVariable.VariableType.EDGE) {
                column = metadataConnector.getColumnNameForEdgeTable(table, propertyAccess.getPropertyName());
                type = metadataConnector.getColumnTypeForEdgeColumn(table, column);
            } else {
                throw new UnsupportedOperationException("Unsupported variable type:" + variable.getVariableType());
            }
            column = PgqlUtils.escapeAndEnquoteIdentifier(column);
            if (insertionBlock.hasMatchTable) {
                value = PgqlUtils.escapeAndEnquoteIdentifier(propertyAccess.toString());
                insertionBlock.addVariable(value, elementInsertion.getTableName(), column, true);
                createPtt.addColumn(value, type);
            } else {
                value = property.getValueExpression().getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE ? BindValueInfo.getBvEncoding((QueryExpression.BindVariable)property.getValueExpression()) : property.valueExpression.toString();
            }
            elementInsertion.addValue(value, column);
        }
        if (insertion.getInsertionType() == InsertionType.EDGE_INSERTION) {
            QueryEdge edge = element;
            ModifyTranslator.insertSrcOrDstKey(metadataConnector.getEdgeTableSrcKey(table), patternVertices, edge.getSrc(), metadataConnector.getSrcTable(table), insertionBlock, elementInsertion, createPtt, metadataConnector);
            ModifyTranslator.insertSrcOrDstKey(metadataConnector.getEdgeTableDstKey(table), patternVertices, edge.getDst(), metadataConnector.getDstTable(table), insertionBlock, elementInsertion, createPtt, metadataConnector);
        }
        insertionBlock.addInsert(elementInsertion);
    }

    private static void insertSrcOrDstKey(List<Pair<String, String>> keyColumns, Set<QueryVertex> patternVertices, QueryVertex vertex, String table, InsertionBlock insertionBlock, ElementInsertion elementInsertion, CreatePtt createPtt, MetadataConnector metadataConnector) {
        for (int i = 0; i < keyColumns.size(); ++i) {
            String value;
            Pair<String, String> keyColumn = keyColumns.get(i);
            String column = PgqlUtils.escapeAndEnquoteIdentifier((String)keyColumn.first);
            if (patternVertices.contains(vertex)) {
                value = PgqlUtils.escapeAndEnquoteIdentifier(new QueryExpression.VarRef((QueryVariable)vertex).toString() + "_" + i);
                String type = metadataConnector.getColumnTypeForVertexColumn(table, (String)keyColumn.second);
                createPtt.addColumn(value, type);
                insertionBlock.addVariable(value, elementInsertion.getTableName(), column, true);
            } else {
                value = PgqlUtils.escapeAndEnquoteIdentifier(vertex.getName() + "_" + (String)keyColumn.second);
            }
            elementInsertion.addValue(value, column);
        }
    }

    private static List<ElementUpdate> translateUpdate(UpdateClause updateClause, TableTranslator.VariableTableBinding variableTableBinding, MetadataConnector metadataConnector, CreatePtt createPtt) {
        ArrayList<ElementUpdate> updates = new ArrayList<ElementUpdate>();
        if (variableTableBinding != null) {
            block4: for (Update update : updateClause.getUpdates()) {
                QueryVariable element = ExpressionTranslator.getQueryVariable(update.getElement());
                switch (element.getVariableType()) {
                    case VERTEX: {
                        updates.addAll(ModifyTranslator.translateUpdateElement(update, element, metadataConnector, createPtt, variableTableBinding.vertexTableMap, MetadataConnector::getSchemaQualifiedVertexTableName, MetadataConnector::getVertexTableKey, MetadataConnector::getColumnNameForVertexTable, MetadataConnector::getColumnTypeForVertexColumn));
                        continue block4;
                    }
                    case EDGE: {
                        updates.addAll(ModifyTranslator.translateUpdateElement(update, element, metadataConnector, createPtt, variableTableBinding.edgeTableMap, MetadataConnector::getSchemaQualifiedEdgeTableName, MetadataConnector::getEdgeTableKey, MetadataConnector::getColumnNameForEdgeTable, MetadataConnector::getColumnTypeForEdgeColumn));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Cannot update variable " + element.getName() + " of type " + element.getVariableType());
            }
        }
        return updates;
    }

    private static List<ElementUpdate> translateUpdateElement(Update update, QueryVariable element, MetadataConnector metadataConnector, CreatePtt createPtt, Map<? extends QueryVariable, Set<String>> tableMap, BiFunction<MetadataConnector, String, SchemaQualifiedName> getTableName, BiFunction<MetadataConnector, String, List<String>> getKey, TriFunction<MetadataConnector, String, String, String> getColumn, TriFunction<MetadataConnector, String, String, String> getType) {
        ArrayList<ElementUpdate> updates = new ArrayList<ElementUpdate>();
        if (tableMap.containsKey(element)) {
            String alias = update.getElement().toString();
            QueryVariable var = update.getElement().getVariable();
            for (String tab : tableMap.get(element)) {
                List<String> key = getKey.apply(metadataConnector, tab);
                String variable = !var.isAnonymous() && var.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR ? ((ExpAsVar)var).getExp().toString() : alias;
                alias = PgqlUtils.escapeAndEnquoteIdentifier(alias);
                ElementUpdate elementUpdate = new ElementUpdate(getTableName.apply(metadataConnector, tab), variable, alias);
                elementUpdate.setKeyVariable(ModifyTranslator.buildCompositeKey(tab, key));
                for (SetPropertyExpression property : update.getSetPropertyExpressions()) {
                    QueryExpression.PropertyAccess propertyAccess = property.getPropertyAccess();
                    String column = getColumn.apply(metadataConnector, tab, propertyAccess.getPropertyName());
                    if (column == null) {
                        throw new IllegalArgumentException("Element " + update.getElement() + " cannot be updated. Property " + property.getPropertyAccess() + " does not exist for table " + tab);
                    }
                    String type = getType.apply(metadataConnector, tab, column);
                    createPtt.addColumn(PgqlUtils.escapeAndEnquoteIdentifier(propertyAccess.toString()), type);
                    String value = PgqlUtils.escapeAndEnquoteIdentifier(property.getPropertyAccess().toString());
                    elementUpdate.addSetVariable(PgqlUtils.escapeAndEnquoteIdentifier(column), value);
                }
                createPtt.addColumn(alias, "VARCHAR2(4000)");
                updates.add(elementUpdate);
            }
        }
        return updates;
    }

    private static List<ElementDeletion> translateDelete(DeleteClause deleteClause, TableTranslator.VariableTableBinding variableTableBinding, MetadataConnector metadataConnector, CreatePtt createPtt) {
        ArrayList<ElementDeletion> deletes = new ArrayList<ElementDeletion>();
        if (variableTableBinding != null) {
            block4: for (QueryExpression.VarRef deletion : deleteClause.getDeletions()) {
                String alias = PgqlUtils.escapeAndEnquoteIdentifier(deletion.toString());
                createPtt.addColumn(alias, "VARCHAR2(4000)");
                QueryVariable element = ExpressionTranslator.getQueryVariable(deletion);
                switch (element.getVariableType()) {
                    case VERTEX: {
                        deletes.addAll(ModifyTranslator.translateDeleteElement(element, metadataConnector, alias, variableTableBinding.vertexTableMap, MetadataConnector::getSchemaQualifiedVertexTableName, MetadataConnector::getVertexTableKey));
                        continue block4;
                    }
                    case EDGE: {
                        deletes.addAll(ModifyTranslator.translateDeleteElement(element, metadataConnector, alias, variableTableBinding.edgeTableMap, MetadataConnector::getSchemaQualifiedEdgeTableName, MetadataConnector::getEdgeTableKey));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Cannot delete variable " + element.getName() + " of type " + element.getVariableType());
            }
        }
        return deletes;
    }

    private static List<ElementDeletion> translateDeleteElement(QueryVariable element, MetadataConnector metadataConnector, String alias, Map<? extends QueryVariable, Set<String>> tableMap, BiFunction<MetadataConnector, String, SchemaQualifiedName> getTableName, BiFunction<MetadataConnector, String, List<String>> getKey) {
        ArrayList<ElementDeletion> deletes = new ArrayList<ElementDeletion>();
        if (tableMap.containsKey(element)) {
            for (String tab : tableMap.get(element)) {
                List<String> key = getKey.apply(metadataConnector, tab);
                if (element.getVariableType() == QueryVariable.VariableType.VERTEX) {
                    deletes.addAll(ModifyTranslator.deleteAdjacentEdges(tab, alias, metadataConnector, MetadataConnector::getInputTables, MetadataConnector::getEdgeTableDstKey));
                    deletes.addAll(ModifyTranslator.deleteAdjacentEdges(tab, alias, metadataConnector, MetadataConnector::getOutputTables, MetadataConnector::getEdgeTableSrcKey));
                }
                String compositeKey = ModifyTranslator.buildCompositeKey(tab, key);
                deletes.add(new ElementDeletion(getTableName.apply(metadataConnector, tab), compositeKey, alias));
            }
        }
        return deletes;
    }

    private static List<ElementDeletion> deleteAdjacentEdges(String table, String alias, MetadataConnector metadataConnector, BiFunction<MetadataConnector, String, Set<String>> getTables, BiFunction<MetadataConnector, String, List<Pair<String, String>>> getKey) {
        ArrayList<ElementDeletion> deletions = new ArrayList<ElementDeletion>();
        Set<String> tables = getTables.apply(metadataConnector, table);
        for (String tab : tables) {
            SchemaQualifiedName tableName = metadataConnector.getSchemaQualifiedEdgeTableName(tab);
            List<Pair<String, String>> key = getKey.apply(metadataConnector, tab);
            List<String> keyColumns = key.stream().map(pair -> (String)pair.first).collect(Collectors.toList());
            String compositeKey = ModifyTranslator.buildCompositeKey(table, keyColumns);
            deletions.add(new ElementDeletion(tableName, compositeKey, alias));
        }
        return deletions;
    }

    private static String buildCompositeKey(String elementTable, List<String> key) {
        return DbmsUtils.escapeAndEnquoteLiteral(elementTable, false) + " || '(' || " + key.stream().map(PgqlUtils::escapeAndEnquoteIdentifier).collect(Collectors.joining("|| ',' ||")) + " || ')'";
    }

    static List<ExpAsVar> generateSelectElements(ModifyQuery modifyQuery, final MetadataConnector metadataConnector) {
        final HashSet addedVars = new HashSet();
        final ArrayList<ExpAsVar> selectElements = new ArrayList<ExpAsVar>();
        final Set<QueryVertex> patternVertices = ModifyTranslator.getPatternVertices(modifyQuery);
        final TableTranslator.VariableTableBinding variableTableBinding = TableTranslator.generateVariableTableBinding(modifyQuery.getGraphPattern(), metadataConnector);
        modifyQuery.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(SetPropertyExpression property) {
                String var = property.getPropertyAccess().toString();
                if (!addedVars.contains(var)) {
                    selectElements.add(new ExpAsVar(property.getValueExpression(), var, true));
                    addedVars.add(var);
                }
            }

            public void visit(EdgeInsertion edgeInsertion) {
                super.visit(edgeInsertion);
                this.addEdge(edgeInsertion.getEdge());
            }

            private void addEdge(QueryEdge queryEdge) {
                this.addVertex(queryEdge.getSrc());
                this.addVertex(queryEdge.getDst());
            }

            private void addVertex(QueryVertex queryVertex) {
                if (patternVertices.contains(queryVertex)) {
                    int numKeyColumns = metadataConnector.getVertexTableKey(variableTableBinding.vertexTableMap.get(queryVertex).iterator().next()).size();
                    String var = ModifyTranslator.COMPOSITE_KEY + queryVertex.getName() + "_" + numKeyColumns;
                    if (!addedVars.contains(var)) {
                        selectElements.add(new ExpAsVar((QueryExpression)new QueryExpression.FunctionCall(ModifyTranslator.COMPOSITE_KEY_FUNCTION, Collections.singletonList(new QueryExpression.VarRef((QueryVariable)queryVertex))), var, true));
                        addedVars.add(var);
                    }
                }
            }

            public void visit(Update update) {
                super.visit(update);
                this.addVarRef(update.getElement());
            }

            public void visit(DeleteClause deleteClause) {
                deleteClause.getDeletions().forEach(this::addVarRef);
            }

            private void addVarRef(QueryExpression.VarRef varRef) {
                String var = varRef.toString();
                if (!addedVars.contains(var)) {
                    selectElements.add(new ExpAsVar((QueryExpression)varRef, var, false));
                    addedVars.add(var);
                }
            }
        });
        return selectElements;
    }

    private static Set<QueryVertex> getPatternVertices(ModifyQuery modifyQuery) {
        HashSet<QueryVertex> patternVertices = new HashSet<QueryVertex>();
        if (modifyQuery.getGraphPattern() != null) {
            patternVertices.addAll(modifyQuery.getGraphPattern().getVertices());
            modifyQuery.getGraphPattern().getConnections().forEach(connection -> {
                patternVertices.add(connection.getSrc());
                patternVertices.add(connection.getDst());
            });
        }
        return patternVertices;
    }
}

