/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.translation.AnyDirectedEdgeExtender;
import oracle.pg.rdbms.pgql.pgview.translation.QueryTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.TableTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.TranslationInfo;
import oracle.pg.rdbms.pgql.pgview.translation.expression.EmptyProjection;
import oracle.pg.rdbms.pgql.pgview.translation.expression.RecursiveWith;
import oracle.pg.rdbms.pgql.pgview.translation.expression.ShortestPath;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;
import oracle.pg.rdbms.pgql.pgview.translation.expression.Union;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.PathFindingGoal;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.unnest.RowsPerMatchType;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public class PathTranslator {
    public static final String PATH_VERTEX_PREFIX = "$_";
    public static final String SRC_PATH_VERTEX = "$_src";
    public static final String DST_PATH_VERTEX = "$_dst";

    static TableExpression translatePath(QueryPath queryPath, Map<QueryVariable, String> variableTableMap, MetadataConnector metadataConnector, TranslationInfo translationInfo) {
        if (queryPath.getPathFindingGoal() == PathFindingGoal.CHEAPEST) {
            throw new UnsupportedOperationException("CHEAPEST finding goal is not supported");
        }
        if (queryPath.getPathFindingGoal() == PathFindingGoal.SHORTEST && queryPath.getWithTies()) {
            throw new UnsupportedOperationException("ALL SHORTEST finding goal is not supported");
        }
        if (queryPath.getRowsPerMatch().getRowsPerMatchType() != RowsPerMatchType.ONE_ROW_PER_MATCH) {
            throw new UnsupportedOperationException("Only ONE ROW PER MATCH is supported");
        }
        Pair<Set<QueryExpression>, Set<QueryExpression>> constraints = translationInfo.getPathConstraints(queryPath);
        Set srcConstraints = (Set)constraints.first;
        Set dstConstraints = (Set)constraints.second;
        ArrayList<ExpAsVar> subSelectElems = new ArrayList<ExpAsVar>();
        List vertices = queryPath.getVertices();
        if (vertices.size() < 2) {
            throw new UnsupportedOperationException("Need at least one connection in path pattern");
        }
        subSelectElems.add(new ExpAsVar((QueryExpression)new QueryExpression.VarRef((QueryVariable)vertices.get(0)), SRC_PATH_VERTEX, true));
        subSelectElems.add(new ExpAsVar((QueryExpression)new QueryExpression.VarRef((QueryVariable)vertices.get(vertices.size() - 1)), DST_PATH_VERTEX, true));
        Map<QueryExpression.Aggregation, PathAggregateInfo> pathAggregations = translationInfo.getPathAggregations();
        QueryExpression expressions = pathAggregations.keySet().stream().filter(agg -> ((PathAggregateInfo)pathAggregations.get((Object)agg)).queryPath.equals((Object)queryPath)).map(agg -> (QueryExpression.Aggregation.AbstractAggregation)agg).map(agg -> {
            PathTranslator.checkBindVariables(agg.getExp());
            String expTag = "EXP" + ((PathAggregateInfo)pathAggregations.get((Object)agg)).expNumber;
            return new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.Constant.ConstString("<" + expTag + ">"), agg.getExp()), (QueryExpression)new QueryExpression.Constant.ConstString("</" + expTag + ">"));
        }).reduce(QueryExpression.ConcatExpression::new).orElse((QueryExpression)new QueryExpression.Constant.ConstString(""));
        QueryExpression.ConcatExpression pathExpressions = new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.Constant.ConstString("<EXPRESSIONS>"), expressions), (QueryExpression)new QueryExpression.Constant.ConstString("</EXPRESSIONS>"));
        subSelectElems.add(new ExpAsVar((QueryExpression)pathExpressions, "exp", true));
        List<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extendedConnections = AnyDirectedEdgeExtender.extendAnyDirectedEdges(new Pair<List<VertexPairConnection>, Map<String, QueryEdge>>(new ArrayList(queryPath.getConnections()), new HashMap()));
        TableExpression tab = extendedConnections.stream().map(pair -> {
            if (extendedConnections.size() > 1) {
                AnyDirectedEdgeExtender edgeReplacer = new AnyDirectedEdgeExtender((Pair<List<VertexPairConnection>, Map<String, QueryEdge>>)pair);
                edgeReplacer.replaceExtendedEdges(queryPath, (List<ExpAsVar>)subSelectElems);
            }
            TableTranslator.VariableTableBinding variableTableBinding = TableTranslator.generateVariableTableBinding(queryPath, metadataConnector);
            List<Map<QueryVariable, String>> patternInstantiation = TableTranslator.generateAllPatternInstantiations(queryPath, variableTableBinding, metadataConnector);
            pathAggregations.keySet().stream().filter(agg -> ((PathAggregateInfo)pathAggregations.get((Object)agg)).queryPath.equals((Object)queryPath)).map(agg -> (QueryExpression.Aggregation.AbstractAggregation)agg).forEach(agg -> {
                if ((agg.getExpType() == QueryExpression.ExpressionType.AGGR_MAX || agg.getExpType() == QueryExpression.ExpressionType.AGGR_MIN) && agg.getExp().getExpType().equals((Object)QueryExpression.ExpressionType.PROP_ACCESS)) {
                    QueryExpression.PropertyAccess pa = (QueryExpression.PropertyAccess)agg.getExp();
                    String dataType = null;
                    block4: for (int i = 0; i < patternInstantiation.size() && dataType == null; ++i) {
                        String tableName = (String)((Map)patternInstantiation.get(i)).get(pa.getVariable());
                        switch (pa.getVariable().getVariableType()) {
                            case VERTEX: {
                                dataType = metadataConnector.getColumnTypeForVertexProperty(tableName, pa.getPropertyName());
                                continue block4;
                            }
                            case EDGE: {
                                dataType = metadataConnector.getColumnTypeForEdgeProperty(tableName, pa.getPropertyName());
                            }
                        }
                    }
                    if (dataType == null) {
                        dataType = "varchar2(4000)";
                    }
                    ((PathAggregateInfo)pathAggregations.get((Object)agg)).dataType = dataType;
                }
            });
            return PathTranslator.generateTranslation(patternInstantiation, queryPath, subSelectElems, metadataConnector, Collections.emptyMap());
        }).filter(tableExpression -> !tableExpression.getClass().equals(EmptyProjection.class)).reduce(Union::new).orElse(new EmptyProjection(subSelectElems));
        String patternTranslation = tab.prettyPrint();
        String srcTranslation = PathTranslator.generateTranslation(variableTableMap, queryPath.getSrc(), SRC_PATH_VERTEX, srcConstraints, metadataConnector, Collections.emptyMap()).prettyPrint();
        if (queryPath.getPathFindingGoal() == PathFindingGoal.ALL) {
            return new RecursiveWith((QueryVariable)queryPath, srcTranslation, "", patternTranslation, queryPath.getKValue(), queryPath.getMinHops(), queryPath.getMaxHops());
        }
        patternTranslation = DbmsUtils.splitClobInChunks(patternTranslation);
        srcTranslation = DbmsUtils.splitClobInChunks(srcTranslation);
        String dstTranslation = DbmsUtils.splitClobInChunks(PathTranslator.generateTranslation(variableTableMap, queryPath.getDst(), DST_PATH_VERTEX, dstConstraints, metadataConnector, Collections.emptyMap()).prettyPrint());
        return new ShortestPath((QueryVariable)queryPath, srcTranslation, dstTranslation, patternTranslation, queryPath.getKValue(), queryPath.getMinHops(), queryPath.getMaxHops());
    }

    static TableExpression generateTranslation(List<Map<QueryVariable, String>> patternInstantiations, QueryPath queryPath, List<ExpAsVar> subSelectElems, MetadataConnector metadataConnector, Map<QueryExpression.Aggregation, PathAggregateInfo> pathAggregations) {
        return QueryTranslator.generateTranslation(patternInstantiations, new HashSet<QueryVertex>(queryPath.getVertices()), new HashSet<VertexPairConnection>(queryPath.getConnections()), queryPath.getConstraints(), subSelectElems, metadataConnector, pathAggregations);
    }

    static TableExpression generateTranslation(Map<QueryVariable, String> patternInstantiation, QueryVertex queryVertex, String variableName, Set<QueryExpression> constraints, MetadataConnector metadataConnector, Map<QueryExpression.Aggregation, PathAggregateInfo> pathAggregations) {
        List<ExpAsVar> subSelectElems = Collections.singletonList(new ExpAsVar((QueryExpression)new QueryExpression.VarRef((QueryVariable)queryVertex), variableName, true));
        return QueryTranslator.generateTranslation(Collections.singletonList(patternInstantiation), Collections.singleton(queryVertex), Collections.emptySet(), constraints, subSelectElems, metadataConnector, pathAggregations);
    }

    static Pair<Set<QueryExpression>, Set<QueryExpression>> getSrcAndDstConstraints(QueryPath queryPath, Set<QueryExpression> parentConstraints, Map<QueryExpression.Aggregation, PathAggregateInfo> pathAggregations) {
        HashSet<QueryExpression> srcConstraints = new HashSet<QueryExpression>();
        HashSet<QueryExpression> dstConstraints = new HashSet<QueryExpression>();
        for (QueryExpression constraint : parentConstraints) {
            Set variables = PgqlUtils.getVariables((QueryExpression)constraint);
            if (variables.stream().allMatch(variable -> variable.equals((Object)queryPath.getSrc()))) {
                srcConstraints.add(constraint);
            }
            if (!variables.stream().allMatch(variable -> variable.equals((Object)queryPath.getDst()))) continue;
            dstConstraints.add(constraint);
        }
        if (PathTranslator.useWithClause(queryPath)) {
            PathTranslator.checkBindVariables(srcConstraints);
            PathTranslator.checkBindVariables(dstConstraints);
            PathTranslator.checkBindVariables(queryPath.getConstraints());
        }
        if (dstConstraints.size() > srcConstraints.size()) {
            PathTranslator.reversePath(queryPath);
            HashSet<QueryExpression> aux = dstConstraints;
            dstConstraints = srcConstraints;
            srcConstraints = aux;
            pathAggregations.values().forEach(info -> {
                info.isReversed = true;
            });
        }
        return new Pair<Set<QueryExpression>, Set<QueryExpression>>(srcConstraints, dstConstraints);
    }

    static boolean isPathVertex(ExpAsVar expAsVar) {
        return expAsVar.getName().startsWith(PATH_VERTEX_PREFIX);
    }

    static boolean useWithClause(QueryPath path) {
        return path.getPathFindingGoal() != PathFindingGoal.ALL;
    }

    static void checkBindVariables(Set<QueryExpression> queryExpressions) {
        queryExpressions.forEach(PathTranslator::checkBindVariables);
    }

    static void checkBindVariables(QueryExpression queryExpression) {
        queryExpression.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.BindVariable bv) {
                throw new UnsupportedOperationException("Use of bind variables for path queries is not supported");
            }
        });
    }

    private static void reversePath(QueryPath queryPath) {
        Collections.reverse(queryPath.getConnections());
        Collections.reverse(queryPath.getVertices());
        QueryVertex aux = queryPath.getDst();
        queryPath.setDst(queryPath.getSrc());
        queryPath.setSrc(aux);
    }

    static class PathAggregateInfo {
        QueryPath queryPath;
        boolean isReversed;
        int expNumber;
        String dataType;

        public PathAggregateInfo(QueryPath queryPath, int expNumber, String dataType) {
            this.queryPath = queryPath;
            this.expNumber = expNumber;
            this.dataType = dataType;
            this.isReversed = false;
        }
    }
}

