/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.translation.AnyDirectedEdgeExtender;
import oracle.pg.rdbms.pgql.pgview.translation.ExpressionTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.LabelTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.ModifyTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.PathTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.TableTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.TranslationInfo;
import oracle.pg.rdbms.pgql.pgview.translation.expression.EmptyProjection;
import oracle.pg.rdbms.pgql.pgview.translation.expression.Projection;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableReference;
import oracle.pg.rdbms.pgql.pgview.translation.expression.Union;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public class QueryTranslator {
    private static final String WITH_CLAUSE = QueryTranslator.getWithClause();

    public static TableExpression translateQuery(GraphQuery graphQuery, MetadataConnector metadataConnector) {
        boolean isDistinct;
        List<ExpAsVar> selectElements;
        if (graphQuery.getQueryType() == QueryType.SELECT) {
            SelectQuery selectQuery = (SelectQuery)graphQuery;
            selectElements = selectQuery.getProjection().getElements();
            isDistinct = selectQuery.getProjection().isDistinct();
        } else if (graphQuery.getQueryType() == QueryType.MODIFY) {
            selectElements = ModifyTranslator.generateSelectElements((ModifyQuery)graphQuery, metadataConnector);
            isDistinct = false;
        } else {
            throw new UnsupportedOperationException("Query type not supported:" + graphQuery.getQueryType());
        }
        GraphPattern graphPattern = graphQuery.getGraphPattern();
        HashMap<QueryVariable, QueryPath> pathVariables = new HashMap<QueryVariable, QueryPath>();
        graphPattern.getConnections().stream().filter(conn -> conn.getVariableType() == QueryVariable.VariableType.PATH).forEach(conn -> {
            QueryPath path = (QueryPath)conn;
            path.getVertices().forEach(vertex -> pathVariables.put((QueryVariable)vertex, path));
            path.getConnections().forEach(connection -> pathVariables.put((QueryVariable)connection, path));
        });
        HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations = new HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo>();
        ArrayList<ExpAsVar> subSelectElems = new ArrayList<ExpAsVar>();
        HashSet<String> subSelectVars = new HashSet<String>();
        for (ExpAsVar expAsVar : selectElements) {
            QueryTranslator.addSubSelectElements(expAsVar.getExp(), subSelectElems, subSelectVars, pathAggregations, pathVariables, true);
        }
        List<ExpAsVar> groupByElements = new ArrayList();
        if (graphQuery.getGroupBy() != null) {
            groupByElements = graphQuery.getGroupBy().getElements();
            for (ExpAsVar groupByElem : groupByElements) {
                QueryTranslator.addSubSelectElements(groupByElem.getExp(), subSelectElems, subSelectVars, pathAggregations, pathVariables, true);
            }
        }
        List list = graphQuery.getOrderBy().getElements();
        for (Object orderByElem : list) {
            QueryTranslator.addSubSelectElements(orderByElem.getExp(), subSelectElems, subSelectVars, pathAggregations, pathVariables, true);
        }
        QueryExpression havingExp = graphQuery.getHaving();
        if (havingExp != null) {
            QueryTranslator.addSubSelectElements(havingExp, subSelectElems, subSelectVars, pathAggregations, pathVariables, true);
        }
        for (QueryExpression whereConstraint : graphPattern.getConstraints()) {
            QueryTranslator.addSubSelectElements(whereConstraint, subSelectElems, subSelectVars, pathAggregations, pathVariables, false);
        }
        List<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extendedConnections = AnyDirectedEdgeExtender.extendAnyDirectedEdges(new Pair<List<VertexPairConnection>, Map<String, QueryEdge>>(new ArrayList(graphPattern.getConnections()), new HashMap()));
        TableExpression tab = extendedConnections.stream().map(extension -> {
            if (extendedConnections.size() > 1) {
                AnyDirectedEdgeExtender edgeExtender = new AnyDirectedEdgeExtender((Pair<List<VertexPairConnection>, Map<String, QueryEdge>>)extension);
                edgeExtender.replaceExtendedEdges(graphPattern, (List<ExpAsVar>)subSelectElems);
            }
            TableTranslator.VariableTableBinding variableTableBinding = TableTranslator.generateVariableTableBinding(graphPattern, metadataConnector);
            List<Map<QueryVariable, String>> patternInstantiation = TableTranslator.generateAllPatternInstantiations(graphPattern, variableTableBinding, metadataConnector);
            return QueryTranslator.generateTranslation(patternInstantiation, graphPattern, subSelectElems, metadataConnector, pathAggregations);
        }).filter(tableExpression -> !tableExpression.getClass().equals(EmptyProjection.class)).reduce(Union::new).orElse(new EmptyProjection(subSelectElems));
        return QueryTranslator.wrapForModificators(tab, graphPattern.getConnections().stream().anyMatch(conn -> conn.getVariableType() == QueryVariable.VariableType.PATH && PathTranslator.useWithClause((QueryPath)conn)), selectElements, isDistinct, groupByElements, list, havingExp, graphQuery.getOffset(), graphQuery.getLimit(), pathAggregations);
    }

    static TableExpression generateTranslation(List<Map<QueryVariable, String>> patternInstantiations, GraphPattern graphPattern, List<ExpAsVar> subSelectElems, MetadataConnector metadataConnector, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations) {
        return QueryTranslator.generateTranslation(patternInstantiations, graphPattern.getVertices(), graphPattern.getConnections(), graphPattern.getConstraints(), subSelectElems, metadataConnector, pathAggregations);
    }

    static TableExpression generateTranslation(List<Map<QueryVariable, String>> patternInstantiations, Set<QueryVertex> vertices, Set<VertexPairConnection> connections, Set<QueryExpression> constraints, List<ExpAsVar> subSelectElems, MetadataConnector metadataConnector, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations) {
        TranslationInfo translationInfo = new TranslationInfo(subSelectElems, connections, constraints, pathAggregations);
        ArrayList<Projection> allProjections = new ArrayList<Projection>();
        for (Map<QueryVariable, String> instantiation : patternInstantiations) {
            List<TableExpression> tables = QueryTranslator.getTables(vertices, connections, instantiation, translationInfo, metadataConnector);
            QueryExpression filterWhere = QueryTranslator.translateWhere(constraints, instantiation, metadataConnector, translationInfo);
            QueryExpression joinWhere = QueryTranslator.getJoinFilter(translationInfo, instantiation, metadataConnector);
            QueryExpression where = QueryTranslator.normalize((QueryExpression)new QueryExpression.LogicalExpression.And(joinWhere, filterWhere));
            List<Pair<String, String>> solutionBlockSpecificSelectElements = QueryTranslator.generateSpecificSelectElements(subSelectElems, instantiation, metadataConnector, translationInfo);
            Projection projection2 = new Projection(false, "", solutionBlockSpecificSelectElements, tables, QueryTranslator.getWhereString(where, pathAggregations), Collections.emptyList(), null, Collections.emptyList(), "", "");
            allProjections.add(projection2);
        }
        return allProjections.stream().map(projection -> projection).reduce(Union::new).orElse(new EmptyProjection(subSelectElems));
    }

    private static List<Pair<String, String>> generateSpecificSelectElements(List<ExpAsVar> selectElements, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, TranslationInfo translationInfo) {
        ArrayList<Pair<String, String>> translatedExpressions = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < selectElements.size(); ++i) {
            ExpAsVar expAsVar = selectElements.get(i);
            QueryExpression translatedExpression = ExpressionTranslator.translateForSubSelect(expAsVar.getExp(), new ExpressionTranslator.SubSelectTransOptions(conf, metadataConnector, false, translationInfo));
            QueryExpression exp = expAsVar.getExp();
            if (exp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)exp).getFunctionName().equals("_ora_comp_key_f_") && translatedExpression.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)translatedExpression).getFunctionName().equals("_ora_comp_key_f_")) {
                String varName = ((QueryExpression)((QueryExpression.FunctionCall)exp).getArgs().get(0)).toString();
                QueryExpression.FunctionCall function = (QueryExpression.FunctionCall)translatedExpression;
                for (int j = 0; j < function.getArgs().size(); ++j) {
                    QueryExpression.PropertyAccess prop = (QueryExpression.PropertyAccess)function.getArgs().get(j);
                    translatedExpressions.add(new Pair<String, String>(prop.toString(), varName + "_" + j));
                }
                continue;
            }
            if (PathTranslator.isPathVertex(expAsVar)) {
                QueryExpression tableExp = ((QueryExpression.ConcatExpression)((QueryExpression.ConcatExpression)((QueryExpression.ConcatExpression)translatedExpression).getExp1()).getExp1()).getExp1();
                QueryExpression keyExp = ((QueryExpression.ConcatExpression)((QueryExpression.ConcatExpression)translatedExpression).getExp1()).getExp2();
                keyExp = QueryTranslator.escapeforPath(keyExp, false);
                String alias = expAsVar.getName().substring(2);
                translatedExpressions.add(new Pair<String, String>(tableExp.toString(), alias + "_table"));
                translatedExpressions.add(new Pair<String, String>(keyExp.toString(), alias + "_key"));
                continue;
            }
            String alias = null;
            if (!QueryExpression.ExpressionType.STAR.equals((Object)translatedExpression.getExpType())) {
                alias = expAsVar.getName();
            }
            translatedExpressions.add(new Pair<String, String>(translatedExpression.toString(), alias));
        }
        return translatedExpressions;
    }

    private static QueryExpression escapeforPath(QueryExpression keyExp, boolean escapeCommas) {
        if (keyExp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)keyExp).getFunctionName().equalsIgnoreCase("DECODE")) {
            QueryExpression.FunctionCall fc1 = (QueryExpression.FunctionCall)keyExp;
            QueryExpression.FunctionCall fc2 = (QueryExpression.FunctionCall)fc1.getArgs().get(0);
            keyExp = (QueryExpression)fc2.getArgs().get(0);
            if (escapeCommas) {
                keyExp = ExpressionTranslator.escapeCommas(keyExp);
            }
        } else if (keyExp.getExpType() == QueryExpression.ExpressionType.CONCAT) {
            QueryExpression.ConcatExpression ce = (QueryExpression.ConcatExpression)keyExp;
            QueryExpression.ConcatExpression exp1 = (QueryExpression.ConcatExpression)ce.getExp1();
            exp1.setExp1(QueryTranslator.escapeforPath(exp1.getExp1(), true));
            ce.setExp2(QueryTranslator.escapeforPath(ce.getExp2(), true));
        }
        return keyExp;
    }

    private static QueryExpression normalize(QueryExpression queryExpression) {
        if (queryExpression.getExpType() == QueryExpression.ExpressionType.AND) {
            QueryExpression.Constant.ConstBoolean constantExpression;
            QueryExpression.LogicalExpression.And andExpression = (QueryExpression.LogicalExpression.And)queryExpression;
            QueryExpression expr1 = QueryTranslator.normalize(andExpression.getExp1());
            QueryExpression expr2 = QueryTranslator.normalize(andExpression.getExp2());
            if (expr1.getExpType() == QueryExpression.ExpressionType.BOOLEAN && ((Boolean)(constantExpression = (QueryExpression.Constant.ConstBoolean)expr1).getValue()).booleanValue()) {
                return expr2;
            }
            if (expr2.getExpType() == QueryExpression.ExpressionType.BOOLEAN && ((Boolean)(constantExpression = (QueryExpression.Constant.ConstBoolean)expr2).getValue()).booleanValue()) {
                return expr1;
            }
            return new QueryExpression.LogicalExpression.And(expr1, expr2);
        }
        return queryExpression;
    }

    private static String getWhereString(QueryExpression whereExpression, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations) {
        if (whereExpression.getExpType() == QueryExpression.ExpressionType.BOOLEAN) {
            QueryExpression.Constant.ConstBoolean boolExpr = (QueryExpression.Constant.ConstBoolean)whereExpression;
            if (((Boolean)boolExpr.getValue()).booleanValue()) {
                return "";
            }
            return "1 <> 1";
        }
        return ExpressionTranslator.translateQueryExpression(whereExpression, new ExpressionTranslator.QueryExpTransOptions(false, false, true, pathAggregations));
    }

    private static QueryExpression getJoinFilter(TranslationInfo translationInfo, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression.Constant.ConstBoolean joinFilter = new QueryExpression.Constant.ConstBoolean(true);
        Map<QueryVariable, List<Pair<VertexPairConnection, TranslationInfo.Position>>> vertexConnections = translationInfo.getVertexConnections();
        for (QueryVariable v : vertexConnections.keySet()) {
            List<Pair<VertexPairConnection, TranslationInfo.Position>> connections = vertexConnections.get(v);
            if (connections.size() > 1) {
                Pair<VertexPairConnection, TranslationInfo.Position> pos1 = connections.get(0);
                for (int i = 1; i < connections.size(); ++i) {
                    Pair<VertexPairConnection, TranslationInfo.Position> pos2 = connections.get(i);
                    joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, QueryTranslator.getConnectionsJoin(pos1, pos2, conf, metadataConnector));
                    pos1 = pos2;
                }
            }
            if (translationInfo.needVertexEdgeJoin(v)) {
                joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, QueryTranslator.getVertexConnectionJoin(connections.get(0), (QueryVertex)v, conf, metadataConnector));
                continue;
            }
            Pair<VertexPairConnection, TranslationInfo.Position> edge = translationInfo.getEdgeConnection(v);
            if (edge == null) continue;
            joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, QueryTranslator.getEdgeKeyNotNull(edge, conf, metadataConnector));
        }
        return joinFilter;
    }

    private static QueryExpression getConnectionsJoin(Pair<VertexPairConnection, TranslationInfo.Position> pos1, Pair<VertexPairConnection, TranslationInfo.Position> pos2, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        VertexPairConnection conn1 = (VertexPairConnection)pos1.first;
        VertexPairConnection conn2 = (VertexPairConnection)pos2.first;
        if (conn1.getVariableType() == QueryVariable.VariableType.EDGE && conn2.getVariableType() == QueryVariable.VariableType.EDGE) {
            List<String> key1 = QueryTranslator.getEdgeSrcOrDstKey(pos1, conf, metadataConnector);
            List<String> key2 = QueryTranslator.getEdgeSrcOrDstKey(pos2, conf, metadataConnector);
            for (int i = 0; i < key1.size(); ++i) {
                QueryExpression.PropertyAccess key1Access = new QueryExpression.PropertyAccess((QueryVariable)conn1, key1.get(i));
                QueryExpression.PropertyAccess key2Access = new QueryExpression.PropertyAccess((QueryVariable)conn2, key2.get(i));
                join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)key1Access, (QueryExpression)key2Access));
            }
        } else {
            Pair<QueryExpression, QueryExpression> exp1 = QueryTranslator.getSrcOrDstTableAndKeyExp(pos1, conf, metadataConnector);
            Pair<QueryExpression, QueryExpression> exp2 = QueryTranslator.getSrcOrDstTableAndKeyExp(pos2, conf, metadataConnector);
            join = new QueryExpression.LogicalExpression.And((QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)exp1.first, (QueryExpression)exp2.first), (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)exp1.second, (QueryExpression)exp2.second));
        }
        return join;
    }

    private static List<String> getEdgeSrcOrDstKey(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        return QueryTranslator.getEdgeSrcOrDstKeyPair(connection, conf, metadataConnector).stream().map(pair -> (String)pair.first).collect(Collectors.toList());
    }

    private static List<Pair<String, String>> getEdgeSrcOrDstKeyPair(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        String edge = conf.get(connection.first);
        List<Pair<String, String>> key = connection.second == TranslationInfo.Position.SRC ? metadataConnector.getEdgeTableSrcKey(edge) : metadataConnector.getEdgeTableDstKey(edge);
        return key;
    }

    private static Pair<QueryExpression, QueryExpression> getSrcOrDstTableAndKeyExp(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression keyExp;
        QueryExpression tableExp;
        if (((VertexPairConnection)connection.first).getVariableType() == QueryVariable.VariableType.PATH) {
            tableExp = new QueryExpression.PropertyAccess((QueryVariable)connection.first, connection.second + "_TABLE");
            keyExp = new QueryExpression.PropertyAccess((QueryVariable)connection.first, connection.second + "_KEY");
        } else {
            tableExp = QueryTranslator.getSrcOrDstTable(connection, conf);
            keyExp = QueryTranslator.getKeyExpForPath(QueryTranslator.getEdgeSrcOrDstKey(connection, conf, metadataConnector), (QueryVariable)connection.first, conf.get(connection.first), metadataConnector);
        }
        return new Pair<QueryExpression, QueryExpression>(tableExp, keyExp);
    }

    private static QueryExpression getSrcOrDstTable(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf) {
        QueryVertex vertex = connection.second == TranslationInfo.Position.SRC ? ((VertexPairConnection)connection.first).getSrc() : ((VertexPairConnection)connection.first).getDst();
        return new QueryExpression.Constant.ConstString(conf.get(vertex));
    }

    private static QueryExpression getKeyExpForPath(List<String> keyColumns, QueryVariable variable, String tableName, MetadataConnector metadataConnector) {
        QueryExpression keyExp = null;
        boolean escapeKeyCol = keyColumns.size() > 1;
        for (String keyCol : keyColumns) {
            Object colAccess = escapeKeyCol ? ExpressionTranslator.escapePropertyForPath(variable, keyCol, tableName, metadataConnector) : new QueryExpression.PropertyAccess(variable, keyCol);
            if (keyExp == null) {
                keyExp = colAccess;
                continue;
            }
            keyExp = new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression(keyExp, (QueryExpression)new QueryExpression.Constant.ConstString(",")), colAccess);
        }
        return keyExp;
    }

    private static QueryExpression getVertexConnectionJoin(Pair<VertexPairConnection, TranslationInfo.Position> connection, QueryVertex vertex, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        if (((VertexPairConnection)connection.first).getVariableType() == QueryVariable.VariableType.EDGE) {
            List<Pair<String, String>> edgeTableKey = QueryTranslator.getEdgeSrcOrDstKeyPair(connection, conf, metadataConnector);
            return QueryTranslator.getVertexEdgeJoin(edgeTableKey, (QueryEdge)connection.first, vertex);
        }
        return QueryTranslator.getVertexPathJoin((QueryPath)connection.first, vertex, (TranslationInfo.Position)((Object)connection.second), conf, metadataConnector);
    }

    private static QueryExpression getVertexEdgeJoin(List<Pair<String, String>> edgeTableKey, QueryEdge edge, QueryVertex vertex) {
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        for (Pair<String, String> keyColumn : edgeTableKey) {
            QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)edge, (String)keyColumn.first);
            QueryExpression.PropertyAccess vertexKey = new QueryExpression.PropertyAccess((QueryVariable)vertex, (String)keyColumn.second);
            QueryExpression.RelationalExpression.Equal vertexFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)keyAccess, (QueryExpression)vertexKey);
            join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)vertexFilter);
        }
        return join;
    }

    private static QueryExpression getVertexPathJoin(QueryPath path, QueryVertex vertex, TranslationInfo.Position variableName, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression.PropertyAccess tableAccess = new QueryExpression.PropertyAccess((QueryVariable)path, (Object)((Object)variableName) + "_TABLE");
        QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)path, (Object)((Object)variableName) + "_KEY");
        String tab = conf.get(vertex);
        List<String> keyColumns = metadataConnector.getVertexTableKey(tab);
        QueryExpression vertexKey = QueryTranslator.getKeyExpForPath(keyColumns, (QueryVariable)vertex, tab, metadataConnector);
        return new QueryExpression.LogicalExpression.And((QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)tableAccess, (QueryExpression)new QueryExpression.Constant.ConstString(tab)), (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)keyAccess, vertexKey));
    }

    private static QueryExpression getEdgeKeyNotNull(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        List<String> edgeKey = QueryTranslator.getEdgeSrcOrDstKey(connection, conf, metadataConnector);
        for (String keyColumn : edgeKey) {
            QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)connection.first, keyColumn);
            QueryExpression.LogicalExpression.Not edgeFilter = new QueryExpression.LogicalExpression.Not((QueryExpression)new QueryExpression.IsNull((QueryExpression)keyAccess));
            join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)edgeFilter);
        }
        return join;
    }

    private static QueryExpression translateWhere(Set<QueryExpression> constraints, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, TranslationInfo translationInfo) {
        return constraints.stream().filter(queryExpression -> !LabelTranslator.isLabelExpression(queryExpression)).map(queryExpression -> ExpressionTranslator.translateForSubSelect(queryExpression, new ExpressionTranslator.SubSelectTransOptions(conf, metadataConnector, true, translationInfo))).reduce((QueryExpression)new QueryExpression.Constant.ConstBoolean(true), QueryExpression.LogicalExpression.And::new);
    }

    private static List<TableExpression> getTables(Set<QueryVertex> vertices, Set<VertexPairConnection> connections, Map<QueryVariable, String> variableTableMap, TranslationInfo translationInfo, MetadataConnector metadataConnector) {
        List<TableExpression> allTables = vertices.stream().filter(translationInfo::needVertexEdgeJoin).map(queryVertex -> new TableReference(metadataConnector.getSchemaQualifiedVertexTableName((String)variableTableMap.get(queryVertex)), (QueryVariable)queryVertex)).collect(Collectors.toList());
        connections.stream().filter(conn -> conn.getVariableType() == QueryVariable.VariableType.EDGE).map(conn -> (QueryEdge)conn).forEach(queryEdge -> allTables.add(new TableReference(metadataConnector.getSchemaQualifiedEdgeTableName((String)variableTableMap.get(queryEdge)), (QueryVariable)queryEdge)));
        connections.stream().filter(conn -> conn.getVariableType() == QueryVariable.VariableType.PATH).map(conn -> (QueryPath)conn).forEach(queryPath -> allTables.add(PathTranslator.translatePath(queryPath, variableTableMap, metadataConnector, translationInfo)));
        return allTables;
    }

    private static TableExpression wrapForModificators(TableExpression translation, boolean addWithClause, List<ExpAsVar> selectElements, boolean isDistinct, List<ExpAsVar> groupByElems, List<OrderByElem> orderByElems, QueryExpression havingExp, QueryExpression offsetExp, QueryExpression limitExp, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations) {
        String withClause = addWithClause ? WITH_CLAUSE : "";
        ArrayList<Pair<String, String>> newSelectElements = new ArrayList<Pair<String, String>>();
        boolean addAggregate = groupByElems.size() > 0;
        selectElements.forEach(x -> {
            if (x.getExp().getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && x.getName().startsWith("_ora_comp_key_")) {
                int numKeyColumns = Integer.parseInt(x.getName().substring(x.getName().lastIndexOf("_") + 1));
                String var = ((QueryExpression)((QueryExpression.FunctionCall)x.getExp()).getArgs().get(0)).toString();
                for (int i = 0; i < numKeyColumns; ++i) {
                    String keyColumn = PgqlUtils.escapeAndEnquoteIdentifier(var + "_" + i);
                    newSelectElements.add(new Pair<String, String>(ExpressionTranslator.aggregateIfRequired(keyColumn, addAggregate), keyColumn));
                }
            } else {
                newSelectElements.add(new Pair<String, String>(ExpressionTranslator.translateQueryExpression(x.getExp(), new ExpressionTranslator.QueryExpTransOptions(addAggregate, false, false, pathAggregations)), x.getName()));
            }
        });
        List<TableExpression> tabs = Collections.singletonList(translation);
        List<String> groupBy = groupByElems.stream().map(x -> ExpressionTranslator.translateQueryExpression(x.getExp(), new ExpressionTranslator.QueryExpTransOptions(false, true, false, pathAggregations))).collect(Collectors.toList());
        String having = havingExp == null ? null : ExpressionTranslator.translateQueryExpression(havingExp, new ExpressionTranslator.QueryExpTransOptions(true, false, false, pathAggregations));
        List<String> orderBy = orderByElems.stream().map(x -> ExpressionTranslator.translateQueryExpression(x.getExp(), new ExpressionTranslator.QueryExpTransOptions(groupByElems.size() > 0, true, false, pathAggregations)) + (x.isAscending() ? "" : " DESC")).collect(Collectors.toList());
        String offset = "";
        if (offsetExp != null) {
            if (offsetExp.getExpType() == QueryExpression.ExpressionType.INTEGER || offsetExp.getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE) {
                offset = ExpressionTranslator.translateQueryExpression(offsetExp, new ExpressionTranslator.QueryExpTransOptions(false, false, false, pathAggregations));
            } else {
                throw new IllegalArgumentException("Unexpected expression type for OFFSET");
            }
        }
        String limit = "";
        if (limitExp != null) {
            if (limitExp.getExpType() == QueryExpression.ExpressionType.INTEGER || limitExp.getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE) {
                limit = ExpressionTranslator.translateQueryExpression(limitExp, new ExpressionTranslator.QueryExpTransOptions(false, false, false, pathAggregations));
            } else {
                throw new IllegalArgumentException("Unexpected expression type for LIMIT");
            }
        }
        return new Projection(isDistinct, withClause, newSelectElements, tabs, "", groupBy, having, orderBy, offset, limit);
    }

    private static String getWithClause() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Scanner in = new Scanner(classLoader.getResourceAsStream("with_clause.sql")).useDelimiter("\\A");
        return in.next();
    }

    static List<QueryExpression> getSubSelectElements(QueryExpression exp, final Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations, final Map<QueryVariable, QueryPath> pathVariables) {
        final ArrayList<QueryExpression> subSelectElements = new ArrayList<QueryExpression>();
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.VarRef varRef) {
                QueryVariable variable = varRef.getVariable();
                if (!variable.isAnonymous()) {
                    switch (variable.getVariableType()) {
                        case VERTEX: 
                        case EDGE: {
                            subSelectElements.add(varRef);
                        }
                    }
                }
            }

            public void visit(QueryExpression.PropertyAccess prop) {
                subSelectElements.add(prop);
            }

            public void visit(QueryExpression.FunctionCall functionCall) {
                if (functionCall.getFunctionName().equalsIgnoreCase("id") || functionCall.getFunctionName().equalsIgnoreCase("label") || functionCall.getFunctionName().equalsIgnoreCase("_ora_comp_key_f_") || functionCall.getFunctionName().equalsIgnoreCase("is_source_of") || functionCall.getFunctionName().equalsIgnoreCase("is_destination_of")) {
                    subSelectElements.add(functionCall);
                } else if (functionCall.getFunctionName().equalsIgnoreCase("has_label")) {
                    subSelectElements.add(new QueryExpression.FunctionCall("label", Collections.singletonList(functionCall.getArgs().get(0))));
                    subSelectElements.addAll(QueryTranslator.getSubSelectElements((QueryExpression)functionCall.getArgs().get(1), pathAggregations, pathVariables));
                } else {
                    functionCall.getArgs().forEach(arg -> subSelectElements.addAll(QueryTranslator.getSubSelectElements(arg, pathAggregations, pathVariables)));
                }
            }

            public void visit(QueryExpression.Aggregation.AggrCount aggrCount) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrCount);
            }

            public void visit(QueryExpression.Aggregation.AggrListagg aggrListagg) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrListagg);
            }

            public void visit(QueryExpression.Aggregation.AggrMin aggrMin) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrMin);
            }

            public void visit(QueryExpression.Aggregation.AggrMax aggrMax) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrMax);
            }

            public void visit(QueryExpression.Aggregation.AggrSum aggrSum) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrSum);
            }

            public void visit(QueryExpression.Aggregation.AggrAvg aggrAvg) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrAvg);
            }

            public void visit(QueryExpression.Aggregation.AggrArrayAgg aggrArrayagg) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrArrayagg);
            }

            public void visit(QueryExpression.Aggregation.AbstractAggregation agg) {
                QueryPath queryPath = QueryTranslator.isPathAggregation((QueryExpression.Aggregation)agg, pathVariables);
                if (queryPath != null) {
                    pathAggregations.put(agg, new PathTranslator.PathAggregateInfo(queryPath, pathAggregations.size() + 1, null));
                    subSelectElements.add(agg);
                } else {
                    subSelectElements.addAll(QueryTranslator.getSubSelectElements(agg.getExp(), pathAggregations, pathVariables));
                }
            }
        });
        return subSelectElements;
    }

    private static List<QueryExpression> getAggregates(QueryExpression exp) {
        final ArrayList<QueryExpression> aggregates = new ArrayList<QueryExpression>();
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.Aggregation.AggrCount aggrCount) {
                aggregates.add(aggrCount);
            }

            public void visit(QueryExpression.Aggregation.AggrListagg aggrListagg) {
                aggregates.add(aggrListagg);
            }

            public void visit(QueryExpression.Aggregation.AggrMin aggrMin) {
                aggregates.add(aggrMin);
            }

            public void visit(QueryExpression.Aggregation.AggrMax aggrMax) {
                aggregates.add(aggrMax);
            }

            public void visit(QueryExpression.Aggregation.AggrSum aggrSum) {
                aggregates.add(aggrSum);
            }

            public void visit(QueryExpression.Aggregation.AggrAvg aggrAvg) {
                aggregates.add(aggrAvg);
            }

            public void visit(QueryExpression.Aggregation.AggrArrayAgg aggrArrayagg) {
                aggregates.add(aggrArrayagg);
            }
        });
        return aggregates;
    }

    private static QueryPath isPathAggregation(QueryExpression.Aggregation aggregation, Map<QueryVariable, QueryPath> pathVariables) {
        boolean hasAggregates = QueryTranslator.getAggregates(((QueryExpression.Aggregation.AbstractAggregation)aggregation).getExp()).size() > 0;
        for (QueryVariable variable : oracle.pgql.lang.ir.PgqlUtils.getVariables((QueryExpression)aggregation)) {
            if (!pathVariables.containsKey(variable) || hasAggregates) continue;
            return pathVariables.get(variable);
        }
        return null;
    }

    private static void addSubSelectElements(QueryExpression queryExpression, List<ExpAsVar> subSelectProj, Set<String> subSelectVars, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations, Map<QueryVariable, QueryPath> pathVariables, boolean addProjection) {
        List<QueryExpression> queryExpressions = QueryTranslator.getSubSelectElements(queryExpression, pathAggregations, pathVariables);
        for (QueryExpression exp : queryExpressions) {
            String subSelectVar;
            String escapedVar;
            if (!addProjection || subSelectVars.contains(escapedVar = PgqlUtils.escapeAndEnquoteIdentifier(subSelectVar = exp.toString()))) continue;
            subSelectProj.add(new ExpAsVar(exp, subSelectVar, false));
            subSelectVars.add(escapedVar);
        }
    }
}

