/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.pgview.translation.ExpressionTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.PathTranslator;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public class TranslationInfo {
    private final Map<QueryVariable, List<Pair<VertexPairConnection, Position>>> vertexConnections;
    private final Set<QueryVariable> varsWithProperties;
    private final Map<QueryPath, Pair<Set<QueryExpression>, Set<QueryExpression>>> pathConstraints;
    private final Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations;

    public TranslationInfo(List<ExpAsVar> subSelectElems, Set<VertexPairConnection> connections, Set<QueryExpression> constraints, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations) {
        this.pathAggregations = pathAggregations;
        this.vertexConnections = new HashMap<QueryVariable, List<Pair<VertexPairConnection, Position>>>();
        this.pathConstraints = new HashMap<QueryPath, Pair<Set<QueryExpression>, Set<QueryExpression>>>();
        connections.forEach(connection -> {
            if (connection.getVariableType() == QueryVariable.VariableType.PATH) {
                QueryPath queryPath = (QueryPath)connection;
                this.pathConstraints.put(queryPath, PathTranslator.getSrcAndDstConstraints(queryPath, constraints, pathAggregations));
            }
            this.addVertexConnection(connection.getSrc(), (VertexPairConnection)connection, Position.SRC);
            this.addVertexConnection(connection.getDst(), (VertexPairConnection)connection, Position.DST);
        });
        this.varsWithProperties = new HashSet<QueryVariable>();
        AbstractQueryExpressionVisitor visitor = new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.PropertyAccess propAccess) {
                TranslationInfo.this.varsWithProperties.add(ExpressionTranslator.getQueryVariable(propAccess.getVariable()));
            }
        };
        subSelectElems.forEach(expAsVar -> expAsVar.getExp().accept((QueryExpressionVisitor)visitor));
        constraints.forEach(c -> c.accept((QueryExpressionVisitor)visitor));
    }

    public Map<QueryVariable, List<Pair<VertexPairConnection, Position>>> getVertexConnections() {
        return this.vertexConnections;
    }

    public Pair<Set<QueryExpression>, Set<QueryExpression>> getPathConstraints(QueryPath queryPath) {
        return this.pathConstraints.get(queryPath);
    }

    public Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> getPathAggregations() {
        return this.pathAggregations;
    }

    public boolean needVertexEdgeJoin(QueryVariable vertex) {
        return this.varsWithProperties.contains(vertex) || this.getEdgeConnection(vertex) == null;
    }

    private void addVertexConnection(QueryVertex vertex, VertexPairConnection connection, Position position) {
        if (!this.vertexConnections.containsKey(vertex)) {
            this.vertexConnections.put((QueryVariable)vertex, new ArrayList());
        }
        this.vertexConnections.get(vertex).add(new Pair<VertexPairConnection, Position>(connection, position));
    }

    public Pair<VertexPairConnection, Position> getEdgeConnection(QueryVariable vertex) {
        if (this.vertexConnections.containsKey(vertex)) {
            for (Pair<VertexPairConnection, Position> connection : this.vertexConnections.get(vertex)) {
                if (((VertexPairConnection)connection.first).getVariableType() != QueryVariable.VariableType.EDGE) continue;
                return connection;
            }
        }
        return null;
    }

    public static enum Position {
        SRC,
        DST;

    }
}

