/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.translation.expression.InsertionBlock;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;

public class ElementInsertion
extends TableExpression {
    private final String variableName;
    private final String tableName;
    private final List<String> key;
    private final List<String> columns;
    private final List<String> values;

    public ElementInsertion(String variableName, String tableName, List<String> key) {
        this.variableName = variableName;
        this.tableName = tableName;
        this.key = key;
        this.columns = new ArrayList<String>();
        this.values = new ArrayList<String>();
    }

    public void addValue(String value, String column) {
        this.values.add(value);
        this.columns.add(column);
    }

    public void addVariablesToBlock(InsertionBlock insertionBlock) {
        this.key.forEach(keyColumn -> insertionBlock.addVariable(PgqlUtils.escapeAndEnquoteIdentifier(this.variableName + "_" + keyColumn), this.tableName, PgqlUtils.escapeAndEnquoteIdentifier(keyColumn), false));
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String prettyPrint() {
        String keyCols = this.key.stream().map(PgqlUtils::escapeAndEnquoteIdentifier).collect(Collectors.joining(", "));
        List keyVars = this.key.stream().map(keyColumn -> PgqlUtils.escapeAndEnquoteIdentifier(this.variableName + "_" + keyColumn)).collect(Collectors.toList());
        String nullCheck = keyVars.stream().map(keyVar -> keyVar + " IS NULL ").collect(Collectors.joining(" or "));
        return "    INSERT INTO " + this.tableName + "(" + String.join((CharSequence)", ", this.columns) + ")\n      VALUES(" + String.join((CharSequence)", ", this.values) + ")\n      RETURNING " + keyCols + " INTO " + String.join((CharSequence)", ", keyVars) + ";\n    if " + nullCheck + " then\n      raise_application_error(-20000, " + DbmsUtils.escapeAndEnquoteLiteral("Cannot insert element " + this.variableName + ". Please, provide non-null key values.", false) + ");\n    end if;\n    cnt := cnt + 1;\n";
    }
}

