/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation.expression;

import java.util.List;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.translation.expression.EmptyProjection;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;
import oracle.pg.rdbms.pgql.pgview.translation.expression.Union;
import oracle.pg.rdbms.pgql.pgview.util.Pair;

public class Projection
extends TableExpression {
    private final boolean isDistinct;
    private final String withClause;
    private final List<Pair<String, String>> selectElements;
    private final List<TableExpression> tables;
    private final String whereExpression;
    private final List<String> groupByElements;
    private final String havingExpression;
    private final List<String> orderByElements;
    private final String offset;
    private final String limit;
    private final boolean isWrapperQuery;

    public Projection(boolean isDistinct, String withClause, List<Pair<String, String>> selectElements, List<TableExpression> tables, String whereExpression, List<String> groupByElements, String havingExpression, List<String> orderByElements, String offset, String limit) {
        this.isDistinct = isDistinct;
        this.withClause = withClause;
        this.selectElements = selectElements;
        this.tables = tables;
        this.whereExpression = whereExpression;
        this.groupByElements = groupByElements;
        this.havingExpression = havingExpression;
        this.orderByElements = orderByElements;
        this.offset = offset;
        this.limit = limit;
        this.isWrapperQuery = tables.stream().anyMatch(x -> x instanceof Projection || x instanceof Union || x instanceof EmptyProjection);
    }

    @Override
    public String prettyPrint() {
        String limitString;
        String distinctString = this.isDistinct ? "DISTINCT " : "";
        String selectString = this.selectElements.isEmpty() ? "1" : this.selectElements.stream().map(this::getSelectForm).collect(Collectors.joining(", "));
        String fromString = this.tables.stream().map(TableExpression::prettyPrint).collect(Collectors.joining(", "));
        String whereString = this.getWhereString();
        String groupByString = this.getGroupByString();
        String havingString = this.havingExpression == null ? "" : "\nHAVING " + this.havingExpression;
        String orderByString = this.getOrderByString();
        String offsetString = "".equals(this.offset) ? "" : "\nOFFSET " + this.offset + " ROWS";
        String string = limitString = "".equals(this.limit) ? "" : "\nFETCH NEXT " + this.limit + " ROWS ONLY";
        if (this.isWrapperQuery) {
            fromString = "(" + fromString + ")";
        }
        return this.withClause + "SELECT " + distinctString + selectString + "\nFROM " + fromString + whereString + groupByString + havingString + orderByString + offsetString + limitString;
    }

    private String getSelectForm(Pair<String, String> selectable) {
        if (selectable.second == null) {
            return (String)selectable.first;
        }
        String alias = PgqlUtils.escapeAndEnquoteIdentifier((String)selectable.second);
        if (selectable.first == null) {
            return alias;
        }
        return (String)selectable.first + " AS " + alias;
    }

    private String getWhereString() {
        if (this.whereExpression.isEmpty()) {
            return this.whereExpression;
        }
        return "\nWHERE " + this.whereExpression;
    }

    private String getGroupByString() {
        String groupByString = "";
        if (this.groupByElements.size() > 0) {
            groupByString = "\nGROUP BY " + this.groupByElements.stream().collect(Collectors.joining(", "));
        }
        return groupByString;
    }

    private String getOrderByString() {
        String orderByString = "";
        if (this.orderByElements.size() > 0) {
            orderByString = "\nORDER BY " + this.orderByElements.stream().collect(Collectors.joining(", "));
        }
        return orderByString;
    }
}

