/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ddl.propertygraph;

import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.StatementType;

public class CreateExternalSchema
implements PgqlStatement {
    private String localSchemaName;
    private String url;
    private String userName;
    private String keystoreAlias;
    private String dataSourceName;
    private String remoteSchemaName;

    public CreateExternalSchema(String localSchemaName, String url, String userName, String keystoreAlias, String remoteSchemaName) {
        this.localSchemaName = localSchemaName;
        this.url = url;
        this.userName = userName;
        this.keystoreAlias = keystoreAlias;
        this.remoteSchemaName = remoteSchemaName;
    }

    public CreateExternalSchema(String localSchemaName, String dataSourceName, String remoteSchemaName) {
        this.localSchemaName = localSchemaName;
        this.dataSourceName = dataSourceName;
        this.remoteSchemaName = remoteSchemaName;
    }

    public String getLocalSchemaName() {
        return this.localSchemaName;
    }

    public void setLocalSchemaName(String localSchemaName) {
        this.localSchemaName = localSchemaName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getKeystoreAlias() {
        return this.keystoreAlias;
    }

    public void setKeystoreAlias(String keystoreAlias) {
        this.keystoreAlias = keystoreAlias;
    }

    public String getRemoteSchemaName() {
        return this.remoteSchemaName;
    }

    public void setRemoteSchemaName(String remoteSchemaName) {
        this.remoteSchemaName = remoteSchemaName;
    }

    public String toString() {
        String separator = "\n  ";
        String result = "CREATE EXTERNAL SCHEMA " + PgqlUtils.printIdentifier(this.localSchemaName, false) + "\nFROM DATABASE";
        if (this.url != null) {
            result = result + separator + "URL " + PgqlUtils.printLiteral(this.url);
        }
        if (this.userName != null) {
            result = result + separator + "USER " + PgqlUtils.printLiteral(this.userName);
        }
        if (this.keystoreAlias != null) {
            result = result + separator + "KEYSTORE_ALIAS " + PgqlUtils.printLiteral(this.keystoreAlias);
        }
        if (this.dataSourceName != null) {
            result = result + separator + "DATA_SOURCE " + PgqlUtils.printLiteral(this.dataSourceName);
        }
        if (this.remoteSchemaName != null) {
            result = result + separator + "SCHEMA " + PgqlUtils.printLiteral(this.remoteSchemaName);
        }
        return result;
    }

    @Override
    public StatementType getStatementType() {
        return StatementType.CREATE_EXTERNAL_SCHEMA;
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateExternalSchema other = (CreateExternalSchema)obj;
        if (this.dataSourceName == null ? other.dataSourceName != null : !this.dataSourceName.equals(other.dataSourceName)) {
            return false;
        }
        if (this.keystoreAlias == null ? other.keystoreAlias != null : !this.keystoreAlias.equals(other.keystoreAlias)) {
            return false;
        }
        if (this.localSchemaName == null ? other.localSchemaName != null : !this.localSchemaName.equals(other.localSchemaName)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        if (this.userName == null ? other.userName != null : !this.userName.equals(other.userName)) {
            return false;
        }
        return !(this.remoteSchemaName == null ? other.remoteSchemaName != null : !this.remoteSchemaName.equals(other.remoteSchemaName));
    }
}

